package test;
import net.ivoa.www.xml.ADQL.v0_7_4.*;
import net.ivoa.adql.parser.ws.ADQLTranslator;
import net.ivoa.adql.parser.ws.ADQLTranslatorLocator;
import net.ivoa.adql.parser.ws.ADQLTranslatorSoap;
public class TestParser
{
    	
	public static void main(String [] args) throws Exception {

	System.out.println("Testing ");
	System.out.println(args[0]);

	ADQLTranslator translatorSrv = new ADQLTranslatorLocator();
	
	String addr = "http://skyservice.pha.jhu.edu/devel/AdqlTranslator/ADQLTrans.asmx";
	java.net.URL url = new java.net.URL(addr);
	ADQLTranslatorSoap soap = translatorSrv.getADQLTranslatorSoap(url);
	
	trace("======== Test 1 ======");
	trace(" Translating ==> " + args[0]);	
	SelectType sel  = soap.SQLtoADQL(args[0]);
	
	trace("Getting back SQL from the Translated String ==>");
	String strRes = soap.ADQLtoSQL(sel);
	trace(strRes);

	trace("Translating to an ADQL, as a string ==>");
	String strAdql = soap.SQLtoADQLString(args[0]);
	System.out.println(" ADQL =>");
	System.out.println(strAdql);
	trace("======== Now for my test Query======");
	String strNewSQL = soap.ADQLtoSQL(getMyTestQuery());
	trace(strNewSQL);
	trace("===== Thats it======");

	
  	}
  	
	public static void trace(String strTrace)
	{
		System.out.println(strTrace);
	}
	public static void displayStructure(SelectType sel)
	{
	
		trace("displayStructure() BEGIN");
		ADQLDebugger dbg = new ADQLDebugger();
		dbg.Display(sel);		
		trace("displayStructure() END");

	}
	
	public static SelectType getMyTestQuery()
	{
		/*Select a.ra from tab a*/
		
		SelectType sel = new SelectType();
		
		ColumnReferenceType col1 = new ColumnReferenceType();
		col1.setTable("a");
		col1.setName("ra");
		
		ColumnReferenceType col2 = new ColumnReferenceType();
		col2.setTable("b");
		col2.setName("dec");
		
		SelectionItemType[] sarr = new SelectionItemType[2];
		sarr[0] = col1;
		sarr[1] = col2;
		
		SelectionListType list = new SelectionListType();
		list.setItem(sarr);
		
		
		FromType from = new FromType();
		TableType tab = new TableType();
		tab.setName("tab");
		tab.setAlias("a");
		TableType tab2 = new TableType();
		tab2.setName("bob");
		tab2.setAlias("b");
		FromTableType[] tarr = new FromTableType[2];
		tarr[0] = tab;
		tarr[1] = tab2;
		
		from.setTable(tarr);
		
		sel.setSelectionList(list);		
		sel.setFrom(from); 
		return sel;
	}
}
