/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc1D;
import cds.moc.MocCell;
import cds.moc.Range;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

public abstract class Moc
implements Iterable<MocCell>,
Cloneable,
Comparable<Moc> {
    public static final String VERSION = "6.2";
    public static final int RAW = 0;
    public static final int COMPRESS_SINGLETON = 1;
    private static final int UNKNOWN = -1;
    public static final int FITS = 0;
    public static final int ASCII = 1;
    public static final int JSON = 2;
    protected int cacheNbCells;
    protected int cacheDeepestOrder;
    protected int cacheHashCode;
    protected LinkedHashMap<String, String> property;
    protected HashMap<String, String> comment;
    public static final int LOGIC_MIN = 0;
    public static final int LOGIC_MAX = 1;
    private static int mocOrderLogic = 1;
    private boolean flagCDim = false;
    protected static String CR = System.getProperty("line.separator");
    public static final String[] unites = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB"};
    public static long MASK_COMP = 0x4000000000000000L;
    public static long UNMASK_COMP = MASK_COMP ^ 0xFFFFFFFFFFFFFFFFL;
    protected static final int MAXWORD = 20;
    protected static final int MAXSIZE = 80;
    private String[] FITSKEY_RESERVED = new String[]{"SIMPLE", "BITPIX", "NAXIS", "EXTEND", "XTENSION", "NAXIS1", "NAXIS2", "PCOUNT", "GCOUNT", "TFIELDS", "TFORM1"};
    private String[] MOCKEY_RESERVED = new String[]{"MOCVERS", "MOCDIM", "ORDERING", "COORDSYS", "TIMESYS", "MOCORDER", "MOCORD_S", "MOCORD_T", "MOCTOOL"};

    public static int getMocOrderLogic() {
        return mocOrderLogic;
    }

    public static void setMocOrderLogic(int logic) {
        mocOrderLogic = logic;
    }

    public static Moc createMoc(String s) throws Exception {
        if (s == null) {
            throw new Exception("Null string MOC");
        }
        if (s.length() == 0) {
            throw new Exception("Empty string MOC");
        }
        int is = s.indexOf(115);
        int it = s.indexOf(116);
        Moc moc = it != -1 && is != -1 ? new STMoc() : (it != -1 ? new TMoc() : new SMoc());
        moc.add(s);
        moc.add(null);
        return moc;
    }

    public static Moc createMoc(InputStream in) throws Exception {
        Moc moc = null;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, 32768);
        }
        in.mark(10);
        byte[] b = new byte[1];
        in.read(b);
        in.reset();
        boolean mode = b[0] != 83;
        in.mark(32768);
        if (mode) {
            b = new byte[512];
            int n = in.read(b);
            in.reset();
            String s = new String(b, 0, n);
            int is = s.indexOf(115);
            int it = s.indexOf(116);
            moc = it != -1 && is != -1 ? new STMoc() : (it != -1 ? new TMoc() : new SMoc());
            moc.readASCII(in);
        } else {
            HeaderFits header = new SMoc().new HeaderFits();
            header.readHeader(in);
            header.readHeader(in);
            in.reset();
            String dim = header.getStringFromHeader("MOCDIM");
            if (dim == null) {
                dim = header.getStringFromHeader("MOC");
            }
            if (dim != null) {
                if (dim.equals("TIME")) {
                    moc = new TMoc();
                } else if (dim.equals("TIME.SPACE")) {
                    moc = new STMoc();
                }
            }
            if (moc == null && header.getStringFromHeader("TIMESYS") != null) {
                moc = new TMoc();
            }
            if (moc == null) {
                moc = new SMoc();
            }
            moc.readFITS(in);
        }
        return moc;
    }

    public void setSpaceOrder(int order) throws Exception {
        if (this instanceof SMoc) {
            ((SMoc)this).setMocOrder(order);
        } else if (this instanceof STMoc) {
            ((STMoc)this).setSpaceOrder(order);
        } else {
            throw new Exception("No Space dimension");
        }
    }

    public void setTimeOrder(int order) throws Exception {
        if (this instanceof TMoc) {
            ((TMoc)this).setMocOrder(order);
        } else if (this instanceof STMoc) {
            ((STMoc)this).setTimeOrder(order);
        } else {
            throw new Exception("No Time dimension");
        }
    }

    public int getSpaceOrder() {
        try {
            if (this instanceof SMoc) {
                return ((SMoc)this).getMocOrder();
            }
            if (this instanceof STMoc) {
                return ((STMoc)this).getSpaceOrder();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public int getTimeOrder() {
        try {
            if (this instanceof TMoc) {
                return ((TMoc)this).getMocOrder();
            }
            if (this instanceof STMoc) {
                return ((STMoc)this).getTimeOrder();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public SMoc getSpaceMoc() throws Exception {
        if (this instanceof SMoc) {
            return (SMoc)this;
        }
        if (this instanceof STMoc) {
            return ((STMoc)this).getSpaceMoc();
        }
        throw new Exception("No Space dimension");
    }

    public TMoc getTimeMoc() throws Exception {
        if (this instanceof TMoc) {
            return (TMoc)this;
        }
        if (this instanceof STMoc) {
            return ((STMoc)this).getTimeMoc();
        }
        throw new Exception("No Time dimension");
    }

    public STMoc getSpaceTimeMoc() throws Exception {
        return STMoc.asSTMoc(this);
    }

    public boolean isSpace() {
        return this instanceof SMoc || this instanceof STMoc;
    }

    public boolean isTime() {
        return this instanceof TMoc || this instanceof STMoc;
    }

    public Moc() {
        this.property = new LinkedHashMap();
        this.comment = new HashMap();
        this.clear();
    }

    public abstract Moc clone() throws CloneNotSupportedException;

    public abstract Moc dup();

    public String toString() {
        try {
            return this.toASCII();
        }
        catch (Exception e) {
            return null;
        }
    }

    public abstract String toDebug();

    public void add(String s) throws Exception {
        if (s == null || s.length() == 0) {
            this.addToken(null);
            return;
        }
        s = this.json2ASCII(s);
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            if (s1.length() == 0) continue;
            this.addToken(s1);
        }
    }

    protected String json2ASCII(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder res = new StringBuilder();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ((!this.flagCDim || Character.isDigit(c)) && "{}[]\"".indexOf(c) < 0) {
                boolean bl = this.flagCDim = c == 't' || c == 's';
                if (c == ',') {
                    c = ' ';
                }
                if (c == ':') {
                    c = '/';
                }
                res.append(c);
            }
            ++n2;
        }
        return res.toString();
    }

    public void clear() {
        this.cacheNbCells = -1;
        this.cacheDeepestOrder = -1;
        this.cacheHashCode = -1;
    }

    public abstract void flush();

    public abstract boolean reduction(long var1) throws Exception;

    public abstract boolean isEmpty();

    public abstract boolean isFull();

    public abstract double getCoverage();

    public abstract long getMem();

    public int getDeepestOrder() {
        if (this.cacheDeepestOrder == -1) {
            this.computeHierarchy();
        }
        return this.cacheDeepestOrder;
    }

    @Override
    public int compareTo(Moc o) {
        if (o == null) {
            return 1;
        }
        double d = this.getCoverage() - o.getCoverage();
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public abstract int getNbRanges();

    public abstract void setRangeList(Range var1);

    public abstract Range seeRangeList();

    @Override
    public Iterator<MocCell> iterator() {
        return this.cellIterator(false);
    }

    public abstract Iterator<MocCell> cellIterator(boolean var1);

    protected void clone1(Moc moc) throws CloneNotSupportedException {
        this.flush();
        moc.property = (LinkedHashMap)this.property.clone();
        moc.comment = (HashMap)this.comment.clone();
        moc.cacheNbCells = this.cacheNbCells;
        moc.cacheDeepestOrder = this.cacheDeepestOrder;
    }

    protected abstract void addToken(String var1) throws Exception;

    protected int getMocOrder4op(int m1, int m2) {
        if (m1 == -1) {
            return m2;
        }
        if (m2 == -1) {
            return m1;
        }
        if (mocOrderLogic == 1) {
            return Math.max(m1, m2);
        }
        return Math.min(m1, m2);
    }

    public int getNbCells() {
        if (this.cacheNbCells == -1) {
            this.computeHierarchy();
        }
        return this.cacheNbCells;
    }

    protected void resetCache() {
        this.cacheNbCells = -1;
        this.cacheDeepestOrder = -1;
        this.cacheHashCode = -1;
    }

    protected abstract void computeHierarchy();

    public void accretion() throws Exception {
    }

    public void setProperty(String key, String value) throws Exception {
        this.setProperty(key, value, null);
    }

    public void setProperty(String key, String value, String comment) throws Exception {
        if (key.length() > 8) {
            throw new Exception("Property error: Too long property key word (<= 8 characters) [" + key + "]");
        }
        char[] cArray = key.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_')) {
                throw new Exception("Property error: keyword character not allowd (only 'A'\u2013'Z'|'0'\u2013'9'|'-'|'_')  [" + key + "]");
            }
            ++n2;
        }
        if (this.isReservedFitsKeyWords(key)) {
            throw new Exception("Property error: Reserved FITS key word [" + key + "]");
        }
        this.property.put(key, value);
        if (comment == null) {
            this.comment.remove(key);
        } else {
            this.comment.put(key, comment);
        }
    }

    public String[] getPropertyKeys() {
        String[] a = new String[this.property.size()];
        int i = 0;
        for (String key : this.property.keySet()) {
            a[i++] = key;
        }
        return a;
    }

    public String getProperty(String key) {
        return this.property.get(key);
    }

    public String getComment(String key) {
        return this.comment.get(key);
    }

    public abstract boolean isIncluding(Moc var1) throws Exception;

    public abstract boolean isIntersecting(Moc var1) throws Exception;

    public Moc union(Moc moc) throws Exception {
        return this.operation(moc, 0);
    }

    public Moc intersection(Moc moc) throws Exception {
        return this.operation(moc, 1);
    }

    public Moc subtraction(Moc moc) throws Exception {
        return this.operation(moc, 2);
    }

    public Moc difference(Moc moc) throws Exception {
        Moc inter = this.intersection(moc);
        Moc union = this.union(moc);
        return union.subtraction(inter);
    }

    public abstract Moc complement() throws Exception;

    protected abstract Moc operation(Moc var1, int var2) throws Exception;

    public void read(String filename) throws Exception {
        File f = new File(filename);
        FileInputStream fi = null;
        BufferedInputStream bf = null;
        try {
            fi = new FileInputStream(f);
            bf = new BufferedInputStream(fi);
            this.read(bf);
        }
        finally {
            if (bf != null) {
                bf.close();
            } else if (fi != null) {
                fi.close();
            }
        }
    }

    public void read(InputStream in) throws Exception {
        this.read(in, -1);
    }

    public void read(InputStream in, int mode) throws Exception {
        Object bis = null;
        if (mode == -1 && !in.markSupported()) {
            in = new BufferedInputStream(in, 32768);
        }
        in.mark(10);
        byte[] b = new byte[1];
        in.read(b);
        in.reset();
        int n = mode = b[0] == 83 ? 0 : 1;
        if (mode == 0) {
            this.readFITS(in);
        } else {
            this.readASCII(in);
        }
        this.resetCache();
    }

    public void readJSON(InputStream in) throws Exception {
        this.readASCII(in);
    }

    public void readASCII(InputStream in) throws Exception {
        String s;
        this.clear();
        BufferedReader dis = new BufferedReader(new InputStreamReader(in));
        while ((s = dis.readLine()) != null) {
            if (s.length() == 0 || s.charAt(0) == '#') continue;
            this.add(s);
        }
        this.add(null);
        this.resetCache();
    }

    public void readFITS(InputStream in) throws Exception {
        this.clear();
        HeaderFits header = new HeaderFits();
        header.readHeader(in);
        header.readHeader(in);
        this.readBinary(header, in);
    }

    private void readBinary(HeaderFits header, InputStream in) throws Exception {
        int nbyte;
        int naxis1 = header.getIntFromHeader("NAXIS1");
        int naxis2 = header.getIntFromHeader("NAXIS2");
        String tform = header.getStringFromHeader("TFORM1");
        int n = tform.indexOf(75) >= 0 ? 8 : (nbyte = tform.indexOf(74) >= 0 ? 4 : -1);
        if (nbyte <= 0) {
            throw new Exception("Multi Order Coverage Map only requieres integers (32bits or 64bits)");
        }
        for (String k : header) {
            if (this.isReservedFitsKeyWords(k)) continue;
            this.setProperty(k, header.getStringFromHeader(k));
        }
        this.readSpecificData(in, naxis1, naxis2, nbyte, header);
        this.resetCache();
    }

    protected abstract void readSpecificData(InputStream var1, int var2, int var3, int var4, HeaderFits var5) throws Exception;

    public abstract void readSpecificDataRange(int var1, byte[] var2, int var3) throws Exception;

    public void write(String filename) throws Exception {
        this.write(filename, 0);
    }

    public void writeFITS(String filename) throws Exception {
        this.write(filename, 0);
    }

    public void writeASCII(String filename) throws Exception {
        this.write(filename, 1);
    }

    public void writeJSON(String filename) throws Exception {
        this.write(filename, 2);
    }

    public void write(String filename, int mode) throws Exception {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new Exception("Unknown MOC format !");
        }
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream fo = null;
        FilterOutputStream fb = null;
        try {
            fo = new FileOutputStream(f);
            fb = new BufferedOutputStream(fo);
            this.write(fb, mode);
        }
        finally {
            if (fb != null) {
                fb.close();
            } else if (fo != null) {
                fo.close();
            }
        }
    }

    public void write(OutputStream out, int mode) throws Exception {
        if (mode == 0) {
            this.writeFITS(out);
        } else if (mode == 2) {
            this.writeJSON(out);
        } else if (mode == 1) {
            this.writeASCII(out);
        } else {
            throw new Exception("Unknown MOC format !");
        }
    }

    public void write(OutputStream out) throws Exception {
        this.writeFITS(out);
    }

    public abstract void writeASCII(OutputStream var1) throws Exception;

    public abstract void writeJSON(OutputStream var1) throws Exception;

    public void writeFITS(OutputStream out) throws Exception {
        this.writeHeader0(out);
        this.writeHeader1(out);
        this.writeData(out);
    }

    public static final String getUnitDisk(long val) {
        return Moc.getUnitDisk(val, 0, 2);
    }

    public static final String getUnitDisk(long val, int unit, int format) {
        long rest = 0L;
        boolean neg = false;
        if (val < 0L) {
            neg = true;
            val = -val;
        }
        while (val >= 1024L && unit < unites.length - 1) {
            ++unit;
            long div = val / 1024L;
            rest = val % 1024L;
            val = div;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(format);
        double x = (double)val + (double)rest / 1024.0;
        return String.valueOf(neg ? "-" : "") + nf.format(x) + unites[unit];
    }

    protected boolean isCodedComp(long a) {
        return (a & MASK_COMP) != 0L;
    }

    protected long codeComp(long a) {
        return a | MASK_COMP;
    }

    protected long decodeComp(long a) {
        return a & UNMASK_COMP;
    }

    protected long[] compressRange(Range range, long unit) {
        int j = 0;
        int i = 0;
        while (i < range.sz) {
            j = range.r[i] + unit == range.r[i + 1] ? ++j : (j += 2);
            i += 2;
        }
        long[] r = new long[j];
        if (j == range.sz) {
            System.arraycopy(range.r, 0, r, 0, j);
        } else {
            j = 0;
            int i2 = 0;
            while (i2 < range.sz) {
                if (range.r[i2] + unit == range.r[i2 + 1]) {
                    r[j++] = this.codeComp(range.r[i2]);
                } else {
                    r[j++] = range.r[i2];
                    r[j++] = range.r[i2 + 1];
                }
                i2 += 2;
            }
        }
        return r;
    }

    protected Range uncompressRange(long[] r, long unit) {
        return this.uncompressRange(r, r.length, unit);
    }

    protected Range uncompressRange(long[] r, int sz, long unit) {
        Range range = new Range(sz);
        int i = 0;
        while (i < sz) {
            if (this.isCodedComp(r[i])) {
                long start = this.decodeComp(r[i]);
                range.push(start);
                range.push(start + unit);
            } else {
                range.push(r[i]);
            }
            ++i;
        }
        range.trimSize();
        return range;
    }

    public String toASCII() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeASCII(out);
        return out.toString();
    }

    public String toJSON() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeJSON(out);
        return out.toString();
    }

    protected static int writeASCII(OutputStream out, Moc1D moc, boolean flagNL, boolean flagRange) throws Exception {
        if (moc.isEmpty()) {
            return -1;
        }
        StringBuilder res = new StringBuilder(50000);
        int order = -1;
        int sizeLine = 0;
        int j = 0;
        Iterator<MocCell> it = moc.cellIterator(flagRange);
        while (it.hasNext()) {
            boolean flagNewOrder;
            MocCell cell = it.next();
            StringBuilder s = new StringBuilder(100);
            boolean bl = flagNewOrder = cell.order != order;
            if (flagNewOrder) {
                s.append(String.valueOf(cell.order) + "/");
                order = cell.order;
            }
            s.append(String.valueOf(cell.start));
            if (cell.end > cell.start + 1L) {
                s.append("-" + (cell.end - 1L));
            }
            if (res.length() > 0) {
                if (flagNewOrder) {
                    if (flagNL) {
                        res.append(CR);
                        sizeLine = 0;
                        ++j;
                    } else {
                        res.append(" ");
                    }
                } else if (flagNL && s.length() + sizeLine > 80) {
                    res.append(String.valueOf(CR) + " ");
                    sizeLine = 1;
                    ++j;
                } else {
                    res.append(' ');
                    ++sizeLine;
                }
                if (j > 15) {
                    Moc.writeASCIIFlush(out, res, false);
                    j = 0;
                }
            }
            res.append((CharSequence)s);
            sizeLine += s.length();
        }
        Moc.writeASCIIFlush(out, res, false);
        return order;
    }

    protected static void writeASCIIFlush(OutputStream out, StringBuilder s, boolean nl) throws Exception {
        if (nl) {
            s.append(CR);
        }
        out.write(s.toString().getBytes());
        s.delete(0, s.length());
    }

    public abstract int sizeOfCoding();

    public abstract int getNbCoding();

    private void writeHeader0(OutputStream out) throws Exception {
        int n = 0;
        out.write(Moc.getFitsLine("SIMPLE", "T", "Written by MOC java API 6.2"));
        n += 80;
        out.write(this.getFitsLine("BITPIX", "8"));
        n += 80;
        out.write(this.getFitsLine("NAXIS", "0"));
        n += 80;
        out.write(this.getFitsLine("EXTEND", "T"));
        out.write(this.getEndBourrage(n += 80));
    }

    private boolean isReservedFitsKeyWords(String k) {
        String[] stringArray = this.FITSKEY_RESERVED;
        int n = this.FITSKEY_RESERVED.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(k)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isReservedMocKeyWords(String k) {
        String[] stringArray = this.MOCKEY_RESERVED;
        int n = this.MOCKEY_RESERVED.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(k)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void writeHeader1(OutputStream out) throws Exception {
        int n = 0;
        int nbytes = this.sizeOfCoding();
        int naxis2 = this.getNbCoding();
        out.write(Moc.getFitsLine("XTENSION", "BINTABLE", "Multi Order Coverage map"));
        n += 80;
        out.write(this.getFitsLine("BITPIX", "8"));
        n += 80;
        out.write(this.getFitsLine("NAXIS", "2"));
        n += 80;
        out.write(this.getFitsLine("NAXIS1", String.valueOf(nbytes)));
        n += 80;
        out.write(this.getFitsLine("NAXIS2", "" + naxis2));
        n += 80;
        out.write(this.getFitsLine("PCOUNT", "0"));
        n += 80;
        out.write(this.getFitsLine("GCOUNT", "1"));
        n += 80;
        out.write(this.getFitsLine("TFIELDS", "1"));
        n += 80;
        out.write(this.getFitsLine("TFORM1", nbytes == 4 ? "1J" : "1K"));
        n += 80;
        out.write(Moc.getFitsLine("MOCVERS", "2.0", "MOC version", true));
        n += 80;
        n += this.writeSpecificFitsProp(out);
        out.write(Moc.getFitsLine("MOCTOOL", "CDSjavaAPI-6.2", "Name of the MOC generator"));
        n += 80;
        String[] stringArray = this.getPropertyKeys();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String key = stringArray[n3];
            if (!this.isReservedFitsKeyWords(key) && !this.isReservedMocKeyWords(key)) {
                String value = this.getProperty(key);
                String comment = this.getComment(key);
                out.write(Moc.getFitsLine(key, value, comment));
                n += 80;
            }
            ++n3;
        }
        out.write(this.getEndBourrage(n));
    }

    protected abstract int writeSpecificFitsProp(OutputStream var1) throws Exception;

    protected void writeData(OutputStream out) throws Exception {
        int size = this.writeSpecificData(out);
        out.write(Moc.getBourrage(size));
    }

    protected int writeSpecificData(OutputStream out) throws Exception {
        return this.writeSpecificDataRange(out, 0);
    }

    public abstract int writeSpecificDataRange(OutputStream var1, int var2) throws Exception;

    protected static int writeVal(OutputStream out, long val, byte[] buf) throws Exception {
        int j = 0;
        int shift = (buf.length - 1) * 8;
        while (j < buf.length) {
            buf[j] = (byte)(0xFFL & val >> shift);
            ++j;
            shift -= 8;
        }
        if (out != null) {
            out.write(buf);
        }
        return buf.length;
    }

    protected static long readLong(byte[] t, int i) {
        int a = t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
        int b = t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF;
        long val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
        return val;
    }

    public static long hpix2uniq(int order, long npix) {
        long nside = Moc.pow2(order);
        return 4L * nside * nside + npix;
    }

    public static long[] uniq2hpix(long uniq) {
        return Moc.uniq2hpix(uniq, null);
    }

    public static long[] uniq2hpix(long uniq, long[] hpix) {
        if (hpix == null) {
            hpix = new long[2];
        }
        hpix[0] = Moc.log2(uniq / 4L) / 2L;
        long nside = Moc.pow2(hpix[0]);
        hpix[1] = uniq - 4L * nside * nside;
        return hpix;
    }

    public static final long pow2(long order) {
        return 1L << (int)order;
    }

    public static final long log2(long nside) {
        int i = 0;
        while (nside >>> ++i > 0L) {
        }
        return --i;
    }

    private byte[] getFitsLine(String key, String value) {
        return Moc.getFitsLine(key, value, null);
    }

    protected static byte[] getFitsLine(String key, String value, String comment) {
        return Moc.getFitsLine(key, value, comment, false);
    }

    protected static byte[] getFitsLine(String key, String value, String comment, boolean forceStringMode) {
        int i = 0;
        byte[] b = new byte[80];
        char[] a = key.toCharArray();
        int j = 0;
        while (i < 8) {
            b[i] = (byte)(j < a.length ? a[j] : 32);
            ++j;
            ++i;
        }
        if (value != null) {
            b[i++] = 61;
            b[i++] = 32;
            a = value.toCharArray();
            if (!forceStringMode && !Moc.isFitsString(value)) {
                j = 0;
                while (j < 20 - a.length) {
                    b[i++] = 32;
                    ++j;
                }
                j = 0;
                while (i < 80 && j < a.length) {
                    b[i] = (byte)a[j];
                    ++j;
                    ++i;
                }
            } else {
                a = Moc.formatFitsString(a);
                j = 0;
                while (i < 80 && j < a.length) {
                    b[i] = (byte)a[j];
                    ++j;
                    ++i;
                }
                while (i < 30) {
                    b[i++] = 32;
                }
            }
        }
        if (comment != null && comment.length() > 0) {
            if (value != null) {
                b[i++] = 32;
                b[i++] = 47;
                b[i++] = 32;
            }
            a = comment.toCharArray();
            j = 0;
            while (i < 80 && j < a.length) {
                b[i] = (byte)a[j];
                ++j;
                ++i;
            }
        }
        while (i < 80) {
            b[i++] = 32;
        }
        return b;
    }

    private byte[] getEndBourrage(int headSize) {
        int size = 2880 - headSize % 2880;
        if (size < 3) {
            size += 2880;
        }
        byte[] b = new byte[size];
        b[0] = 69;
        b[1] = 78;
        b[2] = 68;
        int i = 3;
        while (i < b.length) {
            b[i] = 32;
            ++i;
        }
        return b;
    }

    protected static byte[] getBourrage(int currentPos) {
        int size = 2880 - currentPos % 2880;
        byte[] b = new byte[size];
        return b;
    }

    public static void readFully(InputStream in, byte[] buf) throws IOException {
        Moc.readFully(in, buf, 0, buf.length);
    }

    public static void readFully(InputStream in, byte[] buf, int offset, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int m = in.read(buf, offset + n, len - n < 512 ? len - n : 512);
            if (m == -1) {
                throw new EOFException();
            }
            n += m;
        }
    }

    private static boolean isFitsString(String s) {
        if (s.length() == 0) {
            return true;
        }
        char c = s.charAt(0);
        if (s.length() == 1 && (c == 'T' || c == 'F')) {
            return false;
        }
        if (!Character.isDigit(c) && c != '.' && c != '-' && c != '+' && c != 'E' && c != 'e') {
            return true;
        }
        try {
            Double.valueOf(s);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static char[] formatFitsString(char[] a) {
        if (a.length == 0) {
            return a;
        }
        StringBuffer s = new StringBuffer();
        boolean flagQuote = a[0] == '\'';
        s.append('\'');
        int i = flagQuote ? 1 : 0;
        while (i < a.length - (flagQuote ? 1 : 0)) {
            if (!flagQuote && a[i] == '\'') {
                s.append('\'');
            }
            s.append(a[i]);
            ++i;
        }
        while (i < (flagQuote ? 9 : 8)) {
            s.append(' ');
            ++i;
        }
        s.append('\'');
        return s.toString().toCharArray();
    }

    class HeaderFits
    implements Iterable<String> {
        private LinkedHashMap<String, String> header;
        private int sizeHeader = 0;

        HeaderFits() {
        }

        private String getValue(byte[] buffer) {
            int offset;
            boolean quote = false;
            boolean blanc = true;
            int i = offset = 9;
            while (i < 80) {
                if (quote ? buffer[i] == 39 : buffer[i] == 47) break;
                if (blanc) {
                    if (buffer[i] != 32) {
                        blanc = false;
                    }
                    if (buffer[i] == 39) {
                        quote = true;
                        offset = i + 1;
                    }
                }
                ++i;
            }
            return new String(buffer, 0, offset, i - offset).trim();
        }

        private String getKey(byte[] buffer) {
            return new String(buffer, 0, 0, 8).trim();
        }

        private void readHeader(InputStream dis) throws Exception {
            int blocksize = 2880;
            int fieldsize = 80;
            int linesRead = 0;
            this.sizeHeader = 0;
            this.header = new LinkedHashMap(200);
            byte[] buffer = new byte[fieldsize];
            while (true) {
                Moc.readFully(dis, buffer);
                String key = this.getKey(buffer);
                if (linesRead == 0 && !key.equals("SIMPLE") && !key.equals("XTENSION")) {
                    throw new Exception("Not a MOC FITS format");
                }
                this.sizeHeader += fieldsize;
                ++linesRead;
                if (key.equals("END")) break;
                if (buffer[8] != 61) continue;
                String value = this.getValue(buffer);
                this.header.put(key, value);
            }
            int bourrage = blocksize - this.sizeHeader % blocksize;
            if (bourrage != blocksize) {
                byte[] tmp = new byte[bourrage];
                Moc.readFully(dis, tmp);
                this.sizeHeader += bourrage;
            }
        }

        public int getIntFromHeader(String key) throws NumberFormatException, NullPointerException {
            String s = this.header.get(key.trim());
            return (int)Double.parseDouble(s.trim());
        }

        public String getStringFromHeader(String key) throws NullPointerException {
            String s = this.header.get(key.trim());
            if (s == null || s.length() == 0) {
                return s;
            }
            if (s.charAt(0) == '\'') {
                return s.substring(1, s.length() - 1).trim();
            }
            return s;
        }

        @Override
        public Iterator<String> iterator() {
            return this.header.keySet().iterator();
        }
    }
}

