/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.healpix.FlatHashIterator;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.moc.HealpixImpl;

public final class Healpix
implements HealpixImpl {
    public static final double SKYAREA = Math.PI * 4 * Math.toDegrees(1.0) * Math.toDegrees(1.0);

    @Override
    public long ang2pix(int order, double lon, double lat) throws Exception {
        return cds.healpix.Healpix.getNestedFast((int)order).hash(Math.toRadians(lon), Math.toRadians(lat));
    }

    @Override
    public double[] pix2ang(int order, long npix) throws Exception {
        double[] lonlat = cds.healpix.Healpix.getNestedFast((int)order).center(npix);
        lonlat[0] = Math.toDegrees(lonlat[0]);
        lonlat[1] = Math.toDegrees(lonlat[1]);
        return lonlat;
    }

    @Override
    public long[] queryDisc(int order, double lon, double lat, double radius) throws Exception {
        lon = Math.toRadians(lon);
        lat = Math.toRadians(lat);
        radius = Math.toRadians(radius);
        HealpixNestedFixedRadiusConeComputer cc = cds.healpix.Healpix.getNested((int)order).newConeComputerApprox(radius);
        HealpixNestedBMOC bmoc = cc.overlappingCells(lon, lat);
        long[] cells = new long[(int)bmoc.computeDeepSize()];
        FlatHashIterator it = bmoc.flatHashIterator();
        int i = 0;
        while (it.hasNext()) {
            cells[i] = it.next();
            ++i;
        }
        return cells;
    }

    public static final long pow2(long order) {
        return 1L << (int)order;
    }

    public static double getPixelArea(int order) {
        if (order < 0) {
            return SKYAREA;
        }
        return SKYAREA / (double)cds.healpix.Healpix.nHash((int)order);
    }
}

