/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Healpix;
import cds.moc.HealpixImpl;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.MocCell;
import cds.moc.STMoc;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class SMoc
extends Moc1D {
    public static final int MAXORD_S = 29;
    public static final int FACT_S = 4;
    public static final char DIM_S = 's';
    public static final long NBVAL_S = SMoc.pow2(29L) * SMoc.pow2(29L) * 12L;
    private int minOrder;
    private String altCoosys;

    @Override
    public final int maxOrder() {
        return 29;
    }

    @Override
    public final int shiftOrder() {
        return 2;
    }

    @Override
    public final char cDim() {
        return 's';
    }

    @Override
    public final long maxVal() {
        return NBVAL_S;
    }

    public SMoc() {
    }

    public SMoc(int mocOrder) {
        super(mocOrder);
    }

    public SMoc(String s) throws Exception {
        super(s);
    }

    public SMoc(SMoc moc) throws Exception {
        super(moc);
    }

    public SMoc(InputStream in) throws Exception {
        super(in);
    }

    @Override
    public void clear() {
        super.clear();
        this.altCoosys = null;
        this.minOrder = 0;
    }

    @Override
    public SMoc clone() throws CloneNotSupportedException {
        SMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof SMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be SMoc");
        }
        super.clone1(moc);
        this.altCoosys = ((SMoc)moc).altCoosys;
        this.minOrder = ((SMoc)moc).minOrder;
    }

    @Override
    public SMoc dup() {
        SMoc moc = new SMoc();
        moc.altCoosys = this.altCoosys;
        return moc;
    }

    @Override
    public int sizeOfCoding() {
        return this.getDeepestOrder() < 14 ? 4 : 8;
    }

    @Override
    public int getNbCoding() {
        return this.getNbCells();
    }

    @Override
    public void add(Moc moc) throws Exception {
        if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc for adding");
        }
        super.add(moc);
    }

    public void add(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getMocOrder();
        if (order == -1) {
            throw new Exception("Undefined Moc order");
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        this.add(order, npix, npix);
    }

    public boolean contains(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getDeepestOrder();
        if (order == -1) {
            return false;
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        return this.isIncluding(order, npix);
    }

    public SMoc queryDisc(HealpixImpl healpix, double alpha, double delta, double radius) throws Exception {
        long[] list;
        int order = this.getDeepestOrder();
        if (order == -1) {
            return null;
        }
        SMoc mocA = this.dup();
        long[] lArray = list = healpix.queryDisc(order, alpha, delta, radius);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            long npix = lArray[n2];
            mocA.add(order, npix, npix);
            ++n2;
        }
        return this.intersection(mocA);
    }

    public void setSys(String coosys) {
        this.altCoosys = coosys;
    }

    public String getSys() {
        return this.altCoosys != null ? this.altCoosys : "C";
    }

    @Override
    public void setMinOrder(int minOrder) throws Exception {
        if (minOrder == this.minOrder) {
            return;
        }
        if (minOrder < 0 || minOrder > this.maxOrder()) {
            throw new Exception("MinOrder error (" + minOrder + " not in [0.." + this.maxOrder() + "])");
        }
        if (this.mocOrder != -1 && minOrder > this.mocOrder) {
            throw new Exception("MinOrder cannot be bigger that Moc order");
        }
        this.minOrder = minOrder;
        this.resetCache();
    }

    @Override
    public int getMinOrder() {
        return this.minOrder;
    }

    public double getAngularRes() {
        return Math.sqrt(Healpix.getPixelArea(this.getMocOrder()));
    }

    public boolean contains(long npix) {
        return this.range.contains(npix);
    }

    private boolean isCompatible(SMoc moc) {
        String a = this.altCoosys == null ? "C" : this.altCoosys;
        String b = moc.altCoosys == null ? "C" : moc.altCoosys;
        return a.equals(b);
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc isIncluding test");
        }
        if (!((SMoc)moc).isCompatible(this)) {
            throw new Exception("Uncompatible coosys");
        }
        this.flush();
        return this.range.contains(((SMoc)moc).range);
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc isIncluding test");
        }
        if (!((SMoc)moc).isCompatible(this)) {
            throw new Exception("Uncompatible coosys");
        }
        this.flush();
        return this.range.overlaps(((SMoc)moc).range);
    }

    @Override
    public SMoc union(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc union");
        }
        if (!((SMoc)moc).isCompatible(this)) {
            throw new Exception("Uncompatible coosys");
        }
        return (SMoc)super.union(moc);
    }

    @Override
    public SMoc intersection(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc subtraction");
        }
        if (!((SMoc)moc).isCompatible(this)) {
            throw new Exception("Uncompatible coosys");
        }
        return (SMoc)super.intersection(moc);
    }

    @Override
    public SMoc subtraction(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getSpaceMoc();
        } else if (!(moc instanceof SMoc)) {
            throw new Exception("Uncompatible Moc type for SMoc subtraction");
        }
        if (!((SMoc)moc).isCompatible(this)) {
            throw new Exception("Uncompatible coosys");
        }
        return (SMoc)super.subtraction(moc);
    }

    @Override
    public SMoc complement() throws Exception {
        return (SMoc)super.complement();
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        int mocOrder = -1;
        String val = header.getStringFromHeader("MOCORD_S");
        if (val == null) {
            val = header.getStringFromHeader("MOCORDER");
        }
        try {
            mocOrder = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setMocOrder(mocOrder);
        String type = header.getStringFromHeader("ORDERING");
        String sys = header.getStringFromHeader("COORDSYS");
        if (sys != null && !sys.equals("C")) {
            this.setSys(sys);
        }
        if (type != null && type.equals("RANGE")) {
            this.readSpecificDataRange(in, naxis1, naxis2, nbyte);
        } else {
            this.readSpecificDataUniq(in, naxis1, naxis2, nbyte);
        }
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(SMoc.getFitsLine("TTYPE1", "UNIQ", "UNIQ pixel number"));
        n += 80;
        out.write(SMoc.getFitsLine("ORDERING", "NUNIQ", "NUNIQ coding method"));
        n += 80;
        out.write(SMoc.getFitsLine("COORDSYS", this.getSys(), "Reference frame (C=ICRS)"));
        n += 80;
        out.write(SMoc.getFitsLine("MOCDIM", "SPACE", "Physical dimension"));
        n += 80;
        out.write(SMoc.getFitsLine("MOCORD_S", "" + this.getMocOrder(), "MOC resolution (best order)"));
        n += 80;
        out.write(SMoc.getFitsLine("MOCORDER", "" + this.getMocOrder(), "=MOCORD_S (backward compatibility)"));
        return n += 80;
    }

    @Override
    protected int writeSpecificData(OutputStream out) throws Exception {
        int size = 0;
        byte[] buf = new byte[this.sizeOfCoding()];
        Iterator<MocCell> it = this.cellIterator(true);
        while (it.hasNext()) {
            MocCell cell = it.next();
            long val = cell.start;
            while (val < cell.end) {
                long nuniq = SMoc.hpix2uniq(cell.order, val);
                size += SMoc.writeVal(out, nuniq, buf);
                ++val;
            }
        }
        return size;
    }
}

