/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;

public class RangeSet
implements Externalizable {
    private static final long serialVersionUID = -4778909346616313978L;
    private static final ValueIterator EMPTY_ITER = new ValueIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long next() {
            throw new NoSuchElementException();
        }
    };
    protected long[] r;
    protected int sz;

    public RangeSet() {
        this(8);
    }

    public RangeSet(int cap) {
        if (cap < 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.r = new long[cap];
        this.sz = 0;
    }

    public RangeSet(long[] data) {
        this.sz = data.length;
        this.r = new long[this.sz];
        System.arraycopy(data, 0, this.r, 0, this.sz);
        this.checkConsistency();
    }

    public RangeSet(RangeSet other) {
        this.sz = other.sz;
        this.r = new long[this.sz];
        System.arraycopy(other.r, 0, this.r, 0, this.sz);
    }

    public void setTo(RangeSet other) {
        this.sz = other.sz;
        this.r = new long[this.sz];
        System.arraycopy(other.r, 0, this.r, 0, this.sz);
    }

    public void checkConsistency() {
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("invalid number of entries");
        }
        int i = 1;
        while (i < this.sz) {
            if (this.r[i] <= this.r[i - 1]) {
                throw new IllegalArgumentException("inconsistent entries");
            }
            ++i;
        }
    }

    private void resize(int newsize) {
        if (newsize < this.sz) {
            throw new IllegalArgumentException("requested array size too small");
        }
        if (newsize == this.r.length) {
            return;
        }
        long[] rnew = new long[newsize];
        System.arraycopy(this.r, 0, rnew, 0, this.sz);
        this.r = rnew;
    }

    public void ensureCapacity(int cap) {
        if (this.r.length < cap) {
            this.resize(Math.max(2 * this.r.length, cap));
        }
    }

    public void trimSize() {
        this.resize(this.sz);
    }

    public void append(long val) {
        this.append(val, val + 1L);
    }

    public void append(long a, long b) {
        if (a >= b) {
            return;
        }
        if (this.sz > 0 && a <= this.r[this.sz - 1]) {
            if (a < this.r[this.sz - 2]) {
                throw new IllegalArgumentException("bad append operation");
            }
            if (b > this.r[this.sz - 1]) {
                this.r[this.sz - 1] = b;
            }
            return;
        }
        this.ensureCapacity(this.sz + 2);
        this.r[this.sz] = a;
        this.r[this.sz + 1] = b;
        this.sz += 2;
    }

    public void append(RangeSet other) {
        int i = 0;
        while (i < other.sz) {
            this.append(other.r[i], other.r[i + 1]);
            i += 2;
        }
    }

    public int size() {
        return this.sz >>> 1;
    }

    public boolean isEmpty() {
        return this.sz == 0;
    }

    public long ivbegin(int iv) {
        return this.r[2 * iv];
    }

    public long ivend(int iv) {
        return this.r[2 * iv + 1];
    }

    public void clear() {
        this.sz = 0;
    }

    private void pushv(long v) {
        this.ensureCapacity(this.sz + 1);
        this.r[this.sz++] = v;
    }

    private static boolean generalAllOrNothing(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b) {
        if (a.isEmpty()) {
            return flip_a ? true : b.isEmpty();
        }
        if (b.isEmpty()) {
            return flip_b ? true : a.isEmpty();
        }
        boolean state_a = flip_a;
        boolean state_b = flip_b;
        boolean state_res = state_a || state_b;
        int ia = 0;
        int ea = a.sz;
        int ib = 0;
        int eb = b.sz;
        boolean runa = ia != ea;
        boolean runb = ib != eb;
        while (runa || runb) {
            boolean adv_a = false;
            boolean adv_b = false;
            long va = 0L;
            long vb = 0L;
            if (runa) {
                va = a.r[ia];
            }
            if (runb) {
                vb = b.r[ib];
            }
            if (runa && (!runb || va <= vb)) {
                adv_a = true;
            }
            if (runb && (!runa || vb <= va)) {
                adv_b = true;
            }
            if (adv_a) {
                state_a = !state_a;
                boolean bl = runa = ++ia != ea;
            }
            if (adv_b) {
                state_b = !state_b;
                runb = ++ib != eb;
            }
            if ((state_a || state_b) == state_res) continue;
            return false;
        }
        return true;
    }

    private static void generalUnion(RangeSet a, RangeSet b, boolean flip_a, boolean flip_b, RangeSet c) {
        c.clear();
        if (a.isEmpty()) {
            if (flip_a) {
                return;
            }
            c.setTo(b);
            return;
        }
        if (b.isEmpty()) {
            if (flip_b) {
                return;
            }
            c.setTo(a);
            return;
        }
        boolean state_a = flip_a;
        boolean state_b = flip_b;
        boolean state_res = state_a || state_b;
        int ia = 0;
        int ea = a.sz;
        int ib = 0;
        int eb = b.sz;
        boolean runa = ia != ea;
        boolean runb = ib != eb;
        while (runa || runb) {
            boolean adv_a = false;
            boolean adv_b = false;
            long val = 0L;
            long va = 0L;
            long vb = 0L;
            if (runa) {
                va = a.r[ia];
            }
            if (runb) {
                vb = b.r[ib];
            }
            if (runa && (!runb || va <= vb)) {
                adv_a = true;
                val = va;
            }
            if (runb && (!runa || vb <= va)) {
                adv_b = true;
                val = vb;
            }
            if (adv_a) {
                state_a = !state_a;
                boolean bl = runa = ++ia != ea;
            }
            if (adv_b) {
                state_b = !state_b;
                runb = ++ib != eb;
            }
            if ((state_a || state_b) == state_res) continue;
            c.pushv(val);
            boolean bl = state_res = !state_res;
        }
    }

    public void setToUnion(RangeSet a, RangeSet b) {
        RangeSet.generalUnion(a, b, false, false, this);
    }

    public void setToIntersection(RangeSet a, RangeSet b) {
        RangeSet.generalUnion(a, b, true, true, this);
    }

    public void setToDifference(RangeSet a, RangeSet b) {
        RangeSet.generalUnion(a, b, true, false, this);
    }

    public RangeSet union(RangeSet other) {
        RangeSet res = new RangeSet();
        RangeSet.generalUnion(this, other, false, false, res);
        return res;
    }

    public RangeSet intersection(RangeSet other) {
        RangeSet res = new RangeSet();
        RangeSet.generalUnion(this, other, true, true, res);
        return res;
    }

    public RangeSet difference(RangeSet other) {
        RangeSet res = new RangeSet();
        RangeSet.generalUnion(this, other, true, false, res);
        return res;
    }

    private int iiv(long val) {
        int count = this.sz;
        int first = 0;
        while (count > 0) {
            int step = count >>> 1;
            int it = first + step;
            if (this.r[it] <= val) {
                first = ++it;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first - 1;
    }

    public boolean contains(long a) {
        return (this.iiv(a) & 1) == 0;
    }

    public boolean containsAll(long a, long b) {
        int res = this.iiv(a);
        if ((res & 1) != 0) {
            return false;
        }
        return b <= this.r[res + 1];
    }

    public boolean containsAny(long a, long b) {
        int res = this.iiv(a);
        if ((res & 1) == 0) {
            return true;
        }
        if (res == this.sz - 1) {
            return false;
        }
        return this.r[res + 1] < b;
    }

    public boolean containsAll(RangeSet other) {
        return RangeSet.generalAllOrNothing(this, other, false, true);
    }

    public boolean containsAny(RangeSet other) {
        return !RangeSet.generalAllOrNothing(this, other, true, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RangeSet)) {
            return false;
        }
        RangeSet other = (RangeSet)obj;
        if (other.sz != this.sz) {
            return false;
        }
        int i = 0;
        while (i < this.sz) {
            if (other.r[i] != this.r[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        int i = 0;
        while (i < this.sz) {
            int elementHash = (int)(this.r[i] ^ this.r[i] >>> 32);
            result = 31 * result + elementHash;
            ++i;
        }
        result = 31 * result + this.sz;
        return result;
    }

    public long nval() {
        long res = 0L;
        int i = 0;
        while (i < this.sz) {
            res += this.r[i + 1] - this.r[i];
            i += 2;
        }
        return res;
    }

    private void addRemove(long a, long b, int v) {
        boolean insert_a;
        int rmstart;
        boolean insert_b;
        int rmend;
        int pos1 = this.iiv(a);
        int pos2 = this.iiv(b);
        if (pos1 >= 0 && this.r[pos1] == a) {
            --pos1;
        }
        if (((rmend = pos2 - ((insert_b = (pos2 & 1) == v) ? 1 : 0)) - (rmstart = pos1 + 1 + ((insert_a = (pos1 & 1) == v) ? 1 : 0)) & 1) == 0) {
            throw new IllegalArgumentException("cannot happen: " + rmstart + " " + rmend);
        }
        if (insert_a && insert_b && pos1 + 1 > pos2) {
            this.ensureCapacity(this.sz + 2);
            System.arraycopy(this.r, pos1 + 1, this.r, pos1 + 3, this.sz - pos1 - 1);
            this.r[pos1 + 1] = a;
            this.r[pos1 + 2] = b;
            this.sz += 2;
        } else {
            if (insert_a) {
                this.r[pos1 + 1] = a;
            }
            if (insert_b) {
                this.r[pos2] = b;
            }
            if (rmstart != rmend + 1) {
                System.arraycopy(this.r, rmend + 1, this.r, rmstart, this.sz - rmend - 1);
            }
            this.sz -= rmend - rmstart + 1;
        }
    }

    public void intersect(long a, long b) {
        int pos1 = this.iiv(a);
        int pos2 = this.iiv(b);
        if (pos2 >= 0 && this.r[pos2] == b) {
            --pos2;
        }
        boolean insert_a = (pos1 & 1) == 0;
        boolean insert_b = (pos2 & 1) == 0;
        this.sz = pos2 + 1;
        if (insert_b) {
            this.r[this.sz++] = b;
        }
        if (insert_a) {
            this.r[pos1--] = a;
        }
        if (pos1 >= 0) {
            System.arraycopy(this.r, pos1 + 1, this.r, 0, this.sz - pos1 - 1);
        }
        this.sz -= pos1 + 1;
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("cannot happen");
        }
    }

    public void add(long a, long b) {
        this.addRemove(a, b, 1);
    }

    public void remove(long a, long b) {
        this.addRemove(a, b, 0);
    }

    public long[] toArray() {
        long[] res = new long[(int)this.nval()];
        int ofs = 0;
        int i = 0;
        while (i < this.sz) {
            long j = this.r[i];
            while (j < this.r[i + 1]) {
                res[ofs++] = j++;
            }
            i += 2;
        }
        return res;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{ ");
        int i = 0;
        while (i < this.sz) {
            s.append("[").append(this.r[i]).append(";").append(this.r[i + 1]).append("]");
            if (i < this.sz - 2) {
                s.append(",");
            }
            i += 2;
        }
        s.append(" }");
        return s.toString();
    }

    public ValueIterator valueIterator() {
        if (this.sz == 0) {
            return EMPTY_ITER;
        }
        return new ValueIterator(){
            int pos = 0;
            long value;
            {
                this.value = RangeSet.this.sz > 0 ? RangeSet.this.r[0] : 0L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < RangeSet.this.sz;
            }

            @Override
            public long next() {
                if (this.pos > RangeSet.this.sz) {
                    throw new NoSuchElementException();
                }
                long ret = this.value++;
                if (this.value == RangeSet.this.r[this.pos + 1]) {
                    this.pos += 2;
                    if (this.pos < RangeSet.this.sz) {
                        this.value = RangeSet.this.r[this.pos];
                    }
                }
                return ret;
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.sz);
        long last = 0L;
        long[] lArray = this.r;
        int n = this.r.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            long diff = i - last;
            RangeSet.packLong(out, diff);
            last = i;
            ++n2;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.sz > 0) {
            throw new IOException("RangeSet already contains data!");
        }
        this.sz = in.readInt();
        if (this.sz < 0 || (this.sz & 1) != 0) {
            throw new Error();
        }
        this.r = new long[this.sz];
        long last = 0L;
        int i = 0;
        while (i < this.sz) {
            this.r[i] = last += RangeSet.unpackLong(in);
            ++i;
        }
    }

    private static void packLong(DataOutput os, long value) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            os.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        os.write((byte)value);
    }

    private static long unpackLong(DataInput is) throws IOException {
        long result = 0L;
        int offset = 0;
        while (offset < 64) {
            long b = is.readUnsignedByte();
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) == 0L) {
                return result;
            }
            offset += 7;
        }
        throw new Error("Malformed long.");
    }

    public static interface ValueIterator {
        public boolean hasNext();

        public long next();
    }
}

