/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Array;
import cds.moc.HealpixImpl;
import cds.moc.IntArray;
import cds.moc.LongArray;
import cds.moc.MocCell;
import cds.moc.MocIO;
import cds.moc.RangeSet;
import cds.moc.ShortArray;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class HealpixMoc
implements Iterable<MocCell>,
Cloneable {
    public static final String VERSION = "4.1";
    public static final int FITS = 0;
    public static final int JSON = 1;
    public static final int ASCII = 2;
    public static final int OBSOLETE = 3;
    public static final int MAXORDER = 29;
    public static final int SHORT = 0;
    public static final int INT = 1;
    public static final int LONG = 2;
    private HashMap<String, String> property;
    private String coordSys;
    private int minLimitOrder = 0;
    private int maxLimitOrder = -1;
    private Array[] level;
    private int nOrder;
    private boolean testConsistency;
    private boolean isConsistant;
    private int currentOrder = -1;
    private static final int MAXWORD = 20;
    private static final int MAXSIZE = 80;
    private RangeSet rangeSet = null;
    private static final double SKYAREA = Math.PI * 4 * Math.toDegrees(1.0) * Math.toDegrees(1.0);

    public static int getType(int order) {
        return order < 6 ? 0 : (order < 14 ? 1 : 2);
    }

    public HealpixMoc() {
        this.init("C", 0, -1);
    }

    public HealpixMoc(int maxLimitOrder) throws Exception {
        this.init("C", 0, maxLimitOrder);
    }

    public HealpixMoc(int minLimitOrder, int maxLimitOrder) throws Exception {
        this.init("C", minLimitOrder, maxLimitOrder);
    }

    public HealpixMoc(String coordSys, int minLimitOrder, int maxLimitOrder) throws Exception {
        this.init(coordSys, minLimitOrder, maxLimitOrder);
    }

    public HealpixMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public HealpixMoc(InputStream in) throws Exception {
        this(in, 0);
    }

    public HealpixMoc(InputStream in, int mode) throws Exception {
        this();
        this.read(in, mode);
    }

    public void clear() {
        this.init(this.coordSys, this.minLimitOrder, this.maxLimitOrder);
    }

    public Object clone() {
        HealpixMoc moc = new HealpixMoc();
        moc.coordSys = this.coordSys;
        moc.maxLimitOrder = this.maxLimitOrder;
        moc.minLimitOrder = this.minLimitOrder;
        moc.nOrder = this.nOrder;
        moc.testConsistency = this.testConsistency;
        moc.currentOrder = this.currentOrder;
        moc.rangeSet = this.rangeSet == null ? null : new RangeSet(this.rangeSet);
        int order = 0;
        while (order < this.nOrder) {
            moc.level[order] = (Array)this.level[order].clone();
            ++order;
        }
        moc.property = (HashMap)this.property.clone();
        return moc;
    }

    public void setMinLimitOrder(int limitOrder) throws Exception {
        if (limitOrder == this.minLimitOrder) {
            return;
        }
        if (limitOrder > 29) {
            throw new Exception("Min limit order exceed HEALPix library possibility (29)");
        }
        if (limitOrder < 0 || this.maxLimitOrder != -1 && limitOrder > this.maxLimitOrder) {
            throw new Exception("Min limit greater than max limit order");
        }
        this.isConsistant = false;
        this.minLimitOrder = limitOrder;
        this.setCheckConsistencyFlag(true);
    }

    public void setMocOrder(int order) throws Exception {
        this.setMaxLimitOrder(order);
    }

    public void setMaxLimitOrder(int limitOrder) throws Exception {
        if (limitOrder == this.maxLimitOrder) {
            return;
        }
        if (limitOrder > 29) {
            throw new Exception("Max limit order exceed HEALPix library possibility (29)");
        }
        if (limitOrder != -1 && limitOrder < this.minLimitOrder) {
            throw new Exception("Max limit order smaller than min limit order");
        }
        this.isConsistant = false;
        this.maxLimitOrder = limitOrder;
        this.setCheckConsistencyFlag(true);
        this.property.put("MOCORDER", "" + (limitOrder == -1 ? 29 : limitOrder));
    }

    public int getMinLimitOrder() {
        return this.minLimitOrder;
    }

    public int getMaxLimitOrder() {
        if (this.maxLimitOrder == -1) {
            return 29;
        }
        return this.maxLimitOrder;
    }

    public int getMocOrder() {
        return this.getMaxLimitOrder();
    }

    public void setMocOrder(String mocOrder) throws Exception {
        int n = Integer.parseInt(mocOrder);
        if (n == 29) {
            n = -1;
        }
        this.setMaxLimitOrder(n);
    }

    public int getLimitOrder() {
        return this.getMaxLimitOrder();
    }

    public void setLimitOrder(int limitOrder) throws Exception {
        this.setMaxLimitOrder(limitOrder);
    }

    public String getCoordSys() {
        return this.coordSys;
    }

    public void setCoordSys(String coordSys) {
        this.coordSys = coordSys;
        this.property.put("COORDSYS", coordSys);
    }

    protected void setCurrentOrder(int order) {
        this.currentOrder = order;
    }

    public int getSize() {
        int size = 0;
        int order = 0;
        while (order < this.nOrder) {
            size += this.getSize(order);
            ++order;
        }
        return size;
    }

    public long getMem() {
        long mem = 0L;
        int order = 0;
        while (order < this.nOrder) {
            mem += this.getMem(order);
            ++order;
        }
        return mem;
    }

    public long getMem(int order) {
        return this.level[order].getMem();
    }

    public int getSize(int order) {
        return this.level[order].getSize();
    }

    public Array getArray(int order) {
        return this.level[order];
    }

    public double getAngularRes() {
        return Math.sqrt(HealpixMoc.getPixelArea(this.getMocOrder()));
    }

    public int getMaxOrder() {
        return this.nOrder - 1;
    }

    public void setCheckConsistencyFlag(boolean flag) throws Exception {
        this.testConsistency = flag;
        if (this.testConsistency) {
            this.checkAndFix();
        }
    }

    public int getDescendantOrder(int order, long npix) {
        long pix = npix / 4L;
        int o = order - 1;
        while (o >= 0) {
            if (this.level[o].find(pix) >= 0) {
                return o;
            }
            --o;
            pix /= 4L;
        }
        return -1;
    }

    public void add(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t{}");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            if (s1.length() == 0) continue;
            this.addHpix(s1);
        }
    }

    public void add(HealpixMoc moc) throws Exception {
        int order = moc.nOrder - 1;
        while (order >= 0) {
            for (long npix : moc.getArray(order)) {
                this.add(order, npix);
            }
            --order;
        }
    }

    public boolean add(MocCell cell) throws Exception {
        return this.add(cell.order, cell.npix);
    }

    public boolean add(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getMaxOrder();
        if (order == -1) {
            return false;
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        return this.add(order, npix);
    }

    public boolean add(int order, long npix) throws Exception {
        return this.add(order, npix, true);
    }

    private boolean add(int order, long npix, boolean testHierarchy) throws Exception {
        this.rangeSet = null;
        if (order < this.minLimitOrder) {
            return this.add2(order, npix, this.minLimitOrder);
        }
        if (!this.testConsistency) {
            this.isConsistant = false;
            return this.add1(order, npix);
        }
        if (this.maxLimitOrder != -1 && order > this.maxLimitOrder) {
            return this.add(order - 1, npix >>> 2);
        }
        if (testHierarchy) {
            if (order > this.minLimitOrder && this.isDescendant(order, npix)) {
                return false;
            }
            this.deleteDescendant(order, npix);
        }
        if (order > this.minLimitOrder && this.deleteBrothers(order, npix)) {
            return this.add(order - 1, npix >>> 2, testHierarchy);
        }
        return this.add1(order, npix);
    }

    private boolean deleteBrothers(int order, long me) {
        return this.level[order].deleteBrothers(me);
    }

    public void delete(String s) {
        StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t");
        while (st.hasMoreTokens()) {
            this.deleteHpix(st.nextToken());
        }
    }

    public boolean delete(int order, long npix) {
        if (order >= this.nOrder) {
            return false;
        }
        this.rangeSet = null;
        return this.level[order].delete(npix);
    }

    public boolean deleteDescendant(int order, long npix) {
        this.rangeSet = null;
        long v1 = npix * 4L;
        long v2 = (npix + 1L) * 4L - 1L;
        boolean rep = false;
        int o = order + 1;
        while (o < this.nOrder) {
            rep |= this.getArray(o).delete(v1, v2);
            ++o;
            v1 *= 4L;
            v2 = (v2 + 1L) * 4L - 1L;
        }
        return rep;
    }

    public void sort() {
        int order = 0;
        while (order < this.nOrder) {
            this.level[order].sort();
            ++order;
        }
    }

    public boolean isSorted() {
        int order = 0;
        while (order < this.nOrder) {
            if (!this.level[order].isSorted()) {
                return false;
            }
            ++order;
        }
        return true;
    }

    public boolean isInTree(int order, long npix) {
        return this.isIntersecting(order, npix);
    }

    public boolean isInTree(HealpixMoc moc) {
        return this.isIntersecting(moc);
    }

    public void checkAndFix() throws Exception {
        if (this.getMaxOrder() == -1 || this.isConsistant) {
            return;
        }
        this.rangeSet = null;
        this.sort();
        HealpixMoc res = new HealpixMoc(this.coordSys, this.minLimitOrder, this.maxLimitOrder);
        int[] p = new int[this.getMaxOrder() + 1];
        int npix = 0;
        while (npix < 12) {
            this.checkAndFix(res, p, 0, npix);
            ++npix;
        }
        boolean flagTrim = true;
        int order = p.length - 1;
        while (order >= 0) {
            Array a;
            this.level[order] = a = res.getArray(order);
            if (flagTrim && a.getSize() != 0) {
                this.nOrder = order + 1;
                flagTrim = false;
            }
            --order;
        }
        res = null;
        this.isConsistant = true;
    }

    private void checkAndFix(HealpixMoc res, int[] p, int order, long pix) throws Exception {
        block11: {
            long mx;
            long t = -1L;
            Array a = this.getArray(order);
            if (p[order] < a.getSize()) {
                t = a.get(p[order]);
            }
            if (t == pix) {
                res.add(order, pix, false);
                int o = order;
                while (o < p.length) {
                    long mx2 = pix + 1L << (o - order << 1);
                    a = this.getArray(o);
                    while (p[o] < a.getSize() && a.get(p[o]) < mx2) {
                        int n = o;
                        p[n] = p[n] + 1;
                    }
                    ++o;
                }
                return;
            }
            boolean found = false;
            int o = order + 1;
            while (o < p.length) {
                mx = pix + 1L << (o - order << 1);
                a = this.getArray(o);
                if (p[o] < a.getSize() && a.get(p[o]) < mx) {
                    found = true;
                    break;
                }
                ++o;
            }
            if (!found) break block11;
            if (res.maxLimitOrder != -1 && order > res.maxLimitOrder) {
                res.add(order, pix, false);
                o = order;
                while (o < p.length) {
                    mx = pix + 1L << (o - order << 1);
                    a = this.getArray(o);
                    while (p[o] < a.getSize() && a.get(p[o]) < mx) {
                        int n = o;
                        p[n] = p[n] + 1;
                    }
                    ++o;
                }
            } else {
                int i = 0;
                while (i < 4) {
                    this.checkAndFix(res, p, order + 1, (pix << 2) + (long)i);
                    ++i;
                }
            }
        }
    }

    public boolean isAscendant(int order, long npix) {
        long range = 4L;
        int o = order + 1;
        while (o < this.nOrder) {
            if (this.level[o].intersectRange(npix * range, (npix + 1L) * range - 1L)) {
                return true;
            }
            ++o;
            range *= 4L;
        }
        return false;
    }

    public boolean isDescendant(int order, long npix) {
        long pix = npix / 4L;
        int o = order - 1;
        while (o >= this.minLimitOrder) {
            if (this.level[o].find(pix) >= 0) {
                return true;
            }
            --o;
            pix /= 4L;
        }
        return false;
    }

    public boolean isIn(int order, long npix) {
        return this.level[order].find(npix) >= 0;
    }

    public void setProperty(String key, String value) throws Exception {
        if (key.equals("MOCORDER")) {
            int mocOrder = Integer.parseInt(value);
            this.setMaxLimitOrder(mocOrder);
        } else if (key.equals("COORDSYS")) {
            this.setCoordSys(value);
        } else {
            this.property.put(key, value);
        }
    }

    public String getProperty(String key) {
        return this.property.get(key);
    }

    public double getCoverage() {
        long area = this.getArea();
        if (area == 0L) {
            return 0.0;
        }
        return (double)this.getUsedArea() / (double)area;
    }

    public long getUsedArea() {
        long n = 0L;
        long sizeCell = 1L;
        int order = this.nOrder - 1;
        while (order >= 0) {
            n += (long)this.getSize(order) * sizeCell;
            --order;
            sizeCell *= 4L;
        }
        return n;
    }

    public long getArea() {
        if (this.nOrder == 0) {
            return 0L;
        }
        long nside = HealpixMoc.pow2(this.nOrder - 1);
        return 12L * nside * nside;
    }

    @Override
    public Iterator<MocCell> iterator() {
        return new HpixListIterator();
    }

    public Iterator<Long> pixelIterator() {
        this.sort();
        return new PixelIterator();
    }

    public void trim() {
        int order = 0;
        while (order < this.nOrder) {
            this.level[order].trim();
            ++order;
        }
    }

    public String todebug() {
        StringBuffer s = new StringBuffer();
        double coverage = (double)((int)(this.getCoverage() * 10000.0)) / 100.0;
        s.append("maxOrder=" + this.getMaxOrder() + " [" + this.minLimitOrder + ".." + (this.maxLimitOrder == -1 ? "max" : String.valueOf(this.maxLimitOrder)) + "] mem=" + this.getMem() / 1024L + "KB size=" + this.getSize() + " coverage=" + coverage + "%" + (this.isSorted() ? " sorted" : "") + (this.isConsistant ? " consistant" : "") + "\n");
        long oOrder = -1L;
        Iterator<MocCell> it = this.iterator();
        int i = 0;
        while (it.hasNext() && i < 80) {
            MocCell x = it.next();
            if ((long)x.order != oOrder) {
                s.append(" " + x.order + "/");
            } else {
                s.append(",");
            }
            s.append(x.npix);
            oOrder = x.order;
            ++i;
        }
        if (it.hasNext()) {
            s.append("...\n");
        }
        int order = 0;
        while (order < this.nOrder) {
            s.append(" " + order + ":" + this.level[order].getSize());
            ++order;
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer res = new StringBuffer(this.getSize() * 8);
        int order = -1;
        boolean flagNL = this.getSize() > 20;
        boolean first = true;
        int sizeLine = 0;
        res.append("{");
        for (MocCell c : this) {
            if (res.length() > 0) {
                if (c.order != order) {
                    if (!first) {
                        res.append("],");
                    }
                    if (flagNL) {
                        res.append("\n");
                        sizeLine = 0;
                    } else {
                        res.append(" ");
                    }
                } else {
                    int n = String.valueOf(c.npix).length();
                    if (flagNL && n + sizeLine > 80) {
                        res.append(",\n ");
                        sizeLine = 3;
                    } else {
                        res.append(',');
                        ++sizeLine;
                    }
                }
                first = false;
            }
            String s = c.order != order ? "\"" + c.order + "\":[" + c.npix : String.valueOf(c.npix);
            res.append(s);
            sizeLine += s.length();
            order = c.order;
        }
        int n = res.length();
        if (res.charAt(n - 1) == ',') {
            res.replace(n - 1, n - 1, "]" + (flagNL ? "\n" : " ") + "}");
        } else {
            res.append("]" + (flagNL ? "\n" : " ") + "}");
        }
        return res.toString();
    }

    public void toRangeSet() {
        if (this.rangeSet != null) {
            return;
        }
        this.sort();
        this.rangeSet = new RangeSet(this.getSize());
        RangeSet rtmp = new RangeSet();
        int order = 0;
        while (order < this.nOrder) {
            rtmp.clear();
            int shift = 2 * (29 - order);
            for (long npix : this.getArray(order)) {
                rtmp.append(npix << shift, npix + 1L << shift);
            }
            if (!rtmp.isEmpty()) {
                this.rangeSet = this.rangeSet.union(rtmp);
            }
            ++order;
        }
    }

    private void toHealpixMoc() throws Exception {
        this.clear();
        RangeSet r2 = new RangeSet(this.rangeSet);
        RangeSet r3 = new RangeSet();
        int o = 0;
        while (o <= 29) {
            if (r2.isEmpty()) {
                return;
            }
            int shift = 2 * (29 - o);
            long ofs = (1L << shift) - 1L;
            r3.clear();
            int iv = 0;
            while (iv < r2.size()) {
                long a = r2.ivbegin(iv) + ofs >>> shift;
                long b = r2.ivend(iv) >>> shift;
                r3.append(a << shift, b << shift);
                long c = a;
                while (c < b) {
                    this.add1(o, c);
                    ++c;
                }
                ++iv;
            }
            if (!r3.isEmpty()) {
                r2 = r2.difference(r3);
            }
            ++o;
        }
    }

    public boolean isIntersecting(int order, long npix) {
        return this.isIn(order, npix) || this.isAscendant(order, npix) || this.isDescendant(order, npix);
    }

    public boolean isIntersecting(HealpixMoc moc) {
        this.sort();
        moc.sort();
        int n = moc.getMaxOrder();
        int o = 0;
        while (o <= n) {
            Array a = moc.getArray(o);
            if (this.isInTree(o, a)) {
                return true;
            }
            ++o;
        }
        return false;
    }

    public HealpixMoc union(HealpixMoc moc) throws Exception {
        return this.operation(moc, 0);
    }

    public HealpixMoc intersection(HealpixMoc moc) throws Exception {
        return this.operation(moc, 1);
    }

    public HealpixMoc subtraction(HealpixMoc moc) throws Exception {
        return this.operation(moc, 2);
    }

    public HealpixMoc complement() throws Exception {
        HealpixMoc allsky = new HealpixMoc();
        allsky.add("0/0-11");
        allsky.toRangeSet();
        this.toRangeSet();
        HealpixMoc res = new HealpixMoc(this.coordSys, this.minLimitOrder, this.maxLimitOrder);
        res.rangeSet = allsky.rangeSet.difference(this.rangeSet);
        res.toHealpixMoc();
        return res;
    }

    public HealpixMoc difference(HealpixMoc moc) throws Exception {
        HealpixMoc inter = this.intersection(moc);
        HealpixMoc union = this.union(moc);
        return union.subtraction(inter);
    }

    private HealpixMoc operation(HealpixMoc moc, int op) throws Exception {
        this.testCompatibility(moc);
        this.toRangeSet();
        moc.toRangeSet();
        HealpixMoc res = new HealpixMoc(this.coordSys, this.minLimitOrder, this.maxLimitOrder);
        switch (op) {
            case 0: {
                res.rangeSet = this.rangeSet.union(moc.rangeSet);
                break;
            }
            case 1: {
                res.rangeSet = this.rangeSet.intersection(moc.rangeSet);
                break;
            }
            case 2: {
                res.rangeSet = this.rangeSet.difference(moc.rangeSet);
            }
        }
        res.toHealpixMoc();
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object moc) {
        if (this == moc) {
            return true;
        }
        try {
            HealpixMoc m = (HealpixMoc)moc;
            this.testCompatibility(m);
            if (m.nOrder != this.nOrder) {
                return false;
            }
            int o = 0;
            while (o < this.nOrder) {
                if (this.getSize(o) != m.getSize(o)) {
                    return false;
                }
                ++o;
            }
            o = 0;
            while (o < this.nOrder) {
                if (!this.getArray(o).equals(m.getArray(o))) {
                    return false;
                }
                ++o;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean contains(HealpixImpl healpix, double alpha, double delta) throws Exception {
        int order = this.getMaxOrder();
        if (order == -1) {
            return false;
        }
        long npix = healpix.ang2pix(order, alpha, delta);
        if (this.level[order].find(npix) >= 0) {
            return true;
        }
        return this.isDescendant(order, npix);
    }

    public HealpixMoc queryDisc(HealpixImpl healpix, double alpha, double delta, double radius) throws Exception {
        int order = this.getMaxOrder();
        long[] list = healpix.queryDisc(order, alpha, delta, radius);
        HealpixMoc mocA = new HealpixMoc();
        mocA.setCoordSys(this.getCoordSys());
        int i = 0;
        while (i < list.length) {
            mocA.add(order, list[i]);
            ++i;
        }
        return this.intersection(mocA);
    }

    public HealpixMoc queryCell(int order, long npix) throws Exception {
        return this.intersection(new HealpixMoc(String.valueOf(order) + "/" + npix));
    }

    public void setPixLevel(int order, long[] val) throws Exception {
        if (HealpixMoc.getType(order) != 2) {
            throw new Exception("The order " + order + " requires long[] array");
        }
        this.level[order] = new LongArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public void setPixLevel(int order, int[] val) throws Exception {
        if (HealpixMoc.getType(order) != 1) {
            throw new Exception("The order " + order + " requires int[] array");
        }
        this.level[order] = new IntArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public void setPixLevel(int order, short[] val) throws Exception {
        if (HealpixMoc.getType(order) != 0) {
            throw new Exception("The order " + order + " requires short[] array");
        }
        this.level[order] = new ShortArray(val);
        if (this.nOrder < order + 1) {
            this.nOrder = order + 1;
        }
    }

    public long[] getPixLevel(int order) {
        int size = this.getSize(order);
        long[] lev = new long[size];
        if (size == 0) {
            return lev;
        }
        Array a = this.level[order];
        int i = 0;
        while (i < size) {
            lev[i] = a.get(i);
            ++i;
        }
        return lev;
    }

    public void read(String filename) throws Exception {
        new MocIO(this).read(filename);
    }

    public void read(String filename, int mode) throws Exception {
        new MocIO(this).read(filename, mode);
    }

    public void read(InputStream in) throws Exception {
        this.readFits(in);
    }

    public void read(InputStream in, int mode) throws Exception {
        new MocIO(this).read(in, mode);
    }

    public void readASCII(InputStream in) throws Exception {
        new MocIO(this).read(in, 2);
    }

    public void readJSON(InputStream in) throws Exception {
        new MocIO(this).read(in, 1);
    }

    public void readFits(InputStream in) throws Exception {
        new MocIO(this).read(in, 0);
    }

    public void write(String filename) throws Exception {
        this.check();
        new MocIO(this).write(filename);
    }

    public void write(String filename, int mode) throws Exception {
        this.check();
        new MocIO(this).write(filename, mode);
    }

    public void write(OutputStream out, int mode) throws Exception {
        this.check();
        new MocIO(this).write(out, mode);
    }

    public void writeASCII(OutputStream out) throws Exception {
        this.writeJSON(out);
    }

    public void writeJSON(OutputStream out) throws Exception {
        this.check();
        new MocIO(this).writeJSON(out);
    }

    public void writeFits(OutputStream out) throws Exception {
        this.writeFits(out, false);
    }

    public void writeFits(OutputStream out, boolean compressed) throws Exception {
        this.writeFITS(out, compressed);
    }

    public void writeFITS(OutputStream out) throws Exception {
        this.writeFits(out, false);
    }

    public void writeFITS(OutputStream out, boolean compressed) throws Exception {
        this.check();
        new MocIO(this).writeFits(out, compressed);
    }

    private void init(String coordSys, int minLimitorder, int maxLimitOrder) {
        this.coordSys = coordSys;
        this.minLimitOrder = minLimitorder;
        this.maxLimitOrder = maxLimitOrder;
        this.property = new HashMap();
        this.property.put("MOCORDER", "29");
        this.property.put("COORDSYS", coordSys);
        this.property.put("MOCTOOL", "CDSjavaAPI-4.1");
        this.property.put("DATE", String.format("%tFT%<tRZ", new Date()));
        this.testConsistency = true;
        this.isConsistant = true;
        this.level = new Array[30];
        int order = 0;
        while (order < 30) {
            int type = HealpixMoc.getType(order);
            int bloc = (1 + order) * 10;
            Array a = type == 0 ? new ShortArray(bloc) : (type == 1 ? new IntArray(bloc) : new LongArray(bloc));
            this.level[order] = a;
            ++order;
        }
    }

    private boolean add1(int order, long npix) throws Exception {
        if (order < this.minLimitOrder) {
            return this.add2(order, npix, this.minLimitOrder);
        }
        if (order > 29) {
            throw new Exception("Out of MOC order");
        }
        if (order >= this.nOrder) {
            this.nOrder = order + 1;
        }
        return this.level[order].add(npix, this.testConsistency);
    }

    private boolean add2(int orderSrc, long npix, int orderTrg) throws Exception {
        if (orderTrg > 29) {
            throw new Exception("Out of MOC order");
        }
        if (orderTrg >= this.nOrder) {
            this.nOrder = orderTrg + 1;
        }
        long fct = HealpixMoc.pow2(orderTrg - orderSrc);
        fct *= fct;
        npix *= fct;
        boolean rep = false;
        int i = 0;
        while ((long)i < fct) {
            rep |= this.level[orderTrg].add(npix + (long)i, this.testConsistency);
            ++i;
        }
        return rep;
    }

    protected void addHpix(String s) throws Exception {
        int j;
        int i = s.indexOf(47);
        if (i < 0) {
            i = s.indexOf(58);
        }
        if (i > 0) {
            this.currentOrder = Integer.parseInt(this.unQuote(s.substring(0, i)));
        }
        if ((j = s.indexOf(45, i + 1)) < 0) {
            String s1 = this.unBracket(s.substring(i + 1));
            if (s1.length() > 0) {
                this.add(this.currentOrder, Long.parseLong(s1));
            }
        } else {
            long startIndex = Long.parseLong(s.substring(i + 1, j));
            long endIndex = Long.parseLong(s.substring(j + 1));
            long k = startIndex;
            while (k <= endIndex) {
                this.add(this.currentOrder, k);
                ++k;
            }
        }
    }

    private String unQuote(String s) {
        int n = s.length();
        if (n > 2 && s.charAt(0) == '\"' && s.charAt(n - 1) == '\"') {
            return s.substring(1, n - 1);
        }
        return s;
    }

    private String unBracket(String s) {
        int n = s.length();
        if (n < 1) {
            return s;
        }
        int o1 = s.charAt(0) == '[' ? 1 : 0;
        int o2 = s.charAt(n - 1) == ']' ? n - 1 : n;
        return s.substring(o1, o2);
    }

    private void deleteHpix(String s) {
        int j;
        int i = s.indexOf(47);
        if (i > 0) {
            this.currentOrder = Integer.parseInt(s.substring(0, i));
        }
        if ((j = s.indexOf(45, i + 1)) < 0) {
            this.delete(this.currentOrder, Integer.parseInt(s.substring(i + 1)));
        } else {
            int startIndex = Integer.parseInt(s.substring(i + 1, j));
            int endIndex = Integer.parseInt(s.substring(j + 1));
            int k = startIndex;
            while (k <= endIndex) {
                this.delete(this.currentOrder, k);
                ++k;
            }
        }
    }

    private void check() throws Exception {
        if (!this.testConsistency) {
            this.setCheckConsistencyFlag(true);
        } else {
            this.sort();
        }
    }

    private void testCompatibility(HealpixMoc moc) throws Exception {
        if (this.getCoordSys().charAt(0) != moc.getCoordSys().charAt(0)) {
            throw new Exception("Incompatible MOC coordsys");
        }
    }

    private int strategie(int size1, int size2) {
        if (size1 == 0 || size2 == 0) {
            return 0;
        }
        double m1 = (double)size1 * (1.0 + Math.log(size2) / Math.log(2.0));
        double m2 = (double)size2 * (1.0 + Math.log(size1) / Math.log(2.0));
        double m3 = size1 + size2;
        if (m1 < m2 && m1 < m3) {
            return 1;
        }
        if (m2 < m1 && m2 < m3) {
            return 2;
        }
        return 3;
    }

    private boolean isIn(int order, Array a) {
        Array a1 = this.level[order];
        Array a2 = a;
        int size2 = a2.getSize();
        int size1 = a1.getSize();
        if (!a1.intersectRange(a2.get(0), a2.get(size2 - 1))) {
            return false;
        }
        switch (this.strategie(size1, size2)) {
            case 0: {
                return false;
            }
            case 1: {
                for (long x : a1) {
                    if (a2.find(x) < 0) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                for (long x : a2) {
                    if (a1.find(x) < 0) continue;
                    return true;
                }
                return false;
            }
        }
        boolean incr1 = true;
        long x1 = a1.get(0);
        long x2 = a2.get(0);
        int i1 = 0;
        int i2 = 0;
        while (i1 < size1 && i2 < size2) {
            if (incr1) {
                x1 = a1.get(i1);
            } else {
                x2 = a2.get(i2);
            }
            if (x1 == x2) {
                return true;
            }
            boolean bl = incr1 = x1 < x2;
            if (incr1) {
                ++i1;
                continue;
            }
            ++i2;
        }
        return false;
    }

    private boolean isAscendant(int order, Array a) {
        long range = 4L;
        int o = order + 1;
        while (o < this.nOrder) {
            Array a1 = this.level[o];
            Array a2 = a;
            int size2 = a2.getSize();
            int size1 = a1.getSize();
            if (a1.intersectRange(a2.get(0) * range, a2.get(size2 - 1) * range)) {
                switch (this.strategie(size1, size2)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        long onpix = -1L;
                        for (long x : a1) {
                            long npix = x / range;
                            if (npix == onpix) continue;
                            if (a2.find(npix) >= 0) {
                                return true;
                            }
                            onpix = npix;
                        }
                        break;
                    }
                    case 2: {
                        for (long pix : a2) {
                            if (!a1.intersectRange(pix * range, (pix + 1L) * range - 1L)) continue;
                            return true;
                        }
                        break;
                    }
                    default: {
                        boolean incr1 = true;
                        long x1 = a1.get(0);
                        long x2 = a2.get(0) * range;
                        long x3 = (a2.get(0) + 1L) * range - 1L;
                        int i1 = 0;
                        int i2 = 0;
                        while (i1 < size1 && i2 < size2) {
                            if (incr1) {
                                x1 = a1.get(i1);
                            } else {
                                x2 = a2.get(i2) * range;
                                x3 = (a2.get(i2) + 1L) * range - 1L;
                            }
                            if (x2 <= x1 && x1 <= x3) {
                                return true;
                            }
                            boolean bl = incr1 = x1 < x3;
                            if (incr1) {
                                ++i1;
                                continue;
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
            }
            ++o;
            range *= 4L;
        }
        return false;
    }

    private boolean isDescendant(int order, Array a) {
        long range = 4L;
        int o = order - 1;
        while (o >= 0) {
            Array a1 = this.level[o];
            Array a2 = a;
            int size2 = a2.getSize();
            int size1 = a1.getSize();
            if (a1.intersectRange(a2.get(0) / range, a2.get(size2 - 1) / range)) {
                switch (this.strategie(size1, size2)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        for (long x : a1) {
                            if (!a2.intersectRange(x * range, (x + 1L) * range - 1L)) continue;
                            return true;
                        }
                        break;
                    }
                    case 2: {
                        long onpix = -1L;
                        for (long x : a2) {
                            long npix = x / range;
                            if (npix == onpix) continue;
                            if (a1.find(npix) >= 0) {
                                return true;
                            }
                            onpix = npix;
                        }
                        break;
                    }
                    default: {
                        boolean incr1 = true;
                        long x1 = a1.get(0);
                        long x2 = a2.get(0) / range;
                        int i1 = 0;
                        int i2 = 0;
                        while (i1 < size1 && i2 < size2) {
                            if (incr1) {
                                x1 = a1.get(i1);
                            } else {
                                x2 = a2.get(i2) / range;
                            }
                            if (x1 == x2) {
                                return true;
                            }
                            boolean bl = incr1 = x1 < x2;
                            if (incr1) {
                                ++i1;
                                continue;
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
            }
            --o;
            range *= 4L;
        }
        return false;
    }

    private boolean isInTree(int order, Array a) {
        if (a == null || a.getSize() == 0) {
            return false;
        }
        if (a.getSize() == 1) {
            return this.isInTree(order, a.get(0));
        }
        return this.isIn(order, a) || this.isAscendant(order, a) || this.isDescendant(order, a);
    }

    public static long hpix2uniq(int order, long npix) {
        long nside = HealpixMoc.pow2(order);
        return 4L * nside * nside + npix;
    }

    public static long[] uniq2hpix(long uniq) {
        return HealpixMoc.uniq2hpix(uniq, null);
    }

    public static long[] uniq2hpix(long uniq, long[] hpix) {
        if (hpix == null) {
            hpix = new long[2];
        }
        hpix[0] = HealpixMoc.log2(uniq / 4L) / 2L;
        long nside = HealpixMoc.pow2(hpix[0]);
        hpix[1] = uniq - 4L * nside * nside;
        return hpix;
    }

    private static double getPixelArea(int order) {
        if (order < 0) {
            return SKYAREA;
        }
        long nside = HealpixMoc.pow2(order);
        long npixels = 12L * nside * nside;
        return SKYAREA / (double)npixels;
    }

    public static final long pow2(long order) {
        return 1 << (int)order;
    }

    public static final long log2(long nside) {
        int i = 0;
        while (nside >>> ++i > 0L) {
        }
        return --i;
    }

    private class HpixListIterator
    implements Iterator<MocCell> {
        private int currentOrder = 0;
        private int indice = -1;
        private boolean ready = false;

        private HpixListIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return this.currentOrder < HealpixMoc.this.nOrder;
        }

        @Override
        public MocCell next() {
            if (!this.hasNext()) {
                return null;
            }
            this.ready = false;
            Array a = HealpixMoc.this.level[this.currentOrder];
            return new MocCell(this.currentOrder, a.get(this.indice));
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.ready) {
                return;
            }
            ++this.indice;
            while (this.currentOrder < HealpixMoc.this.nOrder && this.indice >= HealpixMoc.this.getSize(this.currentOrder)) {
                ++this.currentOrder;
                this.indice = 0;
            }
            this.ready = true;
        }
    }

    private class PixelIterator
    implements Iterator<Long> {
        private boolean ready = false;
        private long current;
        private int order = -1;
        private long indice = 0L;
        private long range = 0L;
        private long currentTete;
        private boolean hasNext = true;
        private int[] p;

        private PixelIterator() {
            this.p = new int[HealpixMoc.this.getMocOrder() + 1];
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return this.hasNext;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                return null;
            }
            this.ready = false;
            return this.current;
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.ready) {
                return;
            }
            if (this.indice == this.range) {
                long min = Long.MAX_VALUE;
                long fct = 1L;
                long tete = -1L;
                int mocOrder = HealpixMoc.this.getMocOrder();
                this.order = -1;
                int o = mocOrder;
                while (o >= HealpixMoc.this.minLimitOrder) {
                    Array a = HealpixMoc.this.level[o];
                    if (a != null) {
                        long l = tete = this.p[o] < a.getSize() ? a.get(this.p[o]) * fct : -1L;
                        if (tete != -1L && tete < min) {
                            min = tete;
                            this.order = o;
                            this.range = fct;
                        }
                    }
                    --o;
                    fct *= 4L;
                }
                if (this.order == -1) {
                    this.hasNext = false;
                    this.ready = true;
                    return;
                }
                this.currentTete = min;
                this.indice = 0L;
            }
            this.current = new Long(this.currentTete + this.indice);
            ++this.indice;
            if (this.indice == this.range) {
                int n = this.order;
                this.p[n] = this.p[n] + 1;
            }
            this.ready = true;
        }
    }
}

