/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Array;
import cds.moc.HealpixMoc;
import cds.moc.MocCell;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class MocIO {
    public static final int FITS = 0;
    public static final int JSON = 1;
    public static final int ASCII = 2;
    public static final int JSON0 = 3;
    private static String CR = System.getProperty("line.separator");
    private String[][] FITSKEY = new String[][]{{"COORDSYS", "Reference frame"}, {"MOCORDER", "MOC resolution (best order)"}, {"MOCTOOL", "Name of the MOC generator"}, {"MOCTYPE", "Source type (IMAGE or CATALOG)"}, {"MOCID", "Identifier of the collection"}, {"ORIGIN", "MOC origin"}, {"DATE", "MOC creation date"}, {"EXTNAME", "MOC name"}};
    public static final String OLDSIGNATURE = "HPXMOC";
    public static final String SIGNATURE = "MOCORDER";
    private HealpixMoc moc;
    private byte firstChar = 0;
    private static final int MAXWORD = 20;
    private static final int MAXSIZE = 80;

    public MocIO(HealpixMoc m) {
        this.moc = m;
    }

    public void read(String filename) throws Exception {
        File f = new File(filename);
        FileInputStream fi = null;
        BufferedInputStream bf = null;
        try {
            fi = new FileInputStream(f);
            bf = new BufferedInputStream(fi);
            this.read(bf);
        }
        finally {
            if (bf != null) {
                bf.close();
            } else if (fi != null) {
                fi.close();
            }
        }
    }

    public void read(String filename, int mode) throws Exception {
        this.read(filename);
    }

    public void read(InputStream in) throws Exception {
        byte[] b = new byte[1];
        in.read(b);
        this.firstChar = b[0];
        int mode = this.firstChar == 83 ? 0 : 2;
        this.read(in, mode);
    }

    public void read(InputStream in, int mode) throws Exception {
        if (mode == 0) {
            this.readFits(in);
        } else {
            this.readASCII(in);
        }
        this.moc.trim();
    }

    public void readASCII(InputStream in) throws Exception {
        String s;
        BufferedReader dis = new BufferedReader(new InputStreamReader(in));
        this.moc.clear();
        this.moc.setCheckConsistencyFlag(false);
        boolean flagMocOrder = false;
        int line = 0;
        while ((s = dis.readLine()) != null) {
            if (this.firstChar != 0) {
                s = String.valueOf((char)this.firstChar) + s;
                this.firstChar = 0;
            }
            if (s.length() != 0) {
                String v;
                if (line == 0 && s.startsWith("#MOCORDER ") && (v = s.substring(10)).length() > 0) {
                    flagMocOrder = true;
                    this.moc.setProperty(SIGNATURE, v);
                }
                this.parseASCIILine(s);
            }
            ++line;
        }
        if (!flagMocOrder) {
            this.moc.setProperty("MORORDER", String.valueOf(this.moc.getMaxOrder()));
        }
    }

    public void readFits(InputStream in) throws Exception {
        this.moc.clear();
        this.moc.setCheckConsistencyFlag(false);
        HeaderFits header = new HeaderFits();
        header.readHeader(in);
        String v = header.getStringFromHeader(OLDSIGNATURE);
        if (v != null) {
            this.moc.setProperty(SIGNATURE, v);
        }
        try {
            int nbyte;
            header.readHeader(in);
            v = header.getStringFromHeader(OLDSIGNATURE);
            if (v != null) {
                this.moc.setProperty(SIGNATURE, v);
            }
            int i = 0;
            while (i < this.FITSKEY.length) {
                String key = this.FITSKEY[i][0];
                String value = header.getStringFromHeader(key);
                if (value != null) {
                    this.moc.setProperty(key, value);
                }
                ++i;
            }
            int naxis1 = header.getIntFromHeader("NAXIS1");
            int naxis2 = header.getIntFromHeader("NAXIS2");
            String tform = header.getStringFromHeader("TFORM1");
            int n = tform.indexOf(75) >= 0 ? 8 : (nbyte = tform.indexOf(74) >= 0 ? 4 : -1);
            if (nbyte <= 0) {
                throw new Exception("HEALPix Multi Order Coverage Map only requieres integers (32bits or 64bits)");
            }
            byte[] buf = new byte[naxis1 * naxis2];
            this.readFully(in, buf);
            this.createUniq(naxis1 * naxis2 / nbyte, nbyte, buf);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void write(String filename) throws Exception {
        this.write(filename, 0);
    }

    public void write(String filename, int mode) throws Exception {
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new Exception("Unknown MOC format !");
        }
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream fo = null;
        FilterOutputStream fb = null;
        try {
            fo = new FileOutputStream(f);
            fb = new BufferedOutputStream(fo);
            if (mode == 0) {
                this.writeFits(fb);
            } else if (mode == 1 || mode == 2) {
                this.writeJSON(fb);
            }
        }
        finally {
            if (fb != null) {
                fb.close();
            } else if (fo != null) {
                fo.close();
            }
        }
    }

    public void write(OutputStream out) throws Exception {
        this.write(out, 0);
    }

    public void write(OutputStream out, int mode) throws Exception {
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new Exception("Unknown MOC format !");
        }
        if (mode == 0) {
            this.writeFits(out);
        } else if (mode == 1 || mode == 2) {
            this.writeJSON(out);
        }
    }

    private void testMocNotNull() throws Exception {
        if (this.moc == null) {
            throw new Exception("No MOC assigned (use setMoc(HealpixMoc))");
        }
    }

    public void writeASCII(OutputStream out) throws Exception {
        this.testMocNotNull();
        out.write(("#MOCORDER " + this.moc.getMocOrder() + CR).getBytes());
        StringBuilder res = new StringBuilder(this.moc.getSize() * 8);
        int order = -1;
        boolean flagNL = this.moc.getSize() > 20;
        int sizeLine = 0;
        int j = 0;
        for (MocCell c : this.moc) {
            if (res.length() > 0) {
                if (c.order != order) {
                    if (flagNL) {
                        res.append("\n");
                        sizeLine = 0;
                        ++j;
                    } else {
                        res.append(" ");
                    }
                } else {
                    int n = String.valueOf(c.npix).length();
                    if (flagNL && n + sizeLine > 80) {
                        res.append(",\n ");
                        sizeLine = 3;
                        ++j;
                    } else {
                        res.append(',');
                        ++sizeLine;
                    }
                }
                if (j > 15) {
                    this.writeASCIIFlush(out, res, false);
                    j = 0;
                }
            }
            String s = c.order != order ? String.valueOf(c.order) + "/" + c.npix : String.valueOf(c.npix);
            res.append(s);
            sizeLine += s.length();
            order = c.order;
        }
        int n = res.length();
        if (res.charAt(n - 1) == ',') {
            res.replace(n - 1, n - 1, flagNL ? "\n" : " ");
        } else {
            res.append(flagNL ? "\n" : " ");
        }
        this.writeASCIIFlush(out, res);
    }

    public void writeJSON(OutputStream out) throws Exception {
        this.testMocNotNull();
        out.write(CR.getBytes());
        StringBuilder s = new StringBuilder(2048);
        int nOrder = this.moc.getMaxOrder() + 1;
        s.append("{");
        boolean first = true;
        int order = 0;
        while (order < nOrder) {
            int n = this.moc.getSize(order);
            if (n != 0 || order >= nOrder - 1) {
                Array a = this.moc.getArray(order);
                if (!first) {
                    s.append("]," + CR);
                }
                first = false;
                s.append("\"" + order + "\":[");
                int j = 0;
                int i = 0;
                while (i < n) {
                    s.append(String.valueOf(a.get(i)) + (i == n - 1 ? "" : ","));
                    if (++j == 15) {
                        this.writeASCIIFlush(out, s);
                        j = 0;
                    }
                    ++i;
                }
            }
            ++order;
        }
        if (!first) {
            s.append("]");
        }
        s.append("}");
        this.writeASCIIFlush(out, s);
    }

    public void writeFits(OutputStream out) throws Exception {
        this.testMocNotNull();
        this.writeHeader0(out);
        int maxOrder = this.moc.getMocOrder();
        int nbytes = HealpixMoc.getType(maxOrder) == 2 ? 8 : 4;
        this.writeHeader1(out, nbytes);
        this.writeData(out, nbytes);
    }

    private void setCurrentParseOrder(String s) throws Exception {
        int i = s.indexOf(61);
        try {
            this.moc.setCurrentOrder((int)HealpixMoc.log2(Long.parseLong(s.substring(i + 1))));
        }
        catch (Exception e) {
            throw new Exception("HpixList.setNside: syntax error [" + s + "]");
        }
    }

    private void setOrder(String s) throws Exception {
        int i = s.indexOf(61);
        if (s.charAt(i - 1) == 'R') {
            try {
                this.moc.setCurrentOrder(Integer.parseInt(s.substring(i + 1)));
            }
            catch (Exception e) {
                throw new Exception("HpixList.setOrder: syntax error [" + s + "]");
            }
            return;
        }
    }

    private void setCoord(String s) throws Exception {
        int i = s.indexOf(61);
        this.moc.setCoordSys(s.substring(i + 1));
    }

    private void parseASCIILine(String s) throws Exception {
        char a = s.charAt(0);
        if (a == '#') {
            return;
        }
        if (a == 'N') {
            this.setCurrentParseOrder(s);
        } else if (a == 'C') {
            this.setCoord(s);
        } else if (a == 'O') {
            this.setOrder(s);
        } else {
            StringTokenizer st = new StringTokenizer(s, " ;,\n\r\t{}");
            while (st.hasMoreTokens()) {
                String s1 = st.nextToken();
                if (s1.length() == 0) continue;
                this.moc.addHpix(s1);
            }
        }
    }

    public void createUniq(int nval, int nbyte, byte[] t) throws Exception {
        int i = 0;
        long[] hpix = null;
        long oval = -1L;
        int k = 0;
        while (k < nval) {
            long val = 0L;
            int a = t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
            if (nbyte == 4) {
                val = a;
            } else {
                int b = t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF;
                val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
            }
            i += nbyte;
            long min = val;
            if (val < 0L) {
                min = oval + 1L;
                val = -val;
            }
            long v = min;
            while (v <= val) {
                hpix = HealpixMoc.uniq2hpix(v, hpix);
                int order = (int)hpix[0];
                this.moc.add(order, hpix[1]);
                ++v;
            }
            oval = val;
            ++k;
        }
    }

    private void writeASCIIFlush(OutputStream out, StringBuilder s) throws Exception {
        this.writeASCIIFlush(out, s, true);
    }

    private void writeASCIIFlush(OutputStream out, StringBuilder s, boolean nl) throws Exception {
        if (nl) {
            s.append(CR);
        }
        out.write(s.toString().getBytes());
        s.delete(0, s.length());
    }

    private void writeHeader0(OutputStream out) throws Exception {
        int n = 0;
        out.write(this.getFitsLine("SIMPLE", "T", "Written by MOC java API 4.5"));
        n += 80;
        out.write(this.getFitsLine("BITPIX", "8"));
        n += 80;
        out.write(this.getFitsLine("NAXIS", "0"));
        n += 80;
        out.write(this.getFitsLine("EXTEND", "T"));
        out.write(this.getEndBourrage(n += 80));
    }

    private void writeHeader1(OutputStream out, int nbytes) throws Exception {
        int n = 0;
        int naxis2 = this.moc.getSize();
        out.write(this.getFitsLine("XTENSION", "BINTABLE", "HEALPix Multi Order Coverage map"));
        n += 80;
        out.write(this.getFitsLine("BITPIX", "8"));
        n += 80;
        out.write(this.getFitsLine("NAXIS", "2"));
        n += 80;
        out.write(this.getFitsLine("NAXIS1", String.valueOf(nbytes)));
        n += 80;
        out.write(this.getFitsLine("NAXIS2", "" + naxis2));
        n += 80;
        out.write(this.getFitsLine("PCOUNT", "0"));
        n += 80;
        out.write(this.getFitsLine("GCOUNT", "1"));
        n += 80;
        out.write(this.getFitsLine("TFIELDS", "1"));
        n += 80;
        out.write(this.getFitsLine("TFORM1", nbytes == 4 ? "1J" : "1K"));
        n += 80;
        out.write(this.getFitsLine("TTYPE1", "UNIQ", "HEALPix UNIQ pixel number"));
        n += 80;
        out.write(this.getFitsLine("PIXTYPE", "HEALPIX", "HEALPix magic code"));
        n += 80;
        out.write(this.getFitsLine("ORDERING", "NUNIQ", "NUNIQ coding method"));
        n += 80;
        int i = 0;
        while (i < this.FITSKEY.length) {
            String key = this.FITSKEY[i][0];
            String value = this.moc.getProperty(key);
            if (value != null) {
                out.write(this.getFitsLine(key, value, this.FITSKEY[i][1]));
                n += 80;
            }
            ++i;
        }
        out.write(this.getEndBourrage(n));
    }

    private void writeData(OutputStream out, int nbytes) throws Exception {
        if (this.moc.getSize() <= 0) {
            return;
        }
        byte[] buf = new byte[nbytes];
        int size = 0;
        int nOrder = this.moc.getMaxOrder() + 1;
        int order = 0;
        while (order < nOrder) {
            int n = this.moc.getSize(order);
            if (n != 0) {
                Array a = this.moc.getArray(order);
                int i = 0;
                while (i < n) {
                    long val = HealpixMoc.hpix2uniq(order, a.get(i));
                    size += this.writeVal(out, val, buf);
                    ++i;
                }
            }
            ++order;
        }
        out.write(this.getBourrage(size));
    }

    private int writeVal(OutputStream out, long val, byte[] buf) throws Exception {
        int j = 0;
        int shift = (buf.length - 1) * 8;
        while (j < buf.length) {
            buf[j] = (byte)(0xFFL & val >> shift);
            ++j;
            shift -= 8;
        }
        out.write(buf);
        return buf.length;
    }

    private byte[] getFitsLine(String key, String value) {
        return this.getFitsLine(key, value, null);
    }

    private byte[] getFitsLine(String key, String value, String comment) {
        int i = 0;
        byte[] b = new byte[80];
        char[] a = key.toCharArray();
        int j = 0;
        while (i < 8) {
            b[i] = (byte)(j < a.length ? a[j] : 32);
            ++j;
            ++i;
        }
        if (value != null) {
            b[i++] = 61;
            b[i++] = 32;
            a = value.toCharArray();
            if (!this.isFitsString(value)) {
                j = 0;
                while (j < 20 - a.length) {
                    b[i++] = 32;
                    ++j;
                }
                j = 0;
                while (i < 80 && j < a.length) {
                    b[i] = (byte)a[j];
                    ++j;
                    ++i;
                }
            } else {
                a = this.formatFitsString(a);
                j = 0;
                while (i < 80 && j < a.length) {
                    b[i] = (byte)a[j];
                    ++j;
                    ++i;
                }
                while (i < 30) {
                    b[i++] = 32;
                }
            }
        }
        if (comment != null && comment.length() > 0) {
            if (value != null) {
                b[i++] = 32;
                b[i++] = 47;
                b[i++] = 32;
            }
            a = comment.toCharArray();
            j = 0;
            while (i < 80 && j < a.length) {
                b[i] = (byte)a[j];
                ++j;
                ++i;
            }
        }
        while (i < 80) {
            b[i++] = 32;
        }
        return b;
    }

    private byte[] getEndBourrage(int headSize) {
        int size = 2880 - headSize % 2880;
        if (size < 3) {
            size += 2880;
        }
        byte[] b = new byte[size];
        b[0] = 69;
        b[1] = 78;
        b[2] = 68;
        int i = 3;
        while (i < b.length) {
            b[i] = 32;
            ++i;
        }
        return b;
    }

    private byte[] getBourrage(int currentPos) {
        int size = 2880 - currentPos % 2880;
        byte[] b = new byte[size];
        return b;
    }

    private void readFully(InputStream in, byte[] buf) throws IOException {
        this.readFully(in, buf, 0, buf.length);
    }

    private void readFully(InputStream in, byte[] buf, int offset, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int m = in.read(buf, offset + n, len - n < 512 ? len - n : 512);
            if (m == -1) {
                throw new EOFException();
            }
            n += m;
        }
    }

    private boolean isFitsString(String s) {
        if (s.length() == 0) {
            return true;
        }
        char c = s.charAt(0);
        if (s.length() == 1 && (c == 'T' || c == 'F')) {
            return false;
        }
        if (!Character.isDigit(c) && c != '.' && c != '-' && c != '+') {
            return true;
        }
        try {
            Double.valueOf(s);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private char[] formatFitsString(char[] a) {
        if (a.length == 0) {
            return a;
        }
        StringBuffer s = new StringBuffer();
        boolean flagQuote = a[0] == '\'';
        s.append('\'');
        int i = flagQuote ? 1 : 0;
        while (i < a.length - (flagQuote ? 1 : 0)) {
            if (!flagQuote && a[i] == '\'') {
                s.append('\'');
            }
            s.append(a[i]);
            ++i;
        }
        while (i < (flagQuote ? 9 : 8)) {
            s.append(' ');
            ++i;
        }
        s.append('\'');
        return s.toString().toCharArray();
    }

    class HeaderFits {
        private Hashtable<String, String> header;
        private int sizeHeader = 0;

        HeaderFits() {
        }

        private String getValue(byte[] buffer) {
            int offset;
            boolean quote = false;
            boolean blanc = true;
            int i = offset = 9;
            while (i < 80) {
                if (quote ? buffer[i] == 39 : buffer[i] == 47) break;
                if (blanc) {
                    if (buffer[i] != 32) {
                        blanc = false;
                    }
                    if (buffer[i] == 39) {
                        quote = true;
                        offset = i + 1;
                    }
                }
                ++i;
            }
            return new String(buffer, 0, offset, i - offset).trim();
        }

        private String getKey(byte[] buffer) {
            return new String(buffer, 0, 0, 8).trim();
        }

        private void readHeader(InputStream dis) throws Exception {
            int blocksize = 2880;
            int fieldsize = 80;
            int linesRead = 0;
            this.sizeHeader = 0;
            this.header = new Hashtable(200);
            byte[] buffer = new byte[fieldsize];
            while (true) {
                if (MocIO.this.firstChar == 0) {
                    MocIO.this.readFully(dis, buffer);
                } else {
                    buffer[0] = MocIO.this.firstChar;
                    MocIO.this.firstChar = (byte)0;
                    MocIO.this.readFully(dis, buffer, 1, buffer.length - 1);
                }
                String key = this.getKey(buffer);
                if (linesRead == 0 && !key.equals("SIMPLE") && !key.equals("XTENSION")) {
                    throw new Exception("Not a MOC FITS format");
                }
                this.sizeHeader += fieldsize;
                ++linesRead;
                if (key.equals("END")) break;
                if (buffer[8] != 61) continue;
                String value = this.getValue(buffer);
                this.header.put(key, value);
            }
            int bourrage = blocksize - this.sizeHeader % blocksize;
            if (bourrage != blocksize) {
                byte[] tmp = new byte[bourrage];
                MocIO.this.readFully(dis, tmp);
                this.sizeHeader += bourrage;
            }
        }

        private int getIntFromHeader(String key) throws NumberFormatException, NullPointerException {
            String s = this.header.get(key.trim());
            return (int)Double.parseDouble(s.trim());
        }

        private String getStringFromHeader(String key) throws NullPointerException {
            String s = this.header.get(key.trim());
            if (s == null || s.length() == 0) {
                return s;
            }
            if (s.charAt(0) == '\'') {
                return s.substring(1, s.length() - 1).trim();
            }
            return s;
        }
    }
}

