/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Array;
import java.util.Arrays;

public final class ShortArray
extends Array {
    private short[] array;

    public ShortArray(int bloc) {
        this.array = null;
        this.size = 0;
        this.sorted = true;
        this.sizeBloc = bloc;
    }

    public ShortArray(short[] v) {
        this.array = v;
        this.size = v.length;
        this.sizeBloc = 128;
        this.sorted = true;
    }

    @Override
    public Array clone() {
        ShortArray a = new ShortArray(this.sizeBloc);
        if (this.array == null) {
            a.array = null;
        } else {
            a.array = new short[this.array.length];
            System.arraycopy(this.array, 0, a.array, 0, this.size);
        }
        a.size = this.size;
        a.sorted = this.sorted;
        return a;
    }

    @Override
    public boolean equals(Array a) {
        if (this == a) {
            return true;
        }
        if (this.size != a.size) {
            return false;
        }
        if (this.size == 0) {
            return true;
        }
        this.sort();
        a.sort();
        int i = 0;
        while (i < this.size) {
            if (this.array[i] != ((ShortArray)a).array[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public short[] seeArray() {
        return this.array;
    }

    @Override
    public long get(int i) {
        return this.array[i];
    }

    @Override
    public void set(int i, long v) {
        this.array[i] = (short)v;
    }

    @Override
    public long getMem() {
        return 9 + (this.array == null ? 0 : this.array.length * 2);
    }

    public int geSize() {
        return this.size;
    }

    @Override
    public int getSizeCompressed() {
        if (this.array == null) {
            return 0;
        }
        int reduce = 0;
        boolean oConsecutif = false;
        int i = 1;
        while (i < this.size) {
            boolean consecutif;
            boolean bl = consecutif = this.array[i] == this.array[i - 1] + 1;
            if (oConsecutif && consecutif) {
                ++reduce;
            }
            oConsecutif = consecutif;
            ++i;
        }
        return this.size - reduce;
    }

    @Override
    public boolean add(long v, boolean testUnicity) {
        return this.add((short)v, testUnicity);
    }

    public boolean add(short v, boolean testUnicity) {
        int pos = -1;
        if (testUnicity && (pos = this.find(v)) >= 0) {
            return false;
        }
        this.adjustSize(1);
        if (testUnicity && this.sorted) {
            pos = -(pos + 1);
            System.arraycopy(this.array, pos, this.array, pos + 1, this.size - pos);
            this.array[pos] = v;
            ++this.size;
        } else {
            if (this.sorted) {
                this.sorted = this.size == 0 || v > this.array[this.size - 1];
            }
            this.array[this.size++] = v;
        }
        return true;
    }

    @Override
    public boolean delete(long v) {
        return this.delete((short)v);
    }

    public boolean delete(short v) {
        int pos = this.find(v);
        if (pos < 0) {
            return false;
        }
        if (!this.sorted) {
            this.array[pos] = this.array[this.size - 1];
        } else {
            System.arraycopy(this.array, pos + 1, this.array, pos, this.size - pos - 1);
        }
        --this.size;
        return true;
    }

    @Override
    public boolean delete(long v1, long v2) {
        return this.delete((short)v1, (short)v2);
    }

    public boolean delete(short v1, short v2) {
        int j = 0;
        int i = 0;
        while (i < this.size) {
            if (this.array[i] < v1 || this.array[i] > v2) {
                this.array[j++] = this.array[i];
            }
            ++i;
        }
        this.size = j;
        return j != i;
    }

    @Override
    public boolean deleteBrothers(long me) {
        return this.deleteBrothers((short)me);
    }

    public boolean deleteBrothers(short me) {
        int firstBrother = me - me % 4;
        int[] pos = new int[3];
        int j = 0;
        int i = 0;
        while (j < 3 && i < 4) {
            int v = firstBrother + i;
            if (v == me) {
                --j;
            } else {
                pos[j] = j == 0 ? this.find(v) : (this.sorted ? (this.array[pos[j - 1] + 1] == v ? pos[j - 1] + 1 : -1) : this.find(v));
                if (pos[j] < 0 || this.sorted && this.size - pos[j] < 3 - j) {
                    return false;
                }
            }
            ++i;
            ++j;
        }
        if (this.sorted) {
            System.arraycopy(this.array, pos[2] + 1, this.array, pos[0], this.size - (pos[2] + 1));
        } else {
            int i2 = 0;
            while (i2 < 3) {
                this.array[pos[i2]] = this.array[this.size - 1 - i2];
                ++i2;
            }
        }
        this.size -= 3;
        return true;
    }

    @Override
    public int find(long v) {
        return this.find((short)v);
    }

    public int find(short v) {
        if (this.array == null) {
            return -1;
        }
        int i = -1;
        if (this.sorted) {
            if (this.size == 0 || v < this.array[0]) {
                return -1;
            }
            if (v > this.array[this.size - 1]) {
                return -(this.size + 1);
            }
            i = this.binarySearch(this.array, 0, this.size, v);
        } else {
            i = 0;
            while (i < this.size && this.array[i] != v) {
                ++i;
            }
            if (i == this.size) {
                i = -1;
            }
        }
        return i;
    }

    @Override
    public boolean intersectRange(long vStart, long vEnd) {
        return this.intersectRange((short)vStart, (short)vEnd);
    }

    public boolean intersectRange(short vStart, short vEnd) {
        if (this.array == null) {
            return false;
        }
        if (this.sorted) {
            int pos2;
            int pos1;
            int n = this.size == 0 || vStart < this.array[0] ? -1 : (pos1 = vStart > this.array[this.size - 1] ? -(this.size + 1) : this.binarySearch(this.array, 0, this.size, vStart));
            if (pos1 >= 0) {
                return true;
            }
            int n2 = this.size == 0 || vEnd < this.array[0] ? -1 : (pos2 = vEnd > this.array[this.size - 1] ? -(this.size + 1) : this.binarySearch(this.array, 0, this.size, vEnd));
            if (pos2 >= 0) {
                return true;
            }
            return pos1 != pos2;
        }
        int i = 0;
        while (i < this.size) {
            long v = this.array[i];
            if ((long)vStart <= v && v <= (long)vEnd) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int binarySearch(short[] a, int fromIndex, int toIndex, short key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            short midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public void sort() {
        if (this.array == null) {
            return;
        }
        if (this.sorted) {
            return;
        }
        Arrays.sort(this.array, 0, this.size);
        this.sorted = true;
    }

    @Override
    public void trim() {
        if (this.array == null || this.size == this.array.length) {
            return;
        }
        short[] nArray = new short[this.size];
        System.arraycopy(this.array, 0, nArray, 0, this.size);
    }

    private void adjustSize(int n) {
        if (n == 0 || this.array != null && this.size + n < this.array.length) {
            return;
        }
        short[] nArray = new short[(1 + (this.size + n) / this.sizeBloc) * this.sizeBloc];
        if (this.array != null) {
            System.arraycopy(this.array, 0, nArray, 0, this.size);
        }
        this.array = nArray;
        this.sizeBloc += this.array.length / 10;
        nArray = null;
    }
}

