/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.HealpixImpl;
import healpix.essentials.HealpixBase;
import healpix.essentials.Pointing;
import healpix.essentials.RangeSet;
import healpix.essentials.Scheme;

public final class Healpix
implements HealpixImpl {
    public static final int MAXORDER = 29;
    private static HealpixBase[] healpixBase = new HealpixBase[30];

    static {
        try {
            int order = 0;
            while (order < healpixBase.length) {
                Healpix.healpixBase[order] = new HealpixBase(Healpix.pow2(order), Scheme.NESTED);
                ++order;
            }
        }
        catch (Exception e) {
            healpixBase = null;
        }
    }

    @Override
    public long ang2pix(int order, double lon, double lat) throws Exception {
        double theta = 1.5707963267948966 - lat / 180.0 * Math.PI;
        double phi = lon / 180.0 * Math.PI;
        return healpixBase[order].ang2pix(new Pointing(theta, phi));
    }

    @Override
    public double[] pix2ang(int order, long npix) throws Exception {
        Pointing res = healpixBase[order].pix2ang(npix);
        return new double[]{res.phi * 180.0 / Math.PI, (1.5707963267948966 - res.theta) * 180.0 / Math.PI};
    }

    @Override
    public long[] queryDisc(int order, double lon, double lat, double radius) throws Exception {
        double theta = 1.5707963267948966 - lat / 180.0 * Math.PI;
        double phi = lon / 180.0 * Math.PI;
        RangeSet list = healpixBase[order].queryDiscInclusive(new Pointing(theta, phi), Math.toRadians(radius), 2);
        if (list == null) {
            return new long[0];
        }
        return list.toArray();
    }

    public static final long pow2(long order) {
        return 1 << (int)order;
    }

    public static final long log2(long nside) {
        int i = 0;
        while (nside >>> ++i > 0L) {
        }
        return --i;
    }
}

