/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.SMoc;
import java.io.InputStream;

public class HealpixMoc
extends SMoc {
    public HealpixMoc(SMoc moc) {
        try {
            this.clone1(moc);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public HealpixMoc dup() {
        return new HealpixMoc(super.dup());
    }

    public HealpixMoc() {
    }

    public HealpixMoc(int maxLimitOrder) throws Exception {
        this.setMocOrder(maxLimitOrder);
    }

    public HealpixMoc(int minLimitOrder, int maxLimitOrder) throws Exception {
        this.setMocOrder(maxLimitOrder);
        this.setMinOrder(minLimitOrder);
    }

    public HealpixMoc(String coordSys, int minLimitOrder, int maxLimitOrder) throws Exception {
        this.setMocOrder(maxLimitOrder);
        this.setMinOrder(minLimitOrder);
        this.setSys(coordSys);
    }

    public HealpixMoc(String s) throws Exception {
        this.add(s);
    }

    public HealpixMoc(InputStream in) throws Exception {
        this.read(in);
    }

    public HealpixMoc(InputStream in, int mode) throws Exception {
        this.read(in, mode);
    }

    public void setMinLimitOrder(int limitOrder) throws Exception {
        this.setMinOrder(limitOrder);
    }

    public void setMaxLimitOrder(int limitOrder) throws Exception {
        this.setMocOrder(limitOrder);
    }

    public int getMinLimitOrder() {
        return this.getMinOrder();
    }

    public int getMaxLimitOrder() {
        return this.getMocOrder();
    }

    public int getLimitOrder() {
        return this.getMocOrder();
    }

    public void setLimitOrder(int limitOrder) throws Exception {
        this.setMocOrder(limitOrder);
    }

    public int getSize() {
        return this.getNbCells();
    }

    public int getMaxOrder() {
        return this.getMocOrder();
    }

    public void setCheckConsistencyFlag(boolean flag) throws Exception {
        if (flag) {
            this.bufferOn();
        } else {
            this.bufferOff();
        }
    }

    public void checkAndFix() throws Exception {
    }

    public void check() throws Exception {
    }

    public void add(HealpixMoc moc) throws Exception {
        super.add(moc);
    }

    public void sort() {
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isInTree(int order, long npix) {
        return this.isIntersecting(order, npix);
    }

    public boolean isInTree(HealpixMoc moc) {
        return this.isIntersecting(moc);
    }

    public void toRangeSet() {
    }

    public void toHealpixMoc() throws Exception {
    }

    public boolean isAllSky() {
        return this.isFull();
    }

    public HealpixMoc union(HealpixMoc moc) throws Exception {
        return (HealpixMoc)super.union(moc);
    }

    public HealpixMoc intersection(HealpixMoc moc) throws Exception {
        return (HealpixMoc)super.intersection(moc);
    }

    public HealpixMoc subtraction(HealpixMoc moc) throws Exception {
        return (HealpixMoc)super.subtraction(moc);
    }

    @Override
    public HealpixMoc complement() throws Exception {
        return (HealpixMoc)super.complement();
    }

    public long getArea() {
        long nside = HealpixMoc.pow2(this.getMocOrder());
        return 12L * nside * nside;
    }

    public long getUsedArea() {
        return this.getNbValues();
    }
}

