/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.Range;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Moc1D
extends Moc {
    protected Range range;
    protected int mocOrder;
    private int biggestOrder;
    private int currentOrder;
    private long[] buf = null;
    private int bufSz = 0;

    protected Moc1D() {
        this(-1);
    }

    protected Moc1D(int mocOrder) {
        this.clear();
        this.mocOrder = mocOrder;
    }

    protected Moc1D(String s) throws Exception {
        this();
        this.add(s);
    }

    protected Moc1D(InputStream in) throws Exception {
        this();
        this.read(in);
    }

    protected Moc1D(Moc1D moc) throws Exception {
        this();
        moc.clone1(this);
    }

    @Override
    public String toDebug() {
        String so = "" + this.getMocOrder();
        if (this.mocOrder == -1) {
            so = "(" + so + ")";
        }
        char c = Character.toUpperCase(this.cDim());
        return String.valueOf(c) + "MOC mocOrder=" + so + " deepestOrder=" + this.getDeepestOrder() + " nbRanges=" + this.getNbRanges() + " nbCells=" + this.getNbCells() + " mem=" + Moc1D.getUnitDisk(this.getMem());
    }

    @Override
    public void clear() {
        super.clear();
        this.range = new Range();
        this.bufSz = 0;
        this.currentOrder = -1;
        this.biggestOrder = -1;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        super.clone1(moc);
        Moc1D m = (Moc1D)moc;
        this.flush();
        m.range = this.range == null ? null : new Range(this.range);
        m.mocOrder = this.mocOrder;
        m.currentOrder = this.currentOrder;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void reduction(long maxSize) throws Exception {
        if (maxSize > 0L) ** GOTO lbl4
        throw new Exception("negative or null size not allowed");
lbl-1000:
        // 1 sources

        {
            this.setMocOrder(this.getMocOrder() - 1);
lbl4:
            // 2 sources

            ** while (this.getMem() > maxSize && this.getMocOrder() > 0)
        }
lbl5:
        // 1 sources

    }

    public abstract int maxOrder();

    public abstract int shiftOrder();

    public abstract char cDim();

    public abstract long maxVal();

    @Override
    protected void computeHierarchy() {
        int deep = -1;
        int size = 0;
        if (this.range != null) {
            Iterator<MocCell> it = this.cellIterator(true);
            while (it.hasNext()) {
                MocCell cell = it.next();
                size = (int)((long)size + (cell.end - cell.start));
                if (cell.order <= deep) continue;
                deep = cell.order;
            }
        }
        this.cacheDeepestOrder = deep;
        this.cacheNbCells = size;
    }

    public long getNbValues() {
        this.flush();
        int shift = (this.maxOrder() - this.getMocOrder()) * this.shiftOrder();
        return this.range.nval() >>> shift;
    }

    @Override
    public void setRangeList(Range range) {
        this.range = range;
        this.resetCache();
    }

    @Override
    public boolean isEmpty() {
        this.flush();
        return this.range.sz == 0;
    }

    @Override
    public boolean isFull() {
        this.flush();
        return this.range.sz == 2 && this.range.r[0] == 0L && this.range.r[1] == this.maxVal();
    }

    @Override
    public double getCoverage() {
        this.flush();
        return (double)this.range.nval() / (double)this.maxVal();
    }

    @Override
    public int getNbRanges() {
        this.flush();
        return this.range.sz / 2;
    }

    @Override
    public long getMem() {
        this.flush();
        return this.range.getMem() + (this.buf == null ? 0L : (long)this.buf.length * 8L);
    }

    @Override
    protected Moc1D operation(Moc moc, int op) throws Exception {
        Moc1D m = (Moc1D)moc;
        m.flush();
        Moc1D res = (Moc1D)this.dup();
        this.flush();
        switch (op) {
            case 0: {
                res.range = this.range.union(m.range);
                break;
            }
            case 1: {
                res.range = this.range.intersection(m.range);
                break;
            }
            case 2: {
                res.range = this.range.difference(m.range);
            }
        }
        res.setMinOrder(Math.min(this.getMinOrder(), m.getMinOrder()));
        int newOrder = this.getMocOrder4op(this.getMocOrder(), m.getMocOrder());
        boolean force = newOrder < Math.min(this.getMocOrder(), m.getMocOrder());
        res.setMocOrder(newOrder, force);
        res.range.trimIfTooLarge();
        return res;
    }

    @Override
    public Moc1D complement() throws Exception {
        Moc1D res = (Moc1D)this.dup();
        this.flush();
        res.range = this.range.complement(0L, this.maxVal());
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Moc1D)) {
            return false;
        }
        Moc1D moc = (Moc1D)o;
        if (this.cDim() != moc.cDim()) {
            return false;
        }
        this.flush();
        moc.flush();
        return this.range.equals(moc.range);
    }

    public int hashCode() {
        if (this.cacheHashCode == -1) {
            this.flush();
            this.cacheHashCode = this.range.hashCode();
        }
        return this.cacheHashCode;
    }

    public boolean isIncluding(int order, long val) {
        long start = this.getStart(order, val);
        long end = this.getEnd(order, val);
        this.flush();
        return this.range.contains(start, end);
    }

    public boolean isIntersecting(int order, long val) {
        long start = this.getStart(order, val);
        long end = this.getEnd(order, val);
        this.flush();
        return this.range.overlaps(start, end);
    }

    public boolean isIncluding(Moc1D moc) {
        this.flush();
        return this.range.contains(moc.range);
    }

    public boolean isIntersecting(Moc1D moc) {
        this.flush();
        return this.range.overlaps(moc.range);
    }

    public void setMocOrder(int mocOrder) throws Exception {
        this.setMocOrder(mocOrder, false);
    }

    private void setMocOrder(int mocOrder, boolean force) throws Exception {
        if (mocOrder < -1 || mocOrder > this.maxOrder()) {
            throw new Exception("MocOrder error (" + mocOrder + " not in [0.." + this.maxOrder() + "])");
        }
        if (mocOrder != -1) {
            if (this.mocOrder == -1) {
                this.mocOrder = this.maxOrder();
            }
            if (force || mocOrder < this.mocOrder) {
                int diff = this.maxOrder() - mocOrder;
                this.flush();
                this.range = this.range.degrade(diff * this.shiftOrder());
                this.resetCache();
            }
        }
        this.mocOrder = mocOrder;
    }

    public int getMocOrder() {
        if (this.mocOrder == -1) {
            if (this.biggestOrder != -1) {
                return this.biggestOrder;
            }
            return this.getDeepestOrder();
        }
        return this.mocOrder;
    }

    public void setMinOrder(int minOrder) throws Exception {
    }

    public int getMinOrder() {
        return 0;
    }

    public void add(int order, long val) throws Exception {
        this.add(order, val, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int order, long firstVal, long lastVal) throws Exception {
        int shift;
        if (this.mocOrder != -1 && this.mocOrder < order) {
            shift = (order - this.mocOrder) * this.shiftOrder();
            firstVal = firstVal >>> shift << shift;
            lastVal = ((lastVal >>> shift) + 1L << shift) - 1L;
        }
        if (order > this.biggestOrder) {
            this.biggestOrder = order;
        }
        shift = (this.maxOrder() - order) * this.shiftOrder();
        long start = firstVal << shift;
        long end = lastVal + 1L << shift;
        if (this.buf != null) {
            if (this.bufSz > 2 && this.buf[this.bufSz - 2] == start && this.buf[this.bufSz - 1] == end) {
                return;
            }
            Moc1D moc1D = this;
            synchronized (moc1D) {
                this.buf[this.bufSz++] = start;
                this.buf[this.bufSz++] = end;
            }
            if (this.bufSz == this.buf.length) {
                this.flush();
            }
        } else {
            this.range.add(start, end);
        }
        this.resetCache();
    }

    public long getStart(int order, long val) {
        return val << (this.maxOrder() - order) * this.shiftOrder();
    }

    public long getEnd(int order, long val) {
        return this.getStart(order, val + 1L);
    }

    public void bufferOn() {
        this.bufferOn(200000);
    }

    public void bufferOn(int size) {
        this.flush();
        if (size % 1 == 1) {
            ++size;
        }
        this.buf = new long[size];
        this.bufSz = 0;
    }

    public void bufferOff() {
        if (this.buf != null) {
            this.flush();
            this.range.trimSize();
        }
        this.buf = null;
        this.bufSz = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.bufSz == 0) {
            return;
        }
        Moc1D moc1D = this;
        synchronized (moc1D) {
            this.add(this.buf, this.bufSz);
            this.bufSz = 0;
        }
    }

    public void add(long[] valList, int size) {
        if (size <= 0) {
            return;
        }
        Range r = new Range(valList, size);
        r.sortAndFix();
        this.range = this.range.union(r);
        this.resetCache();
    }

    public void add(Moc moc) throws Exception {
        this.flush();
        this.range = this.range.union(moc.seeRangeList());
        this.resetCache();
    }

    @Override
    public Range seeRangeList() {
        this.flush();
        return this.range;
    }

    @Override
    public Iterator<MocCell> cellIterator(boolean flagRange) {
        return new CellIterator(flagRange);
    }

    public Iterator<Long> valIterator() {
        long gap = 1L << (this.maxOrder() - this.getMocOrder()) * this.shiftOrder();
        return new ValIterator(gap);
    }

    @Override
    protected void addToken(String token) throws Exception {
        int j;
        if (token == null) {
            return;
        }
        int i = token.indexOf(47);
        if (i < 0) {
            i = token.indexOf(58);
        }
        if (i > 0) {
            String s1 = this.unQuote(token.substring(0, i));
            if (!Character.isDigit(s1.charAt(0))) {
                if (s1.charAt(0) != this.cDim()) {
                    throw new Exception("MOC syntax error. Unknown prefix order. Must be " + this.cDim() + "[" + s1.charAt(0) + "]");
                }
                s1 = s1.substring(1);
            }
            try {
                this.currentOrder = Integer.parseInt(s1);
            }
            catch (NumberFormatException e) {
                throw new Exception("MOC syntax error. Order must be an integer value");
            }
        }
        if ((j = token.indexOf(45, i + 1)) < 0) {
            long val;
            String s1 = this.unBracket(token.substring(i + 1));
            if (s1.trim().length() == 0) {
                if (this.mocOrder != -1 && this.mocOrder != this.currentOrder) {
                    throw new Exception("MocOrder already specified (" + this.mocOrder + ") => ignored [" + this.currentOrder + "]");
                }
                this.setMocOrder(this.currentOrder);
                return;
            }
            try {
                val = Long.parseLong(s1);
            }
            catch (NumberFormatException e) {
                throw new Exception("MOC syntax error. Value must be an integer long value [" + s1 + "]");
            }
            this.add(this.currentOrder, val);
        } else {
            long endVal;
            long starVal;
            try {
                starVal = Long.parseLong(token.substring(i + 1, j));
                endVal = Long.parseLong(token.substring(j + 1));
            }
            catch (NumberFormatException e) {
                throw new Exception("MOC syntax error. Range must be two integer long values separated by a dash [" + token.substring(i + 1) + "]");
            }
            if (starVal >= endVal) {
                throw new Exception("MOC syntax error. Range must be expressed by 2 increasing ordered long integers [" + token + "]");
            }
            this.add(this.currentOrder, starVal, endVal);
        }
    }

    protected void readSpecificDataUniq(InputStream in, int naxis1, int naxis2, int nbyte) throws Exception {
        byte[] buf = new byte[naxis1 * naxis2];
        Moc1D.readFully(in, buf);
        this.createMocByUniq(naxis1 * naxis2 / nbyte, nbyte, buf);
    }

    protected void createMocByUniq(int nval, int nbyte, byte[] t) throws Exception {
        this.bufferOn();
        int i = 0;
        long[] hpix = null;
        int k = 0;
        while (k < nval) {
            long val;
            int a = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
            if (nbyte == 4) {
                val = a;
            } else {
                int b = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
                val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
            }
            hpix = Moc1D.uniq2hpix(val, hpix);
            this.add((int)hpix[0], hpix[1]);
            ++k;
        }
        this.bufferOff();
    }

    protected void readSpecificDataRange(InputStream in, int naxis1, int naxis2, int nbyte) throws Exception {
        byte[] buf = new byte[naxis1 * naxis2];
        Moc1D.readFully(in, buf);
        this.createMocByRange(naxis1 * naxis2 / nbyte, buf);
    }

    protected void createMocByRange(int nval, byte[] t) throws Exception {
        int i = 0;
        int k = 0;
        while (k < nval) {
            long min = Moc1D.readLong(t, i);
            long max = Moc1D.readLong(t, i + 8);
            this.range.append(min, max);
            k += 2;
            i += 16;
        }
        this.resetCache();
    }

    @Override
    public void writeASCII(OutputStream out) throws Exception {
        this.flush();
        boolean flagNL = this.range.sz > 20;
        int order = Moc1D.writeASCII(out, this, flagNL, true);
        StringBuilder res = new StringBuilder(10);
        int mocOrder = this.getMocOrder();
        if (order < mocOrder) {
            if (flagNL) {
                res.append(CR);
            } else {
                res.append(' ');
            }
            res.append(String.valueOf(mocOrder) + "/");
        }
        if (flagNL) {
            res.append(CR);
        }
        Moc1D.writeASCIIFlush(out, res, false);
    }

    @Override
    public void writeJSON(OutputStream out) throws Exception {
        this.flush();
        boolean flagNL = this.range.sz > 20;
        flagNL = true;
        this.writeJSON(out, flagNL);
    }

    private int writeJSON(OutputStream out, boolean flagNL) throws Exception {
        int mocOrder;
        StringBuilder s = new StringBuilder(2048);
        int order = -1;
        boolean first = true;
        int j = 0;
        s.append("{");
        if (flagNL) {
            s.append(CR);
        }
        Iterator<MocCell> it = this.cellIterator(false);
        while (it.hasNext()) {
            boolean flagNewOrder;
            MocCell cell = it.next();
            boolean bl = flagNewOrder = cell.order != order;
            if (flagNewOrder) {
                if (!first) {
                    s.append("]," + (flagNL ? CR : ""));
                }
                first = false;
                s.append(String.valueOf(flagNL ? "  " : "") + "\"" + cell.order + "\":[");
                order = cell.order;
                j = 0;
            }
            s.append(String.valueOf(flagNewOrder ? "" : ",") + cell.start);
            if (++j != 15) continue;
            Moc1D.writeASCIIFlush(out, s, flagNL);
            j = 0;
        }
        if (!first) {
            s.append("]");
        }
        if (order < (mocOrder = this.getMocOrder())) {
            if (!first) {
                s.append(String.valueOf(',') + (flagNL ? CR : ""));
            }
            s.append(String.valueOf(flagNL ? "  " : "") + "\"" + mocOrder + "\":[]");
        }
        if (flagNL) {
            s.append(CR);
        }
        s.append("}");
        Moc1D.writeASCIIFlush(out, s, flagNL);
        return order;
    }

    private class CellIterator
    implements Iterator<MocCell> {
        Range r2;
        Range r3;
        long a;
        long b;
        int o;
        int i;
        int shift;
        long ofs;
        boolean flagEnd;
        boolean took;
        boolean flagRange;
        char cdim;

        CellIterator(boolean flagRange) {
            Moc1D.this.flush();
            this.flagRange = flagRange;
            this.r2 = new Range(Moc1D.this.seeRangeList());
            this.r3 = new Range();
            this.o = Moc1D.this.getMinOrder();
            this.i = -2;
            this.shift = Moc1D.this.shiftOrder() * (Moc1D.this.maxOrder() - this.o);
            this.ofs = (1L << this.shift) - 1L;
            this.flagEnd = false;
            this.took = true;
            this.cdim = Moc1D.this.cDim();
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return !this.flagEnd;
        }

        @Override
        public MocCell next() {
            if (!this.hasNext()) {
                return null;
            }
            this.took = true;
            MocCell cell = new MocCell();
            cell.dim = this.cdim;
            cell.order = this.o;
            cell.start = this.a;
            this.a = cell.end = this.flagRange ? this.b : this.a + 1L;
            return cell;
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.flagEnd || !this.took) {
                return;
            }
            if (this.i >= 0 && this.a < this.b) {
                return;
            }
            while (true) {
                this.i += 2;
                while (this.i < this.r2.sz) {
                    this.a = this.r2.r[this.i] + this.ofs >>> this.shift;
                    this.b = this.r2.r[this.i + 1] >>> this.shift;
                    if (this.a < this.b) {
                        this.r3.append(this.a << this.shift, this.b << this.shift);
                        this.took = false;
                        return;
                    }
                    this.i += 2;
                }
                if (!this.r3.isEmpty()) {
                    this.r2 = this.r2.difference(this.r3);
                }
                if (this.o == Moc1D.this.maxOrder() || this.r2.isEmpty()) break;
                ++this.o;
                this.shift = Moc1D.this.shiftOrder() * (Moc1D.this.maxOrder() - this.o);
                this.ofs = (1L << this.shift) - 1L;
                this.r3.clear();
                this.i = -2;
            }
            this.flagEnd = true;
        }
    }

    class ValIterator
    implements Iterator<Long> {
        int pos;
        long value;
        long gap;

        ValIterator(long gap) {
            Moc1D.this.flush();
            this.gap = gap;
            this.pos = 0;
            this.value = Moc1D.this.range.sz > 0 ? Moc1D.this.range.r[0] : 0L;
        }

        @Override
        public boolean hasNext() {
            return this.pos < Moc1D.this.range.sz;
        }

        @Override
        public Long next() {
            if (this.pos > Moc1D.this.range.sz) {
                throw new NoSuchElementException();
            }
            long ret = this.value;
            this.value += this.gap;
            if (this.value >= Moc1D.this.range.r[this.pos + 1]) {
                this.pos += 2;
                if (this.pos < Moc1D.this.range.sz) {
                    this.value = Moc1D.this.range.r[this.pos];
                }
            }
            return ret / this.gap;
        }
    }
}

