/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.MocCell;
import cds.moc.Range;
import cds.moc.Range2;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class Moc2D
extends Moc {
    public Range2 range;
    protected Moc1D protoDim1;
    protected Moc1D protoDim2;
    private StringBuilder buf = null;
    private Moc1D moc1 = null;
    private boolean inDim1 = false;

    protected Moc2D(Moc1D protoDim1, Moc1D protoDim2) {
        this.protoDim1 = protoDim1;
        this.protoDim2 = protoDim2;
        this.clear();
    }

    @Override
    public String toDebug() {
        String so1 = "" + this.getMocOrder1();
        if (this.protoDim1.mocOrder == -1) {
            so1 = "(" + so1 + ")";
        }
        char c1 = Character.toUpperCase(this.cDim1());
        String so2 = "" + this.getMocOrder2();
        if (this.protoDim2.mocOrder == -2) {
            so2 = "(" + so2 + ")";
        }
        char c2 = Character.toUpperCase(this.cDim2());
        return String.valueOf(c1) + c2 + "MOC mocOrder=" + so1 + "/" + so2 + " nbRanges=" + this.getNbRanges() + " nbCells=" + this.getNbCells() + " mem=" + Moc2D.getUnitDisk(this.getMem());
    }

    public int maxOrder1() {
        return this.protoDim1.maxOrder();
    }

    public int maxOrder2() {
        return this.protoDim2.maxOrder();
    }

    public int shiftOrder1() {
        return this.protoDim1.shiftOrder();
    }

    public int shiftOrder2() {
        return this.protoDim2.shiftOrder();
    }

    public char cDim1() {
        return this.protoDim1.cDim();
    }

    public char cDim2() {
        return this.protoDim2.cDim();
    }

    @Override
    public Range seeRangeList() {
        return this.range;
    }

    @Override
    public void setRangeList(Range range) {
        this.range = (Range2)range;
    }

    public int getMocOrder1() {
        return this.protoDim1.getMocOrder();
    }

    public int getMocOrder2() {
        return this.protoDim2.getMocOrder();
    }

    public void setMocOrder(int order1, int order2) throws Exception {
        if (order1 < -1 || order1 > this.protoDim1.maxOrder()) {
            throw new Exception("MocOrder error (" + order1 + " not in [0.." + this.protoDim1.maxOrder() + "])");
        }
        if (order2 < -1 || order2 > this.protoDim2.maxOrder()) {
            throw new Exception("MocOrder error (" + order2 + " not in [0.." + this.protoDim2.maxOrder() + "])");
        }
        if (order1 != -1 || order2 != -1) {
            if (order1 != -1 && this.protoDim1.mocOrder == -1) {
                this.protoDim1.mocOrder = this.protoDim1.maxOrder();
            }
            if (order2 != -1 && this.protoDim2.mocOrder == -1) {
                this.protoDim2.mocOrder = this.protoDim2.maxOrder();
            }
            if (order1 < this.protoDim1.mocOrder || order2 < this.protoDim2.mocOrder) {
                int shift1 = order1 == -1 ? 0 : this.protoDim1.maxOrder() - order1;
                int shift2 = order2 == -1 ? 0 : this.protoDim2.maxOrder() - order2;
                this.range = this.range.degrade(shift1 * this.protoDim1.shiftOrder(), shift2 * this.protoDim2.shiftOrder());
                this.resetCache();
            }
        }
        this.protoDim1.mocOrder = order1;
        this.protoDim2.mocOrder = order2;
    }

    public void setMocOrder1(int order1) throws Exception {
        this.setMocOrder(order1, this.protoDim2.mocOrder);
    }

    public void setMocOrder2(int order2) throws Exception {
        this.setMocOrder(this.protoDim1.mocOrder, order2);
    }

    public long getStart1(int order, long val) {
        return this.protoDim1.getStart(order, val);
    }

    public long getEnd1(int order, long val) {
        return this.protoDim1.getEnd(order, val);
    }

    public long getStart2(int order, long val) {
        return this.protoDim2.getStart(order, val);
    }

    public long getEnd2(int order, long val) {
        return this.protoDim2.getEnd(order, val);
    }

    public void add(long val1, long val2, Range r) {
        int mocOrder1 = this.protoDim1.mocOrder;
        if (mocOrder1 != -1) {
            int shift = (this.maxOrder1() - mocOrder1) * this.shiftOrder1();
            val1 = val1 >>> shift << shift;
            val2 = ((val2 >>> shift) + 1L << shift) - 1L;
        }
        this.range.add(val1, val2 + 1L, r);
        this.resetCache();
    }

    public void add(int order1, long val1, int order2, long val2) throws Exception {
        this.add(order1, val1, val1, order2, val2, val2);
    }

    public void add(int order1, long firstVal1, long lastVal1, int order2, long firstVal2, long lastVal2) throws Exception {
        int shift;
        int mocOrder1 = this.protoDim1.mocOrder;
        if (mocOrder1 != -1 && mocOrder1 < order1) {
            shift = (order1 - mocOrder1) * this.shiftOrder1();
            firstVal1 = firstVal1 >>> shift << shift;
            lastVal1 = ((lastVal1 >>> shift) + 1L << shift) - 1L;
        }
        shift = (this.maxOrder1() - order1) * this.shiftOrder1();
        long start1 = firstVal1 << shift;
        long end1 = lastVal1 + 1L << shift;
        int mocOrder2 = this.protoDim2.mocOrder;
        if (mocOrder2 != -1 && mocOrder2 < order2) {
            shift = (order2 - mocOrder2) * this.shiftOrder2();
            firstVal2 = firstVal2 >>> shift << shift;
            lastVal2 = ((lastVal2 >>> shift) + 1L << shift) - 1L;
        }
        shift = (this.maxOrder2() - order2) * this.shiftOrder2();
        long start2 = firstVal2 << shift;
        long end2 = lastVal2 + 1L << shift;
        Range r = new Range();
        r.append(start2, end2);
        this.range.add(start1, end1, r);
        this.resetCache();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Moc2D)) {
            return false;
        }
        Moc2D moc = (Moc2D)o;
        if (this.cDim1() != moc.cDim1()) {
            return false;
        }
        if (this.cDim2() != moc.cDim2()) {
            return false;
        }
        return this.range.equals(((Moc2D)o).range);
    }

    public int hashCode() {
        if (this.cacheHashCode == -1) {
            this.cacheHashCode = this.range.hashCode();
        }
        return this.cacheHashCode;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof Moc2D)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must derived from Moc2D");
        }
        super.clone1(moc);
        Moc2D m = (Moc2D)moc;
        m.protoDim1 = (Moc1D)this.protoDim1.clone();
        m.protoDim2 = (Moc1D)this.protoDim2.clone();
        m.range = this.range == null ? null : new Range2(this.range);
    }

    @Override
    public boolean isEmpty() {
        return this.range.sz == 0;
    }

    @Override
    public boolean isFull() {
        if (this.range.sz != 2 || this.range.r[0] != 0L || this.range.r[1] != this.protoDim1.maxVal()) {
            return false;
        }
        Moc1D m = (Moc1D)this.protoDim2.dup();
        m.setRangeList(this.range.rr[0]);
        return m.isFull();
    }

    @Override
    public double getCoverage() {
        return -1.0;
    }

    @Override
    protected void computeHierarchy() {
        int nb = 0;
        int deep = 0;
        for (MocCell mc : this) {
            nb += mc.moc.getNbCells();
            int d = mc.moc.getDeepestOrder();
            if (d <= deep) continue;
            deep = d;
        }
        this.cacheNbCells = nb;
        this.cacheDeepestOrder = deep;
    }

    @Override
    public int getNbRanges() {
        return this.range.sz / 2;
    }

    @Override
    public long getMem() {
        return this.range.getMem();
    }

    @Override
    public void clear() {
        super.clear();
        this.range = new Range2();
    }

    @Override
    public void reduction(long maxSize) throws Exception {
        this.reduction(maxSize, null);
    }

    public void reduction(long maxMB, String priority) throws Exception {
        if (maxMB <= 0L) {
            throw new Exception("negative or null size not allowed");
        }
        if (priority == null || priority.trim().length() == 0) {
            priority = String.valueOf(this.cDim2()) + this.cDim1();
        }
        while (this.getMem() > maxMB && (this.getMocOrder1() > 0 || this.getMocOrder2() > 0)) {
            char c = priority.charAt(0);
            if (c == this.cDim1() && this.getMocOrder1() > 0) {
                this.setMocOrder1(this.getMocOrder1() - 1);
            } else if (c == this.cDim2() && this.getMocOrder2() > 0) {
                this.setMocOrder2(this.getMocOrder2() - 1);
            } else {
                throw new Exception("Unknown MOC signature [" + c + "]");
            }
            priority = String.valueOf(priority.substring(1)) + c;
        }
    }

    @Override
    protected Moc2D operation(Moc moc, int op) throws Exception {
        Moc2D m = (Moc2D)moc;
        Moc2D res = (Moc2D)this.dup();
        res.setMocOrder1(this.getMocOrder4op(this.getMocOrder1(), m.getMocOrder1()));
        res.setMocOrder2(this.getMocOrder4op(this.getMocOrder2(), m.getMocOrder2()));
        switch (op) {
            case 0: {
                res.range = this.range.union(m.range);
                break;
            }
            case 1: {
                res.range = this.range.intersection(m.range);
                break;
            }
            case 2: {
                res.range = this.range.difference(m.range);
            }
        }
        res.range.trimSize();
        return res;
    }

    @Override
    public void writeASCII(OutputStream out) throws Exception {
        if (this.isEmpty()) {
            return;
        }
        int maxOrder2 = 0;
        int nbRanges = this.getNbRanges();
        boolean flagNL = nbRanges > 20;
        int order1 = this.getMocOrder1();
        int shift = (this.maxOrder1() - order1) * this.shiftOrder1();
        int j = 0;
        boolean lock = false;
        StringBuilder res = new StringBuilder(1000);
        int i = 0;
        while (i < nbRanges) {
            if (!lock) {
                j = i;
            }
            long deb = this.range.r[i * 2] >>> shift;
            long fin = this.range.r[i * 2 + 1] - 1L >>> shift;
            if (i > 0) {
                res.append(flagNL ? CR : " ");
            }
            if (!lock) {
                res.append(String.valueOf(this.cDim1()) + order1 + "/");
            }
            res.append(String.valueOf(deb) + (fin == deb ? "" : "-" + fin));
            if (i < nbRanges - 1 && this.range.rr[j].equals(this.range.rr[i + 1])) {
                lock = true;
            } else {
                lock = false;
                res.append(flagNL ? CR : " ");
                res.append(this.cDim2());
                Moc2D.writeASCIIFlush(out, res, false);
                Moc1D mocDim2 = (Moc1D)this.protoDim2.dup();
                mocDim2.setRangeList(this.range.rr[i]);
                int order = Moc2D.writeASCII(out, mocDim2, flagNL, true);
                if (order > maxOrder2) {
                    maxOrder2 = order;
                }
            }
            ++i;
        }
        if (maxOrder2 != this.getMocOrder2()) {
            res.append(flagNL ? CR : " ");
            res.append(String.valueOf(this.cDim1()) + order1 + "/ " + this.cDim2() + this.getMocOrder2() + "/");
            if (flagNL) {
                res.append(CR);
            }
        }
        Moc2D.writeASCIIFlush(out, res, false);
    }

    @Override
    public void writeJSON(OutputStream out) throws Exception {
        throw new Exception("Not yet implemented");
    }

    @Override
    public int sizeOfCoding() {
        return 8;
    }

    @Override
    public int getNbCoding() {
        int nb = 0;
        int i = 0;
        while (i < this.range.sz) {
            nb += 2;
            if (i <= 0 || !this.range.rr[i / 2].equals(this.range.rr[i / 2 - 1])) {
                nb += this.range.rr[i / 2].sz;
            }
            i += 2;
        }
        return nb;
    }

    @Override
    public Iterator<MocCell> cellIterator(boolean flagRange) {
        return new Dim2Iterator();
    }

    @Override
    protected void addToken(String token) throws Exception {
        if (token == null || token.charAt(0) == this.cDim1()) {
            if (token != null) {
                if (this.inDim1) {
                    throw new Exception("ASCII Moc syntax error");
                }
                boolean bl = this.inDim1 = !this.inDim1;
            }
            if (this.moc1 != null) {
                Moc1D moc2 = (Moc1D)this.protoDim2.dup();
                moc2.add(this.buf.toString());
                int order2 = moc2.getMocOrder();
                if (order2 > this.protoDim2.getMocOrder()) {
                    this.protoDim2.setMocOrder(order2);
                }
                int i = 0;
                while (i < this.moc1.range.sz) {
                    this.range.append(this.moc1.range.r[i], this.moc1.range.r[i + 1], moc2.range);
                    i += 2;
                }
                this.moc1 = null;
                this.buf = null;
            }
            if (token != null) {
                this.buf = new StringBuilder(token.substring(1));
            }
        } else if (token.charAt(0) == this.cDim2()) {
            if (!this.inDim1) {
                throw new Exception("ASCII Moc syntax error");
            }
            this.inDim1 = !this.inDim1;
            this.moc1 = (Moc1D)this.protoDim1.dup();
            this.moc1.add(this.buf.toString());
            int order1 = this.moc1.getMocOrder();
            if (order1 > this.protoDim1.getMocOrder()) {
                this.protoDim1.setMocOrder(order1);
            }
            this.buf = new StringBuilder(token.substring(1));
        } else {
            if (this.buf == null) {
                throw new Exception("Moc syntax error => token [" + token + "]");
            }
            this.buf.append(' ');
            this.buf.append(token);
        }
    }

    private class Dim2Iterator
    implements Iterator<MocCell> {
        int i = 0;
        int order;
        long shift;
        char cdim;

        Dim2Iterator() {
            this.order = Moc2D.this.getMocOrder1();
            this.shift = (Moc2D.this.maxOrder1() - this.order) * Moc2D.this.shiftOrder1();
            this.cdim = Moc2D.this.cDim1();
        }

        @Override
        public boolean hasNext() {
            return this.i < Moc2D.this.range.sz / 2;
        }

        @Override
        public MocCell next() {
            if (!this.hasNext()) {
                return null;
            }
            Moc1D moc = (Moc1D)Moc2D.this.protoDim2.dup();
            moc.setRangeList(Moc2D.this.range.rr[this.i]);
            MocCell cell = new MocCell();
            cell.dim = this.cdim;
            cell.order = this.order;
            cell.start = Moc2D.this.range.r[this.i * 2] >>> (int)this.shift;
            cell.end = Moc2D.this.range.r[this.i * 2 + 1] >>> (int)this.shift;
            cell.moc = moc;
            ++this.i;
            return cell;
        }

        @Override
        public void remove() {
        }
    }
}

