/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.HealpixImpl;
import cds.moc.Moc;
import cds.moc.Moc2D;
import cds.moc.Range;
import cds.moc.Range2;
import cds.moc.SMoc;
import cds.moc.TMoc;
import java.io.InputStream;
import java.io.OutputStream;

public class STMoc
extends Moc2D {
    private boolean PROTOSTMOC = false;
    public static long MASK_T = Long.MIN_VALUE;
    public static long UNMASK_T = MASK_T ^ 0xFFFFFFFFFFFFFFFFL;

    public STMoc() {
        super(new TMoc(), new SMoc());
    }

    public STMoc(int timeOrder, int spaceOrder) throws Exception {
        this();
        this.setMocOrder(timeOrder, spaceOrder);
    }

    public STMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public STMoc(InputStream in) throws Exception {
        this();
        this.read(in);
    }

    @Override
    public STMoc clone() throws CloneNotSupportedException {
        STMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof STMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be STMoc");
        }
        super.clone1(moc);
    }

    @Override
    public STMoc dup() {
        return new STMoc();
    }

    public void add(HealpixImpl healpix, double alpha, double delta, double jdtmin, double jdtmax) throws Exception {
        long smin = healpix.ang2pix(29, alpha, delta);
        long tmin = (long)(jdtmin * 8.64E10);
        long tmax = (long)(jdtmax * 8.64E10);
        this.add(tmin, tmax, smin, smin);
    }

    public void add(int order, long npix, double jdtmin, double jdtmax) throws Exception {
        long smin = this.getStart2(order, npix);
        long smax = this.getEnd2(order, npix) - 1L;
        long tmin = (long)(jdtmin * 8.64E10);
        long tmax = (long)(jdtmax * 8.64E10 + (double)TMoc.getDuration(this.getTimeOrder()));
        this.add(tmin, tmax, smin, smax);
    }

    public void add(long tmin, long tmax, long smin, long smax) throws Exception {
        this.add(61, tmin, tmax, 29, smin, smax);
    }

    public void add(double jdtmin, double jdtmax, SMoc smoc) throws Exception {
        long tmin = (long)(jdtmin * 8.64E10);
        long tmax = (long)(jdtmax * 8.64E10 + (double)TMoc.getDuration(this.getTimeOrder()));
        this.add(tmin, tmax, new Range(smoc.seeRangeList()));
    }

    @Override
    public void setTimeOrder(int timeOrder) throws Exception {
        this.setMocOrder1(timeOrder);
    }

    @Override
    public void setSpaceOrder(int spaceOrder) throws Exception {
        this.setMocOrder2(spaceOrder);
    }

    @Override
    public int getTimeOrder() {
        return this.getMocOrder1();
    }

    @Override
    public int getSpaceOrder() {
        return this.getMocOrder2();
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.range.begins(0) / 8.64E10;
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return (double)this.range.ends(this.range.nranges() - 1) / 8.64E10;
    }

    public int getTimeRanges() {
        return this.getNbRanges();
    }

    public TMoc getTimeMoc() throws Exception {
        TMoc moc = new TMoc(this.getTimeOrder());
        moc.setRangeList(new Range(this.range));
        return moc;
    }

    public TMoc getTimeMoc(SMoc spaceMoc) throws Exception {
        if (spaceMoc == null || spaceMoc.isEmpty()) {
            return this.getTimeMoc();
        }
        TMoc moc = new TMoc(this.getTimeOrder());
        Range r1 = new Range();
        int i = 0;
        while (i < this.range.sz) {
            Range m = this.range.rr[i >>> 1];
            if (spaceMoc.range.overlaps(m)) {
                r1.append(this.range.r[i], this.range.r[i + 1]);
            }
            i += 2;
        }
        moc.range = r1;
        return moc;
    }

    public SMoc getSpaceMoc() throws Exception {
        return this.getSpaceMoc(-1L, Long.MAX_VALUE);
    }

    public SMoc getSpaceMoc(long tmin, long tmax) throws Exception {
        if (tmin > tmax) {
            throw new Exception("bad time range");
        }
        int pos = this.range.indexOf(tmin);
        if ((pos & 1) == 1) {
            pos = pos < 0 ? ++pos : --pos;
        }
        SMoc moc = new SMoc(this.getSpaceOrder());
        moc.bufferOn(2000000);
        Object lastM = null;
        int i = pos;
        while (i < this.range.sz) {
            if (this.range.r[i] > tmax) break;
            Range m = this.range.rr[i >>> 1];
            if (m != lastM) {
                int j = 0;
                while (j < m.sz) {
                    moc.add(29, m.r[j], m.r[j + 1] - 1L);
                    j += 2;
                }
            }
            i += 2;
        }
        moc.bufferOff();
        return moc;
    }

    public boolean contains(long npix, double jd) {
        long npixTime = (long)(jd * 8.64E10);
        if (!this.range.contains(npixTime)) {
            return false;
        }
        Range[] rangeArray = this.range.rr;
        int n = this.range.rr.length;
        int n2 = 0;
        while (n2 < n) {
            Range r = rangeArray[n2];
            if (r.contains(npix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public STMoc union(Moc moc) throws Exception {
        if (!(moc instanceof STMoc)) {
            throw new Exception("Uncompatible Moc type for STMoc union");
        }
        return (STMoc)super.union(moc);
    }

    @Override
    public STMoc subtraction(Moc moc) throws Exception {
        if (!(moc instanceof STMoc)) {
            throw new Exception("Uncompatible Moc type for STMoc subtraction");
        }
        return (STMoc)super.subtraction(moc);
    }

    @Override
    public STMoc intersection(Moc moc) throws Exception {
        STMoc m;
        if (moc instanceof STMoc) {
            m = (STMoc)moc;
        } else if (moc instanceof TMoc) {
            m = new STMoc();
            Range2 r = new Range2(this.range.sz);
            if (!this.isEmpty()) {
                SMoc allsky = new SMoc("0/0-11");
                int i = 0;
                while (i < this.range.sz) {
                    r.append(this.range.r[i], this.range.r[i + 1], allsky.seeRangeList());
                    i += 2;
                }
            }
            m.setTimeOrder(Math.min(this.getTimeOrder(), ((TMoc)moc).getMocOrder()));
            m.setSpaceOrder(this.getSpaceOrder());
            m.setRangeList(r);
        } else {
            Range2 r = new Range2(2);
            if (!this.isEmpty()) {
                r.add(this.range.r[0], this.range.r[this.range.sz - 1], moc.seeRangeList());
            }
            m = new STMoc();
            m.setTimeOrder(this.getTimeOrder());
            m.setSpaceOrder(Math.min(this.getSpaceOrder(), ((SMoc)moc).getMocOrder()));
            m.setRangeList(r);
        }
        return (STMoc)super.intersection(m);
    }

    @Override
    public STMoc complement() throws Exception {
        STMoc moc = new STMoc(this.getTimeOrder(), this.getSpaceOrder());
        moc.add("t0/0 s0/0-11");
        return moc.subtraction(this);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(STMoc.getFitsLine("MOCDIM", "TIME.SPACE", "STMOC: Time dimension first, "));
        n += 80;
        out.write(STMoc.getFitsLine("ORDERING", "RANGE", "Range coding"));
        n += 80;
        out.write(STMoc.getFitsLine("MOCORD_T", "" + this.getTimeOrder(), "Time MOC resolution"));
        n += 80;
        out.write(STMoc.getFitsLine("MOCORD_S", "" + this.getSpaceOrder(), "Space MOC resolution"));
        n += 80;
        out.write(STMoc.getFitsLine("COORDSYS", "C", "Space reference frame (always C=ICRS)"));
        n += 80;
        out.write(STMoc.getFitsLine("TIMESYS", "TCB", "Time ref system (always TCB)"));
        return n += 80;
    }

    @Override
    protected int writeSpecificData(OutputStream out) throws Exception {
        byte[] buf = new byte[8];
        int size = 0;
        int i = 0;
        while (i < this.range.sz) {
            long tmin = this.range.r[i];
            long tmax = this.range.r[i + 1];
            if (tmin >= tmax) {
                throw new Exception("STMoc internal error. wrong time range at position " + i + " [" + tmin + ".." + tmax + "[");
            }
            size += STMoc.writeVal(out, this.codeTime(tmin), buf);
            size += STMoc.writeVal(out, this.codeTime(tmax), buf);
            if (i >= this.range.sz - 2 || !this.range.rr[i / 2].equals(this.range.rr[i / 2 + 1])) {
                Range m = this.range.rr[i / 2];
                int j = 0;
                while (j < m.sz) {
                    long smin = m.r[j];
                    long smax = m.r[j + 1];
                    if (smin >= smax) {
                        throw new Exception("STMoc internal error. wrong space range at position " + i + "/" + j + " [" + smin + ".." + smax + "[");
                    }
                    size += STMoc.writeVal(out, smin, buf);
                    size += STMoc.writeVal(out, smax, buf);
                    j += 2;
                }
            }
            i += 2;
        }
        return size;
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        int timeOrder = -1;
        int spaceOrder = -1;
        String type = header.getStringFromHeader("MOCDIM");
        if (type != null) {
            timeOrder = header.getIntFromHeader("MOCORD_T");
            spaceOrder = header.getIntFromHeader("MOCORD_S");
        } else {
            type = header.getStringFromHeader("MOC");
            if (type == null || type.equals("SPACETIME")) {
                timeOrder = header.getIntFromHeader("TORDER") * 2 + 3;
                spaceOrder = header.getIntFromHeader("MOCORDER");
            } else {
                timeOrder = header.getIntFromHeader("MOCORDER") * 2 + 3;
                spaceOrder = header.getIntFromHeader("MOCORD_1");
            }
            this.PROTOSTMOC = true;
        }
        this.setTimeOrder(timeOrder);
        this.setSpaceOrder(spaceOrder);
        byte[] buf = new byte[naxis1 * naxis2];
        STMoc.readFully(in, buf);
        this.createSTmocByFits(naxis1 * naxis2 / nbyte, buf);
    }

    private boolean isTime(long a) {
        if (this.PROTOSTMOC) {
            return a < 0L;
        }
        return (a & MASK_T) != 0L;
    }

    private long codeTime(long a) {
        return a | MASK_T;
    }

    private long decodeTime(long a) {
        if (this.PROTOSTMOC) {
            return -a;
        }
        return a & UNMASK_T;
    }

    private void createSTmocByFits(int nval, byte[] t) throws Exception {
        int i = 0;
        int startT = 0;
        Range m = new Range(500);
        int k = 0;
        while (k < nval) {
            long min = STMoc.readLong(t, i);
            long max = STMoc.readLong(t, i + 8);
            if (this.isTime(min)) {
                if (!m.isEmpty()) {
                    m.trimSize();
                    int j = startT;
                    while (j < this.range.sz) {
                        this.range.rr[j >>> 1] = m;
                        j += 2;
                    }
                    m = new Range(500);
                    startT = this.range.sz;
                }
                if ((min = this.decodeTime(min)) >= (max = this.decodeTime(max))) {
                    System.err.println("STMOC FITS time range error [" + min + ".." + max + "[ => k=" + k + "/" + nval);
                }
                this.range.push(min);
                this.range.push(max);
            } else {
                m.append(min, max);
            }
            k += 2;
            i += 16;
        }
        if (!m.isEmpty()) {
            m.trimSize();
            int j = startT;
            while (j < this.range.sz) {
                this.range.rr[j >>> 1] = m;
                j += 2;
            }
        }
    }
}

