/*
 * Decompiled with CFR 0.152.
 */
package cds.moc.misc;

import cds.moc.Moc;
import cds.moc.Range;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class MocLint {
    private static final int MAXERROR = 20;
    private static final int FITS = 0;
    private static final int ASCII = 1;
    private static final int MOC1 = 1;
    private static final int MOC2PROTO = 2;
    private static final int MOC2 = 3;
    private static final int UNKNOWN = -1;
    private static final int SPACE = 0;
    private static final int TIME = 1;
    private static final int TIMESPACE = 2;
    static final int INUNKNOWN = 0;
    static final int INTIME = 1;
    static final int INSPACE = 2;

    public static void main(String[] args) {
        try {
            if (args.length == 0 || args[0].equals("-h")) {
                System.out.println("Usage:       MocLint MocFileName\nDescription: Check compliance with MOC IVOA recommendations (1.0, 1.1 and 2.0).\nAuthor:      P.Fernique [CDS]\nVersion:     2.0 - Mai 2021 (first version 2016)");
                System.exit(2);
            }
            MocLint.check(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean check(String filename) throws Exception {
        try (FileInputStream in = null;){
            in = new FileInputStream(filename);
            boolean bl = MocLint.check(in);
            return bl;
        }
    }

    public static boolean check(InputStream in) {
        StringBuilder out = new StringBuilder();
        int rep = MocLint.check(out, in);
        System.out.print(out.toString());
        return rep != 0;
    }

    public static int check(StringBuilder out, InputStream in) {
        int rep = 0;
        try {
            BufferedInputStream bis = new BufferedInputStream(in, 32768);
            bis.mark(10);
            byte[] b = new byte[1];
            bis.read(b);
            bis.reset();
            int mode = b[0] == 83 ? 0 : 1;
            switch (mode) {
                case 0: {
                    rep = MocLint.checkFits(out, bis);
                    break;
                }
                case 1: {
                    rep = MocLint.checkAscii(out, bis);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rep;
    }

    private static int error(StringBuilder out, String s) {
        out.append("ERROR   " + s + "\n");
        return 1;
    }

    private static void info(StringBuilder out, String s) {
        out.append("INFO    " + s + "\n");
    }

    private static void status(StringBuilder out, String s) {
        out.append("STATUS  " + s + "\n");
    }

    private static int warning(StringBuilder out, String s) {
        out.append("WARNING " + s + "\n");
        return 1;
    }

    private static void tooMany(StringBuilder out) throws Exception {
        out.append("ERROR   Too many errors. Is it really a MOC ?\n");
        throw new Exception();
    }

    private static boolean checkDate(String s) {
        int mode = 0;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (mode) {
                case 0: {
                    if (ch == '-') {
                        mode = 1;
                        break;
                    }
                    if (Character.isDigit(ch)) break;
                    return false;
                }
                case 1: {
                    if (ch == '-') {
                        mode = 2;
                        break;
                    }
                    if (Character.isDigit(ch)) break;
                    return false;
                }
                case 2: {
                    if (ch == 'T') {
                        mode = 3;
                        break;
                    }
                    if (Character.isDigit(ch)) break;
                    return false;
                }
                case 3: {
                    if (ch == ':') {
                        mode = 4;
                        break;
                    }
                    if (Character.isDigit(ch)) break;
                    return false;
                }
                case 4: {
                    if (ch == ':') {
                        mode = 5;
                        break;
                    }
                    if (Character.isDigit(ch)) break;
                    return false;
                }
                case 5: {
                    if (Character.isDigit(ch)) break;
                    return false;
                }
            }
            ++i;
        }
        return mode == 2 || mode == 4 || mode == 5;
    }

    private static String getVal(byte[] buffer) {
        int offset;
        boolean quote = false;
        boolean blanc = true;
        int i = offset = 9;
        while (i < 80) {
            if (quote ? buffer[i] == 39 : buffer[i] == 47) break;
            if (blanc) {
                if (buffer[i] != 32) {
                    blanc = false;
                }
                if (buffer[i] == 39) {
                    quote = true;
                    offset = i + 1;
                }
            }
            ++i;
        }
        return new String(buffer, 0, offset, i - offset).trim();
    }

    private static boolean isQuoted(byte[] buffer) {
        int offset;
        boolean quote = false;
        boolean blanc = true;
        int i = offset = 9;
        while (i < 80) {
            if (!quote && buffer[i] == 47) break;
            if (blanc) {
                if (buffer[i] != 32) {
                    blanc = false;
                }
                if (buffer[i] == 39) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String getKey(byte[] buffer) {
        return new String(buffer, 0, 0, 8).trim();
    }

    private static long getInt(String s) {
        try {
            long v = Long.parseLong(s);
            return v;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static long decode(byte[] t, int nbyte) {
        long val = 0L;
        int a = t[0] << 24 | (t[1] & 0xFF) << 16 | (t[2] & 0xFF) << 8 | t[3] & 0xFF;
        if (nbyte == 4) {
            val = a;
        } else {
            int b = t[4] << 24 | (t[5] & 0xFF) << 16 | (t[6] & 0xFF) << 8 | t[7] & 0xFF;
            val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
        }
        return val;
    }

    public static int checkFits(StringBuilder out, InputStream in) {
        long naxis = -1L;
        long naxis1 = -1L;
        long naxis2 = -1L;
        long pcount = 0L;
        long gcount = 1L;
        long tfields = -1L;
        long mocorder = -1L;
        long mocord_s = -1L;
        long mocord_t = -1L;
        boolean mocord_sQuoted = false;
        boolean mocord_tQuoted = false;
        boolean mocorderQuoted = false;
        String tform1 = "";
        String pixtype = "";
        String ordering = "";
        String coordsys = "";
        String moctool = "";
        String date = "";
        String origin = "";
        String moctype = "";
        String mocid = "";
        String extname = "";
        String mocvers = "";
        String mocdim = "";
        String timesys = "";
        boolean mocversQuoted = false;
        int mocv = -1;
        int moct = -1;
        int w = 0;
        int e = 0;
        boolean moc1compatible = true;
        try {
            int skip;
            int n;
            byte[] buf = new byte[80];
            String extend = "";
            int line = 0;
            int size = 0;
            while ((n = in.read(buf)) != 0) {
                size += n;
                ++line;
                if (buf[0] == 69 && buf[1] == 78 && buf[2] == 68) break;
                String key = MocLint.getKey(buf);
                if (key.equals("COMMENT") || key.equals("HISTORY")) continue;
                String val = MocLint.getVal(buf);
                String s = new String(buf, 0, 0, n).trim();
                if ((char)buf[8] != '=') {
                    e += MocLint.error(out, "[4.3.1] HDU0 line " + line + ": missing \"=\" character [" + s + "]");
                }
                if (line == 1 && (!key.equals("SIMPLE") || key.equals("SIMPLE") && !val.equals("T"))) {
                    e += MocLint.error(out, "[4.3.1] HDU0 line " + line + ": SIMPLE=T missing [" + s + "]");
                }
                if (key.equals("EXTEND")) {
                    extend = val;
                }
                if (e <= 20) continue;
                MocLint.tooMany(out);
            }
            if (!extend.equals("T")) {
                w += MocLint.warning(out, "[4.3.1] HDU0: EXTEND=T required");
            }
            if ((skip = 2880 - size % 2880) != 2880) {
                size = (int)((long)size + in.skip(skip));
            }
            line = 0;
            while ((n = in.read(buf)) != 0) {
                size += n;
                ++line;
                if (buf[0] == 69 && buf[1] == 78 && buf[2] == 68) break;
                String key = MocLint.getKey(buf);
                if (key.equals("COMMENT") || key.equals("HISTORY")) continue;
                String val = MocLint.getVal(buf);
                String s = new String(buf, 0, 0, n).trim();
                if ((char)buf[8] != '=') {
                    e += MocLint.error(out, "[4.3.1] HDU1 line " + line + ": missing \"=\" character [" + s + "]");
                }
                if (line == 1 && (!key.equals("XTENSION") || key.equals("XTENSION") && !val.equals("BINTABLE"))) {
                    e += MocLint.error(out, "[4.3.1] HDU1 line " + line + ": XTENSION=BINTABLE missing");
                } else if (key.equals("NAXIS")) {
                    naxis = MocLint.getInt(val);
                } else if (key.equals("NAXIS1")) {
                    naxis1 = MocLint.getInt(val);
                } else if (key.equals("NAXIS2")) {
                    naxis2 = MocLint.getInt(val);
                } else if (key.equals("PCOUNT")) {
                    pcount = MocLint.getInt(val);
                } else if (key.equals("GCOUNT")) {
                    gcount = MocLint.getInt(val);
                } else if (key.equals("TFIELDS")) {
                    tfields = MocLint.getInt(val);
                } else if (key.equals("TFORM1")) {
                    tform1 = val;
                } else if (key.equals("MOCVERS")) {
                    mocvers = val;
                    mocversQuoted = MocLint.isQuoted(buf);
                } else if (key.equals("MOCDIM")) {
                    mocdim = val;
                } else if (key.equals("ORDERING")) {
                    ordering = val;
                } else if (key.equals("COORDSYS")) {
                    coordsys = val;
                } else if (key.equals("TIMESYS")) {
                    timesys = val;
                } else if (key.equals("MOCTOOL")) {
                    moctool = val;
                } else if (key.equals("MOCTYPE")) {
                    moctype = val;
                } else if (key.equals("MOCORD_S")) {
                    mocord_s = MocLint.getInt(val);
                    mocord_sQuoted = MocLint.isQuoted(buf);
                } else if (key.equals("MOCORD_T")) {
                    mocord_t = MocLint.getInt(val);
                    mocord_tQuoted = MocLint.isQuoted(buf);
                } else if (key.equals("MOCORDER")) {
                    mocorder = MocLint.getInt(val);
                    mocorderQuoted = MocLint.isQuoted(buf);
                } else if (key.equals("PIXTYPE")) {
                    pixtype = val;
                } else if (key.equals("DATE")) {
                    date = val;
                } else if (key.equals("ORIGIN")) {
                    origin = val;
                } else if (key.equals("EXTNAME")) {
                    extname = val;
                } else if (key.equals("MOCID")) {
                    mocid = val;
                }
                if (e <= 20) continue;
                MocLint.tooMany(out);
            }
            MocLint.info(out, "Fits MOC serialization");
            if (moctool.length() > 0) {
                MocLint.info(out, "Generated by: " + moctool);
            }
            if (date.length() > 0) {
                MocLint.info(out, "Date: " + date);
            }
            if (origin.length() > 0) {
                MocLint.info(out, "Origin: " + origin);
            }
            if (mocid.length() > 0) {
                MocLint.info(out, "Moc id: " + mocid);
            }
            if (extname.length() > 0) {
                MocLint.info(out, "Extname: " + extname);
            }
            if (moctype.length() > 0) {
                MocLint.info(out, "Moc type: " + moctype);
            }
            if (naxis2 != -1L) {
                MocLint.info(out, "Number of rows: " + naxis2);
            }
            if (tform1.length() > 0) {
                MocLint.info(out, "Coding: " + (tform1.endsWith("J") ? "32 bits integer" : (tform1.endsWith("K") ? "64 bits long" : tform1)));
            }
            if (gcount != 1L) {
                w += MocLint.warning(out, "[4.3.1]: only GCOUNT=1 authorized in HDU1");
            }
            if (pcount != 0L) {
                w += MocLint.warning(out, "[4.3.1]: only PCOUNT=0 authorized in HDU1");
            }
            if (tfields != 1L) {
                e += MocLint.error(out, "[4.3.1]: TFIELDS=1 required in HDU1");
            }
            if (tform1.length() > 1 && tform1.charAt(0) != '1') {
                e += MocLint.error(out, "[4.3.1]: TFORM1=1J or 1K required in HDU1");
            }
            if (tform1.length() > 1) {
                tform1 = tform1.substring(1);
            }
            if (!tform1.equals("J") && !tform1.equals("K")) {
                e += MocLint.error(out, "[4.3.1]: TFORM1=1J or 1K required in HDU1");
            }
            if (naxis != 2L) {
                e += MocLint.error(out, "[4.3.1]: only NAXIS=2 authorized in HDU1");
            }
            if (tform1.equals("J") && naxis1 != 4L) {
                e += MocLint.error(out, "[4.3.1]: only NAXIS1=4 compatible with TFORM1=J in HDU1");
            }
            if (tform1.equals("K") && naxis1 != 8L) {
                e += MocLint.error(out, "[4.3.1]: only NAXIS1=8 compatible with TFORM1=K in HDU1");
            }
            if (naxis2 < 0L) {
                e += MocLint.error(out, "[4.3.1]: NAXIS2 error in HDU1");
            }
            if (date.length() > 0 && !MocLint.checkDate(date)) {
                w += MocLint.warning(out, "[4.3.1]: DATE syntax error: no FITS convention [" + date + "]");
            }
            int n2 = mocv = mocvers.length() == 0 ? 1 : 3;
            if (mocv == 1) {
                moct = 0;
                MocLint.info(out, "Moc version: <2.0");
                if (mocorder != -1L) {
                    MocLint.info(out, "Moc order: " + mocorder);
                }
                if (ordering.equals("RANGE29")) {
                    w += MocLint.warning(out, "[0]: ORDERING=RANGE29 is a prototype of STMOC => not standard");
                    moct = 2;
                    mocv = 2;
                } else {
                    if (!pixtype.equals("HEALPIX")) {
                        w += MocLint.warning(out, "[6.l]: PIXTYPE=HEALPIX mandatory in HDU1");
                    }
                    if (mocorder == -1L) {
                        w += MocLint.warning(out, "[6.k]: MOCORDER is mandatory in HDU1");
                    } else if (mocorder < 0L || mocorder > 29L) {
                        e += MocLint.error(out, "[3.1]: MOCORDER=n where n in [0..29] required in HDU1");
                    }
                    if (mocorderQuoted) {
                        w += MocLint.warning(out, "[4.3.1]: only numerical value authorized for MOCORDER");
                    }
                    if (coordsys.length() == 0) {
                        w += MocLint.warning(out, "[6.d]: COORDSYS=C mandatory in HDU1 for celestial coverage");
                    }
                    if (!ordering.equals("NUNIQ")) {
                        w += MocLint.warning(out, "[6.c]: ORDERING=NUNIQ mandatory in HDU1");
                    }
                    if (tform1.equals("J") && mocorder > 13L) {
                        MocLint.info(out, "(!) mocOrder>13 may require 64 rather than 32 bits integer coding (TFORM1=1K) - check it!");
                    }
                    if (coordsys.length() > 0 && !coordsys.equals("C")) {
                        w += MocLint.warning(out, "[6.d]: wrong COORDSYS [" + coordsys + "]. MOC must use ICRS (C) only");
                    }
                }
            } else {
                MocLint.info(out, "Moc version: " + mocvers);
                MocLint.info(out, "Moc dimension: " + mocdim);
                if (mocord_s != -1L) {
                    MocLint.info(out, "Space order: " + mocord_s);
                }
                if (mocord_t != -1L) {
                    MocLint.info(out, "Time order: " + mocord_t);
                }
                if (!tform1.equals("K") || naxis1 != 8L) {
                    e += MocLint.error(out, "[4.3.1]: NAXIS1=8 / TFORM1=K required in HDU1");
                }
                if (!mocvers.equals("2.0")) {
                    w += MocLint.warning(out, "[6]: MOCVERS [" + mocvers + "] not supported for this MOC lint tool (should be 2.0, or not specified)");
                }
                if (!mocversQuoted) {
                    w += MocLint.warning(out, "[4.3.1]: only string value (quoted) authorized for MOCVERS");
                }
                if (mocdim.length() == 0) {
                    e += MocLint.error(out, "[6.k]: MOCDIM is mandatory in HDU1");
                }
                int n3 = mocdim.equals("SPACE") ? 0 : (mocdim.equals("TIME") ? 1 : (moct = mocdim.equals("TIME.SPACE") ? 2 : -1));
                if (moct == -1) {
                    e += MocLint.error(out, "[6.b]: unvalid MOCDIM value [" + mocdim + "]. Must be SPACE, TIME or TIME.SPACE");
                }
                if (moct == 0) {
                    if (mocorder == -1L) {
                        MocLint.info(out, "[6.k]: MOCORDER is suggested (=MOCORD_S) in HDU1 for backward compatibility (required in MOC1.0 & MOC1.1)");
                        moc1compatible = false;
                    }
                    if (mocorderQuoted) {
                        w += MocLint.warning(out, "[4.3.1]: only numerical value authorized for MOCORDER");
                    }
                    if (!ordering.equals("NUNIQ")) {
                        w += MocLint.warning(out, "[6.c]: ORDERING=NUNIQ mandatory in HDU1");
                    }
                    if (tform1.equals("J") && mocorder > 13L) {
                        MocLint.info(out, "(!) mocOrder>13 may require 64 rather than 32 bits integer coding (TFORM1=1K) - check it!");
                    }
                }
                if (moct == 0 || moct == 2) {
                    if (mocord_s == -1L) {
                        e += MocLint.error(out, "[6.i]: MOCORD_S is mandatory in HDU1");
                    } else if (mocord_s < 0L || mocord_s > 29L) {
                        e += MocLint.error(out, "[3.1]: MOCORD_S=n where n in [0..29] required in HDU1");
                    }
                    if (mocord_sQuoted) {
                        w += MocLint.warning(out, "[4.3.1]: only numerical value authorized for MOCORD_S");
                    }
                    if (coordsys.length() > 0 && !coordsys.equals("C")) {
                        e += MocLint.error(out, "[6.d]: wrong COORDSYS [" + coordsys + "]. MOC must use ICRS (C) only");
                    }
                }
                if (moct == 1 || moct == 2) {
                    if (mocord_t == -1L) {
                        e += MocLint.error(out, "[6.j]: MOCORD_T is mandatory in HDU1");
                    } else if (mocord_t < 0L || mocord_t > 61L) {
                        e += MocLint.error(out, "[3.2]: MOCORD_T=n where n in [0..61] required in HDU1");
                    }
                    if (mocord_tQuoted) {
                        w += MocLint.warning(out, "[4.3.1]: only numerical value authorized for MOCORD_T");
                    }
                    if (timesys.length() > 0 && !timesys.equals("TCB")) {
                        e += MocLint.error(out, "[6.e]: wrong TIMEDSYS [" + timesys + "]. MOC must use TCB only");
                    }
                    if (moct == 1 && !ordering.equals("RANGE") && !ordering.equals("NUNIQ")) {
                        e += MocLint.error(out, "[4.3.1]: ORDERING=RANGE|NUNIQ mandatory in HDU1");
                    } else if (moct == 2 && !ordering.equals("RANGE")) {
                        e += MocLint.error(out, "[5.2]: ORDERING=RANGE mandatory in HDU1");
                    }
                }
            }
            skip = 2880 - size % 2880;
            if (skip != 2880) {
                size = (int)((long)size + in.skip(skip));
            }
            if (ordering.equals("NUNIQ")) {
                int lmt = 29;
                if (mocv == 3) {
                    long l = mocorder = moct == 0 ? mocord_s : mocord_t;
                    if (moct == 1) {
                        lmt = 61;
                    }
                }
                int prev_order = -1;
                long prev_val = -1L;
                boolean sorted = true;
                long[] hpix = null;
                int nbyte = tform1.equals("J") ? 4 : 8;
                byte[] t = new byte[nbyte];
                long i = 0L;
                while (i < naxis2) {
                    int m1;
                    n = 0;
                    while ((m1 = in.read(t, n, t.length - n)) != 0) {
                        if ((n += m1) == t.length) break;
                    }
                    size += n;
                    if (n != t.length) {
                        e += MocLint.error(out, "[4.3.1]: truncated FITS table after row " + i);
                    }
                    long rawval = MocLint.decode(t, nbyte);
                    hpix = Moc.uniq2hpix(rawval, hpix);
                    int order = (int)hpix[0];
                    long val = hpix[1];
                    if (order < 0 || order > lmt) {
                        e += MocLint.error(out, "[3.1]: order error in row " + i + " [" + order + "]");
                    }
                    if (mocorder >= 0L && (long)order > mocorder) {
                        w += MocLint.warning(out, "[3.1]: order greater than mocorder in row " + i + " [" + order + "]");
                    }
                    long maxval = Moc.pow2(order);
                    if (moct == 0) {
                        maxval *= maxval;
                        maxval *= 12L;
                    }
                    if (val < 0L) {
                        e += MocLint.error(out, "[3.1]: negative val error in row " + i + " [" + val + "]");
                    }
                    if (val >= maxval) {
                        e += MocLint.error(out, "[3.1]: too high val for the current order in row " + i + " [" + val + "]");
                    }
                    if (sorted) {
                        if (order < prev_order) {
                            w += MocLint.warning(out, "[4.3.1]: not ascending orders (row " + i + ")");
                            sorted = false;
                        }
                        if (order != prev_order) {
                            prev_val = -1L;
                            prev_order = order;
                        }
                        if (val <= prev_val) {
                            w += MocLint.warning(out, "[4.3.1]: not ascending npixs (row " + i + ")");
                            sorted = false;
                        }
                        prev_val = val;
                    }
                    if (e > 20) {
                        MocLint.tooMany(out);
                    }
                    ++i;
                }
            } else {
                long prev_valt = -1L;
                long prev_vals = -1L;
                long lastval = -1L;
                boolean sorted = true;
                boolean smocAggreg = true;
                boolean timeAggreg = true;
                boolean spaceAggreg = true;
                int nbyte = 8;
                byte[] t = new byte[nbyte];
                long maxt = Moc.pow2(62L) - 1L;
                long maxs = 12L * Moc.pow2(29L) * Moc.pow2(29L);
                Range prev_sr = null;
                Range sr = new Range();
                long MASK_T = Long.MIN_VALUE;
                long UNMASK_T = MASK_T ^ 0xFFFFFFFFFFFFFFFFL;
                int mode = 0;
                int omode = -1;
                if (naxis % 2L != 0L) {
                    e += MocLint.error(out, "[4.3.2]: Odd number of values. RANGE coding required a list of ranges");
                }
                long i = 0L;
                while (i < naxis2) {
                    int m1;
                    n = 0;
                    while ((m1 = in.read(t, n, t.length - n)) != 0) {
                        if ((n += m1) == t.length) break;
                    }
                    size += n;
                    if (n != t.length) {
                        e += MocLint.error(out, "[4.3.1]: truncated FITS table after row " + i);
                    }
                    long val = lastval = MocLint.decode(t, nbyte);
                    if (moct == 1) {
                        mode = (int)(i % 2L);
                    } else {
                        mode = (int)(i % 2L);
                        if (mocv == 2) {
                            if (val >= 0L) {
                                mode += 2;
                            }
                        } else if ((val & MASK_T) == 0L) {
                            mode += 2;
                        }
                    }
                    if (moct == 1) {
                        if (val < 0L) {
                            e += MocLint.error(out, "[3.2]: val negative error in row " + i + " [" + val + "]");
                        }
                        if (val >= maxt) {
                            e += MocLint.error(out, "[3.2]: val too high in row " + i + " [" + val + "]");
                        }
                        if (sorted) {
                            if (mode == 0 && val <= prev_valt || mode == 1 && val < prev_valt) {
                                w += MocLint.warning(out, "[4.3.1]: not ascending ranges (row " + i + ")");
                                sorted = false;
                            }
                            prev_valt = val;
                        }
                    } else {
                        if (i < 2L || mode < 2) {
                            if (val >= 0L) {
                                e += MocLint.error(out, "[5.2]: val error in row " + i + " [" + val + "]. Time range must be coded as negative value");
                            }
                            val = mocv == 2 ? -val : (val &= UNMASK_T);
                            if (mode == 0 && val >= maxt) {
                                e += MocLint.error(out, "[3.2]: time val too high in row " + i + " [" + val + ">=2^62-1]");
                            }
                            if (mode == 1 && val > maxt) {
                                e += MocLint.error(out, "[3.2]: time val too high in row " + i + " [" + val + ">2^62-1]");
                            }
                        } else {
                            if (val < 0L) {
                                e += MocLint.error(out, "[5.2]: val error in row " + i + " [" + val + "]. Space range must be coded as positive value");
                            }
                            if (mode == 2 && val >= maxs) {
                                e += MocLint.error(out, "[3.2]: space val too high in row " + i + " [" + val + ">=12x2^29x2^29]");
                            }
                            if (mode == 3 && val > maxs) {
                                e += MocLint.error(out, "[3.2]: space val too high in row " + i + " [" + val + ">12x2^29x2^29]");
                            }
                            if (smocAggreg) {
                                sr.push(val);
                            }
                        }
                        if (timeAggreg && mode == 0 && omode == 1 && val == prev_valt) {
                            w += MocLint.warning(out, "[4.3.1]: not agregating consecutive time ranges (first found at row " + i + ")");
                            timeAggreg = false;
                        }
                        if (spaceAggreg && mode == 3 && omode == 2 && val == prev_vals) {
                            w += MocLint.warning(out, "[4.3.1]: not agregating consecutive space ranges (first found at row " + i + ")");
                            spaceAggreg = false;
                        }
                        if (mode < 2) {
                            if (sorted && val < prev_valt) {
                                w += MocLint.warning(out, "[4.3.1]: not ascending time ranges (row " + i + ")");
                                sorted = false;
                            }
                            prev_valt = val;
                            prev_vals = -1L;
                        } else {
                            if (sorted && (mode == 2 && val <= prev_vals || mode == 3 && val < prev_vals)) {
                                w += MocLint.warning(out, "[4.3.1]: not ascending space ranges (row " + i + ")");
                                sorted = false;
                            }
                            prev_vals = val;
                        }
                        if (smocAggreg && mode == 0 && omode == 3) {
                            if (prev_sr != null && prev_sr.equals(sr)) {
                                w += MocLint.warning(out, "[5.2]: there are identical space coverages for consecutive time ranges (first found at row " + (i - 1L) + ")");
                                smocAggreg = false;
                            }
                            prev_sr = sr;
                            sr = new Range();
                        }
                        omode = mode;
                    }
                    if (e > 20) {
                        MocLint.tooMany(out);
                    }
                    ++i;
                }
                if (moct == 2 && lastval < 0L) {
                    e += MocLint.error(out, "[3.2]: last space coverage is missing => Wrong interleave time/space ranges");
                }
            }
            skip = 2880 - size % 2880;
            if (skip != 2880) {
                n = (int)in.skip(skip);
                size += n;
                if (n < skip) {
                    w += MocLint.warning(out, "[4.3.1]: FITS not aligned on 2880 byte blocks");
                }
            }
            MocLint.info(out, "FITS size: " + size + " bytes");
        }
        catch (Exception e1) {
            e += MocLint.error(out, "Unrecovered exception !");
        }
        if (w == 0 && e == 0) {
            MocLint.status(out, "OK! MOC compliant with IVOA MOC " + (mocv == 1 ? "1.1" : "2.0") + " recommendation");
            return 1;
        }
        if (e == 0) {
            if (mocv == 3 && !moc1compatible) {
                MocLint.status(out, "OK! MOC compliant with IVOA MOC 2.0 recommendation, but not compatible with IVOA MOC 1.0 and 1.1");
                return 1;
            }
            if (mocv == 2) {
                MocLint.status(out, "WARNING! MOC proto 2 ok but not compliant with IVOA final recommendation");
                return -1;
            }
            MocLint.status(out, "WARNING! MOC ok but not fully compliant with IVOA MOC " + (mocv == 1 ? "1.1" : "2.0") + " recommendation");
            return -1;
        }
        MocLint.status(out, "ERROR! MOC error, not usable");
        return 0;
    }

    private static boolean in(String s, String lst) {
        if (s.length() != 1) {
            return false;
        }
        int i = lst.indexOf(s.charAt(0));
        return i >= 0;
    }

    private static String unQuote(String s) {
        int n = s.length();
        if (n > 2 && s.charAt(0) == '\"' && s.charAt(n - 1) == '\"') {
            return s.substring(1, n - 1);
        }
        return s;
    }

    private static String unBracket(String s) {
        int n = s.length();
        if (n < 1) {
            return s;
        }
        int o1 = s.charAt(0) == '[' ? 1 : 0;
        int o2 = s.charAt(n - 1) == ']' ? n - 1 : n;
        return s.substring(o1, o2);
    }

    public static int checkAscii(StringBuilder out, InputStream in) {
        int w = 0;
        int e = 0;
        int nbval = 0;
        boolean sepAsciiOk = true;
        boolean json = false;
        int mocv = 3;
        int line = 0;
        long order = -1L;
        long val1 = -1L;
        long val2 = -2L;
        int mode = 0;
        long maxval = -1L;
        int moct = -1;
        long mocOrdS = -1L;
        long mocOrdT = -1L;
        long mocOrd = -1L;
        long lastVal = -1L;
        long lastValT = -1L;
        long lastValS = -1L;
        long lastOrder = -1L;
        long lastOrderS = -1L;
        long lastOrderT = -1L;
        String tok = "";
        MocLint.info(out, "ASCII MOC serialization");
        try {
            String s;
            BufferedReader dis = new BufferedReader(new InputStreamReader(in));
            while ((s = dis.readLine()) != null) {
                ++line;
                if (s.length() == 0 || s.charAt(0) == '#') continue;
                StringTokenizer st = new StringTokenizer(s, " ;,\t{}", true);
                while (st.hasMoreTokens()) {
                    tok = st.nextToken();
                    String s1 = tok;
                    if (s1.length() == 0) continue;
                    if (json) {
                        int doublepoint = s1.indexOf(58);
                        s1 = doublepoint > 0 ? String.valueOf(MocLint.unQuote(s1.substring(0, doublepoint))) + "/" + MocLint.unBracket(s1.substring(doublepoint + 1)) : MocLint.unBracket(s1);
                    } else if (MocLint.in(s1, "{}")) {
                        w += MocLint.warning(out, "[4.3.2]: seems to be a JSON serialization => Checking MOC structure only, not JSON syntax...");
                        json = true;
                        continue;
                    }
                    if (!json && MocLint.in(s1, ";,\t")) {
                        if (!sepAsciiOk) continue;
                        w += MocLint.warning(out, "[4.3.2]: there are no standard separator (first found [" + s1 + "] line " + line + ")");
                        sepAsciiOk = false;
                        continue;
                    }
                    if (MocLint.in(s1, " {},")) continue;
                    int start = 0;
                    int slashPos = s1.indexOf(47);
                    if (slashPos == 0) {
                        e += MocLint.error(out, "[4.3.2]: error before '/'(line " + line + "). Separator between order and '/' is not allowed");
                    }
                    s1.length();
                    if (slashPos > 0) {
                        char cdim = s1.charAt(0);
                        if (cdim == 't') {
                            if (moct == 0) {
                                e += MocLint.error(out, "[4.3.2]: Bad structure. Time ranges must preceed space ranges in STMOC (line " + line + ")");
                            }
                            if (moct == -1) {
                                moct = 1;
                            }
                            if (mode == 1) {
                                w += MocLint.warning(out, "[4.3.2]: consecutive 't' order prefix (line " + line + "). Not required");
                            }
                            mode = 1;
                            start = 1;
                        } else if (cdim == 's') {
                            if (mode == 1) {
                                moct = 2;
                            } else if (moct == -1) {
                                moct = 0;
                            }
                            if (mode == 2) {
                                w += MocLint.warning(out, "[4.3.2]: consecutive 's' order prefix (line " + line + "). Not required");
                            }
                            mode = 2;
                            start = 1;
                        } else if (!Character.isDigit(cdim)) {
                            e += MocLint.error(out, "[4.3.2]: Order prefix error (line " + line + "). Must be 's' or 't'. ");
                        }
                        order = MocLint.getInt(s1.substring(start, slashPos));
                        if (order < 0L) {
                            e += MocLint.error(out, "[3.1]: order error (token [" + tok + "] line:" + line + "). Must be a positive integer");
                        }
                        if (mode == 2) {
                            if (lastOrderS != -1L && lastValS == -1L) {
                                w += MocLint.warning(out, "[4.3.2]: previous space order has no value (token [" + tok + "] line:" + line + ").");
                            }
                            if (order > 29L) {
                                e += MocLint.error(out, "[3.2]: space order error (token [" + tok + "] line:" + line + "). Must be in [0..29]");
                            }
                            if (order == lastOrderS) {
                                w += MocLint.warning(out, "[4.3.2]: redundant consecutive space order (token [" + tok + "] line:" + line + ").");
                            }
                            if (order < lastOrderS) {
                                w += MocLint.warning(out, "[4.3.2]: space order values should be ascending (token [" + tok + "] line:" + line + ").");
                            }
                            if (order > mocOrdS) {
                                mocOrdS = order;
                            }
                            lastOrderS = order;
                            lastValS = -1L;
                        }
                        if (mode == 1) {
                            if (lastOrderT != -1L && lastValT == -1L) {
                                w += MocLint.warning(out, "[4.3.2]: previous time order has no value (token [" + tok + "] line:" + line + ").");
                            }
                            if (order > 61L) {
                                e += MocLint.error(out, "[3.3]: time order error (token [" + tok + "] line:" + line + "). Must be in [0..61]");
                            }
                            if (order < lastOrderT) {
                                w += MocLint.warning(out, "[4.3.2]: time order values should be ascending (token [" + tok + "] line:" + line + ").");
                            }
                            if (order > mocOrdT) {
                                mocOrdT = order;
                            }
                            lastOrderT = order;
                            lastOrderS = -1L;
                            lastValT = -1L;
                        }
                        if (mode == 0) {
                            if (lastOrder != -1L && lastVal == -1L) {
                                w += MocLint.warning(out, "[4.3.2]: previous order has no value (token [" + tok + "] line:" + line + ").");
                            }
                            if (order > 61L) {
                                e += MocLint.error(out, "[3.1]: too high order (token [" + tok + "] line:" + line + ").");
                            }
                            if (order == lastOrder) {
                                w += MocLint.warning(out, "[4.3.2]: redundant consecutive order (token [" + tok + "] line:" + line + ").");
                            }
                            if (order < lastOrder) {
                                w += MocLint.warning(out, "[4.3.2]: order values should be ascending (token [" + tok + "] line:" + line + ").");
                            }
                            if (order > mocOrd) {
                                mocOrd = order;
                            }
                            lastOrder = order;
                            lastVal = -1L;
                        }
                        maxval = Moc.pow2(order);
                        if (mode != 1) {
                            maxval = 12L * maxval * maxval;
                        }
                        s1 = s1.substring(slashPos + 1);
                    }
                    if (s1.length() == 0) continue;
                    if (order == -1L) {
                        e += MocLint.error(out, "[4.3.2]: Unknown order (line " + line + ")");
                    } else {
                        int dash = s1.indexOf(45);
                        if (dash > 0) {
                            val1 = MocLint.getInt(s1.substring(0, dash));
                            val2 = MocLint.getInt(s1.substring(dash + 1));
                            s1 = s1.substring(0, dash);
                        } else {
                            val1 = MocLint.getInt(s1);
                            val2 = -2L;
                        }
                        ++nbval;
                        if (val1 < 0L) {
                            e += MocLint.error(out, "[3.1]: value error (token [" + tok + "] line:" + line + "). Must be a positive integer");
                        }
                        if (val1 > maxval) {
                            e += MocLint.error(out, "[3.1]: too high value (token [" + tok + "] line:" + line + ") [" + val1 + ">" + maxval + "]");
                        }
                        if (mode == 2) {
                            if (val1 <= lastValS) {
                                w += MocLint.warning(out, "[4.3.2]: space values should be ascending (token [" + tok + "] line:" + line + ").");
                            }
                            lastValS = Math.max(val1, val2);
                        }
                        if (mode == 1) {
                            if (val1 <= lastValT) {
                                w += MocLint.warning(out, "[4.3.2]: time values should be ascending (token [" + tok + "] line:" + line + ").");
                            }
                            lastValT = Math.max(val1, val2);
                        }
                        if (mode == 0) {
                            if (val1 <= lastVal) {
                                w += MocLint.warning(out, "[4.3.2]: values should be ascending (token [" + tok + "] line:" + line + ").");
                            }
                            lastVal = Math.max(val1, val2);
                        }
                        if (val2 != -2L) {
                            ++nbval;
                            if (val1 < 0L) {
                                e += MocLint.error(out, "[3.1]: end range error (token [" + tok + "] line:" + line + ") [" + s1.substring(dash + 1) + "]. Must be a positive integer");
                            }
                            if (val2 <= val1) {
                                e += MocLint.error(out, "[4.3.2]: end range must be greater than start range (token [" + tok + "] line:" + line + ") [" + val1 + "-" + val2 + "]. ");
                            }
                        }
                    }
                    if (e <= 20) continue;
                    MocLint.tooMany(out);
                }
            }
            if (moct == 2 && mode == 1) {
                e += MocLint.error(out, "[4.3.2]: Bad structure. Missing space ranges at the end of the STMOC (token [" + tok + "] line:" + line + ")");
            }
        }
        catch (Exception e1) {
            e += MocLint.error(out, "Unrecovered exception !");
        }
        if (!json) {
            MocLint.info(out, "Moc version: " + (moct != -1 || mocOrd > 29L ? "MOC2.0" : "MOC1.1"));
        }
        MocLint.info(out, "Moc dimension: " + (moct == 2 ? "TIME.SPACE" : (moct == 0 ? "SPACE" : (moct == 1 ? "TIME" : (mocOrd > 29L ? "TIME" : "SPACE or TIME")))));
        if (mocOrdS != -1L) {
            MocLint.info(out, "Space order: " + mocOrdS);
        }
        if (mocOrdT != -1L) {
            MocLint.info(out, "Time order: " + mocOrdT);
        }
        if (mocOrd != -1L) {
            MocLint.info(out, "Moc order: " + mocOrd);
        }
        MocLint.info(out, "Moc ASCII size: " + nbval + " values");
        if (w == 0 && e == 0) {
            MocLint.status(out, "OK! MOC compliant with IVOA MOC " + (mocv == 1 ? "1.1" : "2.0") + " recommendation");
            return 1;
        }
        if (e == 0) {
            if (json) {
                MocLint.status(out, "WARNING! JSON Moc seems ok, but not standard in IVOA MOC recommendation");
                return -1;
            }
            MocLint.status(out, "WARNING! MOC ok but not fully compliant with IVOA MOC " + (mocv == 1 ? "1.1" : "2.0") + " recommendation");
            return -1;
        }
        MocLint.status(out, "ERROR! MOC error, not usable");
        return 0;
    }
}

