/*
 * browser.js
 *
 * Version: 1.1
 * Date:    25th August 2004
 * Author:  Copyright (c) Objecteering Sofware 1996-2004. All rights reserved.
 *
 */

var navIEcompatible = false;
if (navigator.appName == "Microsoft Internet Explorer") navIEcompatible = true;


function init() {
    rootElement = xmlDoc.documentElement;

    var element;
    var root = new BrowserRootNode ();

    elem = getChildNodes (rootElement);

    if (elem.length != 0) {
        var temp;
        var select;

        for (var i = 0; i < elem.length; i++) {
            temp = new Array();
            temp [0] = elem [i].getAttribute ("name");
            temp [1] = elem [i].getAttribute ("image");
            temp [2] = elem [i].getAttribute ("link");

            element = new BrowserNode (temp [0], i + "#", temp [1], temp [2], null);

            if (i == 0) element.last = "first";
            if (i == 0 && i == elem.length - 1) element.last = "alone";
            else if (i == elem.length - 1) element.last = "true";

            root.add (document.getElementById (root.id), element);
        }

        BrowserProp.selected = BrowserProp.cookies.getValue ("Browser-selected");
        if (BrowserProp.selected == null) BrowserProp.selected = "0#-a";
        BrowserProp.select (BrowserProp.selected);

        window.focus ();
    }
}

function getChildNodes (element) {
    childElem = element.childNodes;

    result = new Array ();

    for (var i = 0; i < childElem.length; i++) {
        if (childElem [i].nodeName == "Node") result[result.length] = childElem [i];
    }
    return result;
}

function getChildNodesById (id) {
    childElem = getElementById (id);

    var result = new Array ();
    tempResult = childElem.childNodes;

    for (var i = 0; i < tempResult.length; i++) {
        element = tempResult [i];
        if (element.nodeName == "Node") result [result.length] = element;
    }
    return result;
}

function hasChildNodesById (id) {
    childElem = getElementById (id);

    return childElem.hasChildNodes ();
}

function getElementById (id) {
    var index = 0;
    var childElem = rootElement;
    var tempChildNodes;
    var indexNode;


    while (id != "") {
        indexNode = 0;
        index = id.indexOf ("#");
        realIndexNode = id.substr (0, index);
        tempChildNodes = new Array ();
        tempChildNodes = childElem.childNodes;
        for (var i = 0; i < tempChildNodes.length; i++) {
            if (tempChildNodes [i].nodeName == "Node") {
                if (indexNode == realIndexNode) {
                    childElem = tempChildNodes [i];
                    i = tempChildNodes.length;
                }
                indexNode++;
            }
        }
        id = id.substr (index + 1, id.length);
    }
    return childElem;
}

var BrowserProp = {
    all             : {},

    SingleIcon      : "images/single.png",
    PlusIcon        : "images/plus.png",
    MinusIcon       : "images/minus.png",
    TIcon           : "images/T.png",
    TPlusIcon       : "images/Tplus.png",
    TMinusIcon      : "images/Tminus.png",
    StartLIcon      : "images/StartL.png",
    EndLIcon        : "images/EndL.png",
    EndLPlusIcon    : "images/EndLplus.png",
    EndLMinusIcon   : "images/EndLminus.png",
    StartLPlusIcon  : "images/StartLplus.png",
    StartLMinusIcon : "images/StartLminus.png",
    IIcon           : "images/I.png",
    blankIcon       : "images/blank.png",
    emptyIcon       : "images/empty.png",

    selected        : null,

    select          : function (id) {
        temp = document.getElementById (this.selected);
        if (temp != null) {
            node = BrowserProp.all [temp.id.substr (0, temp.id.length - 2)];
            if (node != null) {
                if (node.highlightColor != null) temp.style.background = node.highlightColor;
                else temp.style.background = "none";
                if (node.highlightTextColor != null) {
                    temp.style.color = node.highlightTextColor;
                } else temp.style.color = "black";
            }
        }

        _id = id.substr (0, (id.length - 2));
        _index = id.indexOf ("#") + 1;
        indextemp = _index;
        idtemp2 = _id.substr (_index, id.length);
        idtemp = _id.substr(0, _index);
        while (indextemp != "0") {
            if (idtemp2.indexOf ("#") != -1) {
                tempElement = BrowserProp.all [idtemp];
                if (tempElement != null) if (!tempElement.open) tempElement.expand ();
            }
            indextemp = idtemp2.indexOf ("#") + 1;
            _index += indextemp;
            idtemp2 = _id.substr (_index, idtemp.length);
            idtemp = _id.substr(0, _index);
        }

        if (document.getElementById (id) == null) id = "0#-a";
        document.getElementById (id).style.background = "highlight";
        document.getElementById (id).style.color = "highlighttext";
        this.selected = id;
        this.cookies.setValue ("Browser-selected", id);
        this.displayElement (id);
    },

    displayElement      : function (id) {
        if (id == "0#") window.scrollTo (1, 1);
        else if (document.getElementById (id).offsetTop < document.body.scrollTop) {
            window.scrollTo (1, document.getElementById (id).offsetTop);
        } else {
            var offset = document.getElementById (id).offsetTop - document.body.offsetHeight;
            if (offset + 36 > document.body.scrollTop) window.scrollTo (1, offset + 36);
        }
    },

    cookies         : new BrowserCookie()
}

function BrowserAbstractNode (name, id, open, range) {
    this.text = name;
    this.id = id;
    BrowserProp.all[this.id] = this;
    this.childNodes = new Array ();
    this.open = open;
    this.range = range;
    this.parentNode;
}

BrowserAbstractNode.prototype.add = function (rootDiv, node) {
    node.range = this.range + 1;
    node.parentNode = this;

    cn = document.createElement ("DIV");
    cn.setAttribute ("id", node.id);
    cn.setAttribute ("class", "node");

    cnimp = document.createElement ("img");

    var im;
    var attrclick = false;
    if (node.parentNode.id == "root") {
        if (node.last == "alone") {
            if (!node.hasChildNodes) im = BrowserProp.SingleIcon;
            else {
                im = BrowserProp.PlusIcon;
                attrclick = true;
            }
        } else {
            if (node.last == "first") {
                if (!node.hasChildNodes) im = BrowserProp.StartLIcon;
                else {
                    im = BrowserProp.StartLPlusIcon;
                    attrclick = true;
                }
            } else {
                if (node.last == "false") {
                    if (!node.hasChildNodes) im = BrowserProp.TIcon;
                    else {
                        im = BrowserProp.TPlusIcon;
                        attrclick = true;
                    }
                } else  {
                    if (!node.hasChildNodes) im = BrowserProp.EndLIcon;
                    else {
                        im = BrowserProp.EndLPlusIcon;
                        attrclick = true;
                    }
                }
            }
        }
    } else {
        if (node.last == "true" || this.parentNode == null) {
            if (node.hasChildNodes) {
                im = BrowserProp.EndLPlusIcon;
                attrclick = true;
            } else im = BrowserProp.EndLIcon;
        } else {
            if (node.hasChildNodes) {
                im = BrowserProp.TPlusIcon;
                attrclick = true;
            } else im = BrowserProp.TIcon;
        }
    }

    cnimp.setAttribute ("id", node.id + "-i-l");
    cnimp.setAttribute ("src", im);

    if (attrclick) cnimp.onclick=node.dblclick;

    if (node.icon != "") {
        cnim = document.createElement ("img");
        cnim.setAttribute ("id", node.id + "-i");
        cnim.setAttribute ("src", node.icon);

        if (navIEcompatible) cnim.ondblclick = node.dblclick;
        cnim.onclick = node.click;
    } else {
        cnim = document.createElement ("");
    }

    var cna;
    if (node.link != null && node.link != "") {
        cna = document.createElement ("a");
        cna.setAttribute ("href", node.link);
    } else {
        cna = document.createElement ("text");
    }
    cna.setAttribute ("id", node.id + "-a");
    cna.onfocus = cna.blur;
    cna.onclick = node.click;
    document.onkeydown = BrowserAbstractNode.prototype.keyDown;

    cnatext = document.createTextNode (node.text);
    cna.appendChild (cnatext);

    if (node.highlightColor != null) cna.style.background = node.highlightColor;
    if (node.highlightTextColor != null) cna.style.color = node.highlightTextColor;

    index = 0;
    var imagelink = new Array ();

    var idtemp = this.id;

    for (var i = 0; i < this.range; i++) {
        cnimpl = document.createElement ("img");
        cnimpl.setAttribute ("id", node.id + i + "-i-l");
        var image;
        if (BrowserProp.all[idtemp].last == "true" || BrowserProp.all[idtemp].last == "alone") {
            image = BrowserProp.blankIcon
        }
        else image = BrowserProp.IIcon;
        cnimpl.setAttribute ("src", image);
        imagelink[imagelink.length] = cnimpl;

        idtemp = idtemp.substr(0, idtemp.length - 1)
        index = idtemp.lastIndexOf ("#");
        idtemp = idtemp.substr(0, index + 1)
    }

    for (var i = imagelink.length - 1; i >= 0; i--) {
        cn.appendChild (imagelink[i]);
    }

    cn.appendChild (cnimp);

    cn.appendChild (cnim);

    cn.appendChild (cna);

    this.childNodes[this.childNodes.length] = cn;

    rootDiv.appendChild (cn);

    if (BrowserProp.cookies.getValue (node.id) == "0")  {
        node.expand ();
    }
}

BrowserAbstractNode.prototype.remove = function () {
    element = document.getElementById (this.id);
    for (var i = 0; i < this.childNodes.length; i++) {
        element.removeChild (this.childNodes [i]);
    }
    this.childNodes = new Array ();
}

BrowserAbstractNode.prototype.collapse = function () {
    BrowserProp.cookies.setValue(this.id, "1");
    this.open = false;
    element = document.getElementById (this.id + "-i-l");

    if(element != null) {
        if (this.last == "alone") element.setAttribute ("src", BrowserProp.PlusIcon);
        else if (this.last == "first") element.setAttribute ("src", BrowserProp.StartLPlusIcon);
        else if (this.last == "false") element.setAttribute ("src", BrowserProp.TPlusIcon);
        else if (this.last == "true") element.setAttribute ("src", BrowserProp.EndLPlusIcon);
    }
    this.remove ();
}

BrowserAbstractNode.prototype.expand = function () {
    BrowserProp.cookies.setValue(this.id, "0");

    this.open = true;

    element = document.getElementById (this.id + "-i-l");
    if(element != null) {
        if (this.last == "alone") element.setAttribute ("src", BrowserProp.MinusIcon);
        else if (this.last == "first") element.setAttribute ("src", BrowserProp.StartLMinusIcon);
        else if (this.last == "false") element.setAttribute ("src", BrowserProp.TMinusIcon);
        else if (this.last == "true") element.setAttribute ("src", BrowserProp.EndLMinusIcon);
    }

    var childNodes = getChildNodesById (this.id);

    for(var i = 0; i < childNodes.length; i++) {
        childNodes = getChildNodesById (this.id);
        node = childNodes[i];
        var childNode = new BrowserNode (node.getAttribute ("name"), this.id + i + "#", node.getAttribute ("image"), node.getAttribute ("link"), this.last);
        childNode.last = (i == (childNodes.length - 1))?"true":"false";
        var rootDiv = document.getElementById (this.id);
        this.add (rootDiv, childNode);
    }
}

BrowserAbstractNode.prototype.toggle = function () {
    if (this.hasChildNodes) {
        if(this.open) this.collapse ();
        else this.expand ();
    }
}

BrowserAbstractNode.prototype.keyDown = function (e) {
    var idAnchor = BrowserProp.selected;
    if (!navIEcompatible) {
        key = e.which;
    } else key = event.keyCode;

    if (key == 9) key = 40;

    if (key == 38) {
        elt = BrowserProp.all [idAnchor.substr (0, (idAnchor.length - 2))];
        if (elt.parentNode.id == "root" && elt.last == "alone") return false;
        if (!(elt.parentNode.id == "root" && elt.last == "first")) {
            var previousElement;
            previousElement = elt.id;
            previousElement = previousElement.substr (0, previousElement.length - 1);
            lastindex = previousElement.lastIndexOf ("#");
            if (lastindex != -1) previousElement = previousElement.substr (lastindex + 1, previousElement.length);
            if (previousElement == 0) {
                BrowserProp.select (elt.parentNode.id + "-a");
            } else {
                var parentId = (elt.parentNode.id == "root")?"":elt.parentNode.id;
                temp = BrowserProp.all [parentId + (previousElement -1) + "#"];
                if (temp.open) {
                    search = true;
                    while (search) {
                        childs = temp.childNodes;
                        temp = BrowserProp.all [childs [childs.length -1].id];
                        if (!temp.open) search = false;
                    }
                    temp = childs [childs.length -1];

                    BrowserProp.select (temp.id + "-a");
                } else {
                    BrowserProp.select (parentId + (previousElement - 1) + "#-a");
                }
            }
        }
        return false;
    }

    else if (key == 39) {
        elt = BrowserProp.all [idAnchor.substr (0, (idAnchor.length - 2))];
        if (elt.hasChildNodes && elt.open) {
            BrowserProp.select (elt.id + "0#" + "-a");
        } else if (elt.hasChildNodes && !elt.open) { elt.expand(); }
        return false;
    }

    else if (key == 37) {
        elt = BrowserProp.all [idAnchor.substr (0, (idAnchor.length - 2))];
        if (elt.parentNode.id == "root") { if(elt.open) elt.collapse (); }
        else {
            if (elt.open) elt.collapse();
            else {
                BrowserProp.select (elt.parentNode.id + "-a");
            }
        }
        return false;
    }

    else if (key == 40) {
        elt = BrowserProp.all [idAnchor.substr (0, (idAnchor.length - 2))];
        if (elt.parentNode.id == "root" && elt.last == "alone" && (!elt.hasChildNodes || (elt.hasChildNodes && !elt.open))) return false;

        if (elt.hasChildNodes && elt.open) {
            BrowserProp.select (elt.id + "0#" + "-a");

        } else if (elt.last != "true") {
            var nextElement = elt.id;
            nextElement = nextElement.substr (0, nextElement.length - 1);
            lastindex = nextElement.lastIndexOf ("#");
            if (lastindex != -1) nextElement = nextElement.substr (lastindex + 1, nextElement.length);
            var parentId = (elt.parentNode.id == "root")?"":elt.parentNode.id;
            BrowserProp.select (parentId + (nextElement - (-1)) + "#" + "-a");

        } else if (elt.last == "true" && !elt.open) {
            if (elt.parentNode.id != "root") {
                temp = false;
                tempelt = elt;
                for (var i = 0; i < elt.parentNode.range; i++) {
                    if (tempelt.parentNode.last != "true" && tempelt.parentNode.last != "alone") temp = true;
                    tempelt = elt.parentNode;
                }
                if (temp) {
                    var parent = elt.parentNode;
                    while (parent.last == "true") parent = parent.parentNode;

                    var nextElement = (parent.id == "root")?"":parent.id;
                    nextElement = nextElement.substr (0, nextElement.length - 1);
                    lastindex = nextElement.lastIndexOf ("#");

                    var root = "";
                    if (lastindex != -1) {
                        root = nextElement.substr (0, lastindex + 1);
                        nextElement = nextElement.substr (lastindex + 1, nextElement.length);
                    }
                    BrowserProp.select (root + (nextElement - (-1)) + "#" + "-a");
                }
            }
        }
        return false;
    }

    else if (key == 13) {
    }

    else if (key == 106) {
        elt = BrowserProp.all [idAnchor.substr (0, (idAnchor.length - 2))];
        if (elt.hasChildNodes) {
            if (!elt.open) elt.expand ();
            childs = elt.childNodes;
            for (var i = 0; i < childs.length; i++) {
                temp = childs [i];
                temp = BrowserProp.all [temp.id];
                if (temp.hasChildNodes && !temp.open) temp.expand ();
            }
        }
    }

    else if (key == 107) {
        elt = BrowserProp.all [idAnchor.substr (0, (idAnchor.length - 2))];
        if (elt.hasChildNodes && !elt.open) elt.expand ();
    }

    else if (key == 109) {
        elt = BrowserProp.all [idAnchor.substr (0, (idAnchor.length - 2))];
        if (elt.hasChildNodes && elt.open) elt.collapse ();
    }

    else if (key == 33) {
        childs = BrowserProp.all ["root"].childNodes;
        if (childs != null) BrowserProp.select (childs [0].id + "-a");
        return false;
    }

    else if (key == 34) {
        temp = BrowserProp.all ["root"];
        while (temp.childNodes.length > 1) {
            temp = temp.childNodes [temp.childNodes.length - 1];
        }

        BrowserProp.select (temp.id);
        return false;
    }

    return true;
}

BrowserAbstractNode.prototype.dblclick = function (e) {
    var id = this.id.replace ("-i", "");
    id = id.replace ("-l", "");
    BrowserProp.all [id].toggle ();
    id += "-a";
    BrowserProp.select (id);
}

BrowserAbstractNode.prototype.click = function (e) {
    BrowserProp.select (this.id.replace ("-i", "-a"));
}

function BrowserNode (name, id, icon, link, last) {
    this.base = BrowserAbstractNode;
    this.base (name, id, false, 0);
    if (icon == null) {
        this.icon = BrowserProp.emptyIcon;
    } else {
        this.icon = icon;
    }
    this.link = link;
    this.last = "false";
    this.hasChildNodes = hasChildNodesById (id);
}

BrowserNode.prototype = new BrowserAbstractNode;

function BrowserRootNode () {
    this.base = BrowserAbstractNode;
    this.base ("root", "root", false, 0);
    this.last = "false";
}

BrowserRootNode.prototype = new BrowserAbstractNode;


function BrowserCookie() {
    if (document.cookie.length) {
        this.cookies = " " + document.cookie;
    }
}

BrowserCookie.prototype.setValue = function (id, str) {
    document.cookie = dataFile + id + "=" + escape(str);
    if (document.cookie.length) {
        this.cookies = " " + document.cookie;
    }
}

BrowserCookie.prototype.getValue = function (id) {
    if (this.cookies) {
        var start = this.cookies.indexOf(" " + dataFile + id + "=");
        if (start == -1) { return null; }
        var end = this.cookies.indexOf(";", start);
        if (end == -1) { end = this.cookies.length; }
        end -= start;
        var cookie = this.cookies.substr(start,end);
        return unescape(cookie.substr(cookie.indexOf("=") + 1, cookie.length - cookie.indexOf("=") + 1));
    } else {
        return null;
    }
}
