/*
 * Created by Ray Plante for the National Virtual Observatory
 * c. 2006
 */
package net.ivoa.registry.search;

import net.ivoa.registry.RegistryAccessException;

/**
 * an exception indicating that an ADQL query contains a syntax error
 */
public class ADQLSyntaxException extends RegistryAccessException {

    protected Exception wrapped = null;

    public ADQLSyntaxException() {
        this("Requested identifier not found");
    }

    public ADQLSyntaxException(String msg) {
        super(msg);
    }

    /**
     * Wrap the exception generated by the ADQL parser that detected the
     * Error.  (This is usually a TransformException.)
     */
    public ADQLSyntaxException(Exception ex) {
        super(ex.getMessage());
        wrapped = ex;
    }

    /**
     * return the original exception that resulted from parsing the query.
     * Null is returned if an exception is not wrapped.
     */
    public Exception getWrapped() { return wrapped; }
}
