/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.net.URL;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import net.ivoa.registry.RegistryServiceException;
import net.ivoa.registry.search.DefaultServiceCaller;
import net.ivoa.registry.search.IDNotFoundException;
import net.ivoa.registry.search.ServiceCaller;
import net.ivoa.registry.search.UnsupportedOperationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SOAPSearchClient {
    protected URL endpoint = null;
    protected MessageFactory soapfactory = null;
    protected SOAPConnection conn = null;
    protected ServiceCaller caller = null;
    public static final String GETIDENTITY_ACTION = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0#GetIdentity";
    public static final String GETRESOURCE_ACTION = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0#GetResource";
    public static final String SEARCH_ACTION = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0#Search";
    public static final String KEYWORDSEARCH_ACTION = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0#KeywordSearch";
    public static final String XQUERYSEARCH_ACTION = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0#XQuerySearch";
    public static final String WSDL_NS = "http://www.ivoa.net/wsdl/RegistrySearch/v1.0";
    public static final String WSDL_PREFIX = "rs";

    protected SOAPSearchClient() {
        try {
            this.soapfactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            throw new InternalError("installation/config error: " + ex.getMessage());
        }
    }

    public SOAPSearchClient(URL endpointURL) {
        this();
        this.endpoint = endpointURL;
        this.caller = new DefaultServiceCaller(this.endpoint);
    }

    public void setCaller(ServiceCaller c) {
        if (c == null) {
            this.caller = new DefaultServiceCaller(this.endpoint);
        } else {
            this.caller = c;
            this.caller.setEndpoint(this.endpoint);
        }
    }

    public Element keywordSearch(String keywords, boolean orThem, int from, int max, boolean identifiersOnly) throws RegistryServiceException, SOAPException {
        SOAPMessage msg = this.makeSOAPMessage();
        SOAPBody body = msg.getSOAPBody();
        SOAPBodyElement sel = body.addBodyElement(this.makeRSName(msg, "KeywordSearch"));
        SOAPElement arg = sel.addChildElement(this.makeRSName(msg, "keywords"));
        arg.addTextNode(keywords.trim());
        arg = sel.addChildElement(this.makeRSName(msg, "orValues"));
        arg.addTextNode(Boolean.toString(orThem));
        if (from > 0) {
            arg = sel.addChildElement(this.makeRSName(msg, "from"));
            arg.addTextNode(Integer.toString(from));
        }
        if (max > 0) {
            arg = sel.addChildElement(this.makeRSName(msg, "max"));
            arg.addTextNode(Integer.toString(max));
        }
        arg = sel.addChildElement(this.makeRSName(msg, "identifiersOnly"));
        arg.addTextNode(Boolean.toString(identifiersOnly));
        Element res = this.call(msg, KEYWORDSEARCH_ACTION);
        return res;
    }

    public Element search(Element adqlWhere, int from, int max, boolean identifiersOnly) throws RegistryServiceException, SOAPException, DOMException {
        SearchQuery query = new SearchQuery();
        SOAPElement wparent = query.getWhereParent();
        query.setWhere(adqlWhere);
        query.setFrom(from);
        query.setMax(max);
        query.setIdentifiersOnly(identifiersOnly);
        return this.search(query);
    }

    public SearchQuery createSearchQuery() throws SOAPException {
        return new SearchQuery();
    }

    public Element search(SearchQuery query) throws RegistryServiceException, SOAPException {
        return this.call(query.getSearchSOAPMessage(), SEARCH_ACTION);
    }

    public Element getIdentity() throws RegistryServiceException, SOAPException {
        SOAPMessage msg = this.makeSOAPMessage();
        SOAPBody body = msg.getSOAPBody();
        SOAPBodyElement sel = body.addBodyElement(this.makeRSName(msg, "GetIdentity"));
        return this.call(msg, GETIDENTITY_ACTION);
    }

    public Element getResource(String ivoid) throws RegistryServiceException, IDNotFoundException, SOAPException {
        SOAPMessage msg = this.makeSOAPMessage();
        SOAPBody body = msg.getSOAPBody();
        SOAPBodyElement sel = body.addBodyElement(this.makeRSName(msg, "GetResource"));
        SOAPElement id = sel.addChildElement(this.makeRSName(msg, "identifier"));
        id.addTextNode(ivoid.trim());
        Element res = this.call(msg, GETRESOURCE_ACTION);
        return res;
    }

    protected Name makeRSName(SOAPMessage msg, String elname) throws SOAPException {
        return msg.getSOAPPart().getEnvelope().createName(elname, WSDL_PREFIX, WSDL_NS);
    }

    public Element xquerySearch(String xquery) throws RegistryServiceException, UnsupportedOperationException, SOAPException {
        SOAPMessage msg = this.makeSOAPMessage();
        SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
        SOAPBody body = msg.getSOAPBody();
        SOAPBodyElement sel = body.addBodyElement(this.makeRSName(msg, "XQuerySearch"));
        SOAPElement id = sel.addChildElement(this.makeRSName(msg, "xquery"));
        id.addTextNode(xquery.trim());
        Element res = this.call(msg, XQUERYSEARCH_ACTION);
        return res;
    }

    public SOAPMessage makeSOAPMessage() throws SOAPException {
        return this.soapfactory.createMessage();
    }

    protected Element call(SOAPMessage msg, String actionURI) throws RegistryServiceException, SOAPException {
        return this.caller.call(msg, actionURI);
    }

    public class SearchQuery {
        SOAPMessage msg = null;
        int from = 0;
        int max = -1;
        boolean identifiersOnly = false;
        SOAPElement whereParent = null;

        SearchQuery() throws SOAPException {
            this.msg = SOAPSearchClient.this.makeSOAPMessage();
            SOAPBody body = this.msg.getSOAPBody();
            SOAPEnvelope env = this.msg.getSOAPPart().getEnvelope();
            this.whereParent = body.addBodyElement(SOAPSearchClient.this.makeRSName(this.msg, "Search"));
            this.whereParent.setAttribute("xmlns", SOAPSearchClient.WSDL_NS);
        }

        public void setWhere(Element where) throws SOAPException {
            SOAPElement wparent = this.getWhereParent();
            where = (Element)wparent.getOwnerDocument().importNode(where, true);
            if (SOAPSearchClient.WSDL_NS.equals(where.getNamespaceURI())) {
                wparent.appendChild((Node)where);
            } else {
                SOAPElement newwhere = wparent.addChildElement(SOAPSearchClient.this.makeRSName(this.msg, "Where"));
                Attr attr = null;
                NamedNodeMap attrs = where.getAttributes();
                while (attrs.getLength() > 0 && (attr = (Attr)attrs.item(0)) != null) {
                    newwhere.setAttributeNode(attr);
                }
                Node node = where.getFirstChild();
                while (node != null) {
                    newwhere.appendChild(node);
                    node = where.getFirstChild();
                }
            }
        }

        public SOAPMessage getSearchSOAPMessage() throws SOAPException {
            SOAPElement child = null;
            SOAPEnvelope env = this.msg.getSOAPPart().getEnvelope();
            if (this.from > 0) {
                child = this.whereParent.addChildElement(SOAPSearchClient.this.makeRSName(this.msg, "from"));
                child.addTextNode(Integer.toString(this.from));
            }
            if (this.max > 0) {
                child = this.whereParent.addChildElement(SOAPSearchClient.this.makeRSName(this.msg, "max"));
                child.addTextNode(Integer.toString(this.max));
            }
            child = this.whereParent.addChildElement(SOAPSearchClient.this.makeRSName(this.msg, "identifiersOnly"));
            child.addTextNode(Boolean.toString(this.identifiersOnly));
            return this.msg;
        }

        public SOAPElement getWhereParent() {
            this.whereParent.removeContents();
            return this.whereParent;
        }

        public int getFrom() {
            return this.from;
        }

        public void setFrom(int pos) {
            this.from = pos;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int count) {
            this.max = count;
        }

        public boolean isIdentifiersOnly() {
            return this.identifiersOnly;
        }

        public void setIdentifiersOnly(boolean yes) {
            this.identifiersOnly = yes;
        }
    }
}

