/* Generated By:JavaCC: Do not edit this line. Where2DOM.java */
package net.ivoa.registry.search;

import java.io.* ;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

import javax.xml.transform.TransformerException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

public class Where2DOM implements Where2DOMConstants {

    public static void main( String args[] )
        throws TransformerException
    {

        Where2DOM p = null ;
        if ( args.length < 1  ) {
            p = new Where2DOM(System.in) ;
        }
        else {
            try {
                p = new Where2DOM(new DataInputStream(
                                new FileInputStream(args[0]))) ;
            }
            catch (FileNotFoundException e) {
                p = new Where2DOM(System.in) ;
            }
        }

        try { p.parseWhere(); }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        System.out.println("Parse Successful") ;

    } // main ends here

    private boolean defineSTCR = false;
    private boolean defineSTCC = false;

    public final static String ADQL_NS = "http://www.ivoa.net/xml/ADQL/v1.0";
    public final static String ADQL_PREFIX = "ad";
    public final static String STCR_NS =
                                "http://www.ivoa.net/xml/STC/STCregion/v1.10";
    public final static String STCR_PREFIX = "reg";
    public final static String STCC_NS =
                                "http://www.ivoa.net/xml/STC/STCcoords/v1.10";
    public final static String STCC_PREFIX = "stc";

    protected Document doc = null;
    protected Node parent = null;
    protected int indent = -1;
    protected short nsmode = MODE_ALWAYS_QUALIFIED;
//     protected boolean xpathenabled = false;

    public final static String XSI_NS =
        "http://www.w3.org/2001/XMLSchema-instance";

    public Where2DOM() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
            parent = doc;
        }
        catch (ParserConfigurationException pce) {
            throw new InternalError("programmer error: DOM new doc failure");
        }
//         System.err.println("doc is ready");
//         System.err.flush();
    }

    protected Element createADQLElement(String name) {
        if (nsmode == MODE_ALWAYS_QUALIFIED) name = ADQL_PREFIX + ":" + name;
        return doc.createElementNS(ADQL_NS, name);
    }

    private Element createSTCRElement(String name) {
        defineSTCR = true;
//        if (nsmode == MODE_ALWAYS_QUALIFIED) name = STCR_PREFIX + ":" + name;
        name = STCR_PREFIX + ":" + name;
        return doc.createElementNS(STCR_NS, name);
    }

    private Element createSTCCElement(String name) {
        defineSTCC = true;
        if (nsmode == MODE_ALWAYS_QUALIFIED) name = STCC_PREFIX + ":" + name;
        return doc.createElementNS(STCC_NS, name);
    }

    private Element createRootElement(String name) {
        Element root = createADQLElement(name);
        root.setAttribute("xmlns:ad", ADQL_NS);
        if (defineSTCR) root.setAttribute("xmlns:" + STCR_PREFIX, STCR_NS);
        if (defineSTCC) root.setAttribute("xmlns:" + STCC_PREFIX, STCC_NS);
        root.setAttribute("xmlns:xsi", XSI_NS);
        if (nsmode == MODE_DEFAULT_NS) root.setAttribute("xmlns", ADQL_NS);
        parent.appendChild(root);
        return root;
    }

    private Element getBinaryExpr(String name, boolean setXSIType,
                                  Element arg1, Element arg2, String op)
    {
        Element out = createADQLElement(name);
        if (setXSIType) setXSITypeAttr(out, "binaryExprType");
        out.setAttribute("Oper", op);
        // doc.renameNode(arg1, ADQL_NS, ADQL_PREFIX + ":Arg");
        // doc.renameNode(arg2, ADQL_NS, ADQL_PREFIX + ":Arg");
        out.appendChild(arg1);
        out.appendChild(arg2);
        return out;
    }

    private static void setXSITypeAttr(Element on, String type) {
        on.setAttributeNS(XSI_NS, "xsi:type", ADQL_PREFIX + ':' + type);
    }

    public Element parseWhere() throws ParseException {
        return Where("Where");
    }

    /**
     * set the desired pretty-fying indent amount.  If indent = 0, only 
     * carriage returns are inserted between each element.  If indent < 0,
     * no indentation or carriage returns will be inserted.  
     * @param indent  the amount of indentation per depth level
     */
    public void setIndent(int indent) { this.indent = indent; }

    /**
     * return the pretty-fying indent amount that will be inserted.  
     * If indent = 0, only carriage returns are inserted between each
     * element.  If indent < 0, no indentation or carriage returns will 
     * be inserted.  
     * @param indent  the amount of indentation per depth level
     */
    public int getIndent() { return indent; }

    /**
     * insert the text nodes that provide pretty indentations.  This 
     * will avoid inserting indentation multiple times.  
     */
    public void indent() {
        Element parent = doc.getDocumentElement();
        if (parent == null || indent < 0) return;
        indent(parent, "\n", indent);
    }

    /**
     * insert the text nodes that provide pretty indentations.  This 
     * will avoid inserting indentation multiple times.  
     * @param parent    the node to insert text nodes into
     * @param indent    the current indentation string on parent.  If null,
     *                     no indentation is currently in place.
     * @param incr      the indentation increment
     */
    public void indent(Element parent, String indent, int incr) {
        if (! parent.hasChildNodes()) return;
        if (indent == null) indent = "\n";
        String childIndent = addIndentation(indent, incr);

        boolean skipElement = false;
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == Node.TEXT_NODE) {
                skipElement = true;
            }
            else {
                if (! skipElement) {
                    Node txt = doc.createTextNode(childIndent);
                    parent.insertBefore(txt, child);
                }
                if (child.getNodeType() == Node.ELEMENT_NODE) {
                    indent((Element) child, childIndent, incr);
                }
                skipElement = false;
            }
            child = child.getNextSibling();
        }
        if (! skipElement) {
            Node txt = doc.createTextNode(indent);
            parent.appendChild(txt);
        }
    }

    /**
     * append spaceCount spaces after the given base string
     */
    public static String addIndentation(String base, int spaceCount) {
        StringBuffer sb = new StringBuffer(base);
        for(int i=0; i < spaceCount; i++) sb.append(' ');
        return sb.toString();
    }

    /**
     * the namespace qualification mode in which all elements will always
     * be fully qualified with a prefix
     */
    public final static short MODE_ALWAYS_QUALIFIED = 0;

    /**
     * the namespace qualification mode in which default namespaces
     * are defined to minimize the qualification with prefixes.
     */
    public final static short MODE_DEFAULT_NS = 1;

    /**
     * the total number of namespace qualification modes supported
     */
    protected final static short MODE_COUNT = 2;

    /**
     * set the namespace qualification mode to use
     */
    public void setNSMode(short mode) {
        if (mode >= MODE_COUNT)
            throw new IllegalArgumentException("Undefined namespace " +
                                               "qualification modes (" + mode +
                                               ")");
        nsmode = mode;
    }

    /**
     * return the namespace qualification mode that will be used
     */
    public short getNSMode(short mode) { return nsmode; }

//     /**
//      * enable XPath-based column names.  When set to true, column names 
//      * are assumed to be XPath identifiers and will be stored in the 
//      * xpathName attribute to the Column element.
//      */
//     public void setXpathEnabled(boolean yes) { xpathenabled = yes; }

//     /**
//      * return whether XPath-based column names are enabled.  
//      */
//     public boolean isXpathEnabled() { return xpathenabled; }

    protected Element getChildByTag(Element el, String name) {
        Node child = el.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == Node.ELEMENT_NODE &&
                child.getNodeName().equals(name))
              return ((Element) child);
            child = child.getNextSibling();
        }
        return null;
    }

    protected boolean matchesXSIType(Element el, String qtype) {
        String type = el.getAttributeNS(XSI_NS, "xsi:type");
        return (type != null && type.length() > 0 && type.equals(qtype));
    }

    protected Element renameADQLElement(Element el, String newname,
                                        Node parent)
    {
        // create a new replacement element
        Element out = createADQLElement(newname);

        // copy over all the attributes
        Attr attr = null;
        NamedNodeMap attrs = el.getAttributes();
        while (attrs.getLength() > 0) {
            attr = (Attr) attrs.item(0);
            if (attr == null) break;
            el.removeAttributeNode(attr);
            out.setAttributeNode(attr);
        }

        // copy over all children
        Node node = el.getFirstChild();
        while (node != null) {
            el.removeChild(node);
            out.appendChild(node);
            node = el.getFirstChild();
        }

        if (parent != null) {
            parent.insertBefore(out, el);
            parent.removeChild(el);
        }

        return out;
    }

  final public String MathFunctionName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_abs:
      jj_consume_token(K_abs);
      break;
    case K_ceiling:
      jj_consume_token(K_ceiling);
      break;
    case K_degrees:
      jj_consume_token(K_degrees);
      break;
    case K_exp:
      jj_consume_token(K_exp);
      break;
    case K_floor:
      jj_consume_token(K_floor);
      break;
    case K_log10:
      jj_consume_token(K_log10);
      break;
    case K_log:
      jj_consume_token(K_log);
      break;
    case K_pi:
      jj_consume_token(K_pi);
      break;
    case K_rand:
      jj_consume_token(K_rand);
      break;
    case K_round:
      jj_consume_token(K_round);
      break;
    case K_square:
      jj_consume_token(K_square);
      break;
    case K_sqrt:
      jj_consume_token(K_sqrt);
      break;
    case K_truncate:
      jj_consume_token(K_truncate);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return token.image.toUpperCase();}
    throw new Error("Missing return statement in function");
  }

  final public String AggregateFunctionName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AVG:
      jj_consume_token(K_AVG);
      break;
    case K_COUNT:
      jj_consume_token(K_COUNT);
      break;
    case K_MAX:
      jj_consume_token(K_MAX);
      break;
    case K_MIN:
      jj_consume_token(K_MIN);
      break;
    case K_SUM:
      jj_consume_token(K_SUM);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return token.image.toUpperCase();}
    throw new Error("Missing return statement in function");
  }

  final public String TrigonometricFunctionName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_asin:
      jj_consume_token(K_asin);
      break;
    case K_acos:
      jj_consume_token(K_acos);
      break;
    case K_atan:
      jj_consume_token(K_atan);
      break;
    case K_atan2:
      jj_consume_token(K_atan2);
      break;
    case K_cos:
      jj_consume_token(K_cos);
      break;
    case K_sin:
      jj_consume_token(K_sin);
      break;
    case K_tan:
      jj_consume_token(K_tan);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return token.image.toUpperCase();}
    throw new Error("Missing return statement in function");
  }

  final public Element FunctionOfOneVar(String name, boolean setXSIType) throws ParseException {
    boolean isMath=false;
    boolean isAgg=false;
    boolean isTrig=false;
    Element arg;
    String  fname;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_abs:
    case K_ceiling:
    case K_degrees:
    case K_exp:
    case K_floor:
    case K_log:
    case K_log10:
    case K_pi:
    case K_rand:
    case K_round:
    case K_square:
    case K_sqrt:
    case K_truncate:
      fname = MathFunctionName();
                                                isMath =true;
      break;
    case K_AVG:
    case K_COUNT:
    case K_MAX:
    case K_MIN:
    case K_SUM:
      fname = AggregateFunctionName();
                                                isAgg  =true;
      break;
    case K_asin:
    case K_acos:
    case K_atan:
    case K_atan2:
    case K_cos:
    case K_sin:
    case K_tan:
      fname = TrigonometricFunctionName();
                                                isTrig =true;
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(75);
    arg = ScalarExpression("Arg");
    jj_consume_token(76);
           Element f = null;
           f  = createADQLElement(name);
           if (setXSIType) {
               if (isMath) {
                   setXSITypeAttr(f, "mathFunctionType");
               } else if (isAgg) {
                   setXSITypeAttr(f, "aggregateFunctionType");
               } else if (isTrig) {
                   setXSITypeAttr(f, "trigonometricFunctionType");
               }
           }
           f.setAttribute("Name", fname);
           f.appendChild(arg);
           {if (true) return f;}
    throw new Error("Missing return statement in function");
  }

  final public Element Atom(String name, boolean setXSIType) throws ParseException {
    Element l, u=null;
    l = Literal("Literal", true);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
    case S_PROTECTED:
      u = Unit("Unit");
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
        Element a = createADQLElement(name);
        if (setXSIType) setXSITypeAttr(a, "atomType");
        a.appendChild(l);
        if (u != null) a.appendChild(u);
        {if (true) return a;}
    throw new Error("Missing return statement in function");
  }

  final public Element Unit(String name) throws ParseException {
   String unit = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
      jj_consume_token(S_IDENTIFIER);
                    unit = token.image;
      break;
    case S_PROTECTED:
      jj_consume_token(S_PROTECTED);
       unit = token.image.substring(1,token.image.length()-1).trim();
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      Element u = createADQLElement(name);
      Node txt = doc.createTextNode(unit);
      u.appendChild(txt);
      {if (true) return u;}
    throw new Error("Missing return statement in function");
  }

  final public Element BetweenPred(String name, boolean setXSIType) throws ParseException {
     boolean not=false;
     Element arg0, arg1,arg2;
    arg0 = ScalarExpression("Arg");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
              not=true;
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    arg1 = ScalarExpression("Arg");
    jj_consume_token(K_AND);
    arg2 = ScalarExpression("Arg");
        Element b = createADQLElement(name);
        if (not) {
            if (setXSIType) setXSITypeAttr(b, "notBetweenPredType");
        } else {
            if (setXSIType) setXSITypeAttr(b, "betweenPredType");
        }
        b.appendChild(arg0);
        b.appendChild(arg1);
        b.appendChild(arg2);
        {if (true) return b;}
    throw new Error("Missing return statement in function");
  }

  final public Element ClosedExpr(String name, boolean setXSIType) throws ParseException {
     Element arg;
    jj_consume_token(75);
    arg = ScalarExpression("Arg");
    jj_consume_token(76);
        Element c = createADQLElement(name);
        if (setXSIType) setXSITypeAttr(c, "closedExprType");
        c.appendChild(arg);
        {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

  final public Element ClosedSearch(String name, boolean setXSIType) throws ParseException {
    Element s;
    jj_consume_token(75);
    s = Search(name);
    jj_consume_token(76);
        Element c = createADQLElement(name);
        if (setXSIType) setXSITypeAttr(c, "closedSearchType");
        c.appendChild(s);
        {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

  final public Element ColumnReference(String name, boolean setXSIType) throws ParseException {
    Element col;
    col = XPathReference(name, setXSIType);
     {if (true) return col;}
    throw new Error("Missing return statement in function");
  }

  final public Element ActualColumnReference(String name, boolean setXSIType) throws ParseException {
    String table;
    String cname;
    jj_consume_token(S_IDENTIFIER);
                    table=token.image;
    jj_consume_token(77);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
      jj_consume_token(S_IDENTIFIER);
      break;
    case 78:
      jj_consume_token(78);
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                            cname=token.image;
        Element c = createADQLElement(name);
        if (setXSIType) setXSITypeAttr(c, "columnReferenceType");
        c.setAttribute("Table", table);
        c.setAttribute("Name", cname);
        {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

  final public Element XPathReference(String name, boolean setXSIType) throws ParseException {
    String table;
    String cname;
    StringBuffer sb = new StringBuffer();
    jj_consume_token(S_XPATH);
                cname=token.image;
        Element c = createADQLElement(name);
        if (setXSIType) setXSITypeAttr(c, "columnReferenceType");
        c.setAttribute("Table", "");
        c.setAttribute("xpathName", cname);
        int s = cname.lastIndexOf("/");
        if (s < 0)
           c.setAttribute("name", cname);
        else
           c.setAttribute("name", cname.substring(s+1));

        {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

  final public void RelativeXPath(StringBuffer sb) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 79:
      jj_consume_token(79);
           sb.append(token.image);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    jj_consume_token(S_IDENTIFIER);
                    sb.append(token.image);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 80:
      jj_consume_token(80);
           sb.append(token.image);
      RelativeXPath(sb);
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }

  }

  final public Element ComparisonPred(String name, boolean setXSIType) throws ParseException {
    String divider;
    Element last;
    Element arg1, arg2;
    arg1 = ScalarExpression("Arg");
    divider = ComparisonDivider();
    arg2 = ScalarExpression("Arg");
         Element c = createADQLElement(name);
         Matcher like =
             Pattern.compile(".*LIKE",
                             Pattern.CASE_INSENSITIVE).matcher(divider);
         Matcher not =
           Pattern.compile("NOT.*", Pattern.CASE_INSENSITIVE).matcher(divider);
         if (like.matches()) {
             arg2 = renameADQLElement(arg2, "Pattern", null);
             if (setXSIType) {
                 if (not.matches()) {
                     setXSITypeAttr(c, "notLikePredType");
                 } else {
                     setXSITypeAttr(c, "likePredType");
                 }
             }
         } else {
             if (setXSIType) setXSITypeAttr(c, "comparisonPredType");
             c.setAttribute("Comparison", divider);
         }
         c.appendChild(arg1);
         c.appendChild(arg2);
         {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

  final public String ComparisonDivider() throws ParseException {
    String value="";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
      value = Comparison();
      break;
    case K_LIKE:
    case K_NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_NOT:
        jj_consume_token(K_NOT);
              value = "NOT ";
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      jj_consume_token(K_LIKE);
                                          value += token.image;
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public String Comparison() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 81:
      jj_consume_token(81);
      break;
    case 82:
      jj_consume_token(82);
      break;
    case 83:
      jj_consume_token(83);
      break;
    case 84:
      jj_consume_token(84);
      break;
    case 85:
      jj_consume_token(85);
      break;
    case 86:
      jj_consume_token(86);
      break;
    case 87:
      jj_consume_token(87);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public Element IntersectionSearch(String name, boolean setXSIType) throws ParseException {
    Element arg1, arg2;
    arg1 = IntersectionElement(name, true);
    label_1:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
      jj_consume_token(K_AND);
      arg2 = IntersectionElement("Condition", true);
          arg1 = renameADQLElement(arg1, "Condition", null);
//          doc.renameNode(arg1, ADQL_NS, ADQL_PREFIX + ":Condition");
          Element is = createADQLElement(name);
          if (setXSIType) setXSITypeAttr(is, "intersectionSearchType");
          is.appendChild(arg1);
          is.appendChild(arg2);
          arg1 = is;
    }
           {if (true) return arg1;}
    throw new Error("Missing return statement in function");
  }

  final public Element IntersectionElement(String name, boolean setXSIType) throws ParseException {
    Element s;
    if (jj_2_2(2147483647)) {
      s = ClosedSearch(name, true);
    } else if (jj_2_3(2147483647)) {
      s = BetweenPred(name, true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_NOT:
        s = InverseSearch(name, true);
        break;
      case K_AVG:
      case K_COUNT:
      case K_MAX:
      case K_MIN:
      case K_SUM:
      case K_asin:
      case K_acos:
      case K_atan:
      case K_atan2:
      case K_cos:
      case K_sin:
      case K_tan:
      case K_abs:
      case K_ceiling:
      case K_degrees:
      case K_exp:
      case K_floor:
      case K_log:
      case K_log10:
      case K_pi:
      case K_rand:
      case K_round:
      case K_square:
      case K_sqrt:
      case K_truncate:
      case S_REAL:
      case S_INTEGER:
      case S_XPATH:
      case S_CHAR_LITERAL:
      case 75:
      case 88:
      case 89:
        s = ComparisonPred(name, true);
        break;
      case K_REGION:
        s = RegionSearch(name, true);
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
          {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Element InverseSearch(String name, boolean setXSIType) throws ParseException {
    Element s;
    jj_consume_token(K_NOT);
    s = Search("Condition");
          Element is = createADQLElement(name);
          if (setXSIType) setXSITypeAttr(is, "inverseSearchType");
          is.appendChild(s);
          {if (true) return is;}
    throw new Error("Missing return statement in function");
  }

  final public Element Literal(String name, boolean setXSIType) throws ParseException {
    Element l;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_REAL:
    case S_INTEGER:
      l = Number(name, true);
      break;
    case S_CHAR_LITERAL:
      l = XString(name, true);
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return l;}
    throw new Error("Missing return statement in function");
  }

  final public Element Number(String name, boolean setXSIType) throws ParseException {
   Element num = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_REAL:
      jj_consume_token(S_REAL);
          num = createADQLElement(name);
          if (setXSIType) setXSITypeAttr(num, "realType");
          num.setAttribute("Value", token.image);
          {if (true) return num;}
      break;
    case S_INTEGER:
      jj_consume_token(S_INTEGER);
          num = createADQLElement(name);
          if (setXSIType) setXSITypeAttr(num, "integerType");
          num.setAttribute("Value", token.image);
          {if (true) return num;}
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Element RegionSearch(String name, boolean setXSIType) throws ParseException {
    String literal;
    jj_consume_token(K_REGION);
    jj_consume_token(75);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_CHAR_LITERAL:
      jj_consume_token(S_CHAR_LITERAL);
      break;
    case S_QUOTED_IDENTIFIER:
      jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                              literal = token.image;
    jj_consume_token(76);
          // Get rid of quotes
          literal = literal.substring(1, literal.length()-1);
          Pattern p = Pattern.compile(" ");
          String[] flds = p.split(literal);
          if (flds.length != 5) {
              {if (true) throw new ParseException("Error parsing region literal:"+literal);}
          }

          if (! flds[0].toUpperCase().equals("CIRCLE")  ||
              ! flds[1].toUpperCase().equals("J2000")) {
              {if (true) throw new ParseException("Unsupported region type, or coordinate system.  Only CIRCLE J2000 supported. "+flds[0]+":"+flds[1]);}
          }

          Element rs = createADQLElement(name);
          if (setXSIType) setXSITypeAttr(rs, "regionSearchType");

          Element ct = createADQLElement("Region");
          ct.setAttribute("unit", "deg");
          ct.setAttributeNS(XSI_NS, "xsi:type", STCR_PREFIX + ":circleType");
          rs.appendChild(ct);

          Element cen = createSTCRElement("Center");
          Node txt = doc.createTextNode(flds[2] + " " + flds[3]);
          cen.appendChild(txt);
          ct.appendChild(cen);

          double radius;
          if (flds[4].endsWith("\"")) {
            radius =
              Double.parseDouble(flds[4].substring(0, flds[4].length()-1))/3660;
            flds[4] = Double.toString(radius);
          } else if (flds[4].endsWith("'")) {
            radius =
              Double.parseDouble(flds[4].substring(0, flds[4].length()-1))/60;
            flds[4] = Double.toString(radius);
          } else {
              radius = Double.parseDouble(flds[4]);
          }
          Element rad = createSTCRElement("Radius");
          txt = doc.createTextNode(flds[4]);
          rad.appendChild(txt);
          ct.appendChild(rad);

          {if (true) return rs;}
    throw new Error("Missing return statement in function");
  }

  final public Element ScalarExpression(String name) throws ParseException {
     Element s;
    s = PlusExpr(name);
          {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Element PlusExpr(String name) throws ParseException {
     Element arg1, arg2;
     String op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AVG:
    case K_COUNT:
    case K_MAX:
    case K_MIN:
    case K_SUM:
    case K_asin:
    case K_acos:
    case K_atan:
    case K_atan2:
    case K_cos:
    case K_sin:
    case K_tan:
    case K_abs:
    case K_ceiling:
    case K_degrees:
    case K_exp:
    case K_floor:
    case K_log:
    case K_log10:
    case K_pi:
    case K_rand:
    case K_round:
    case K_square:
    case K_sqrt:
    case K_truncate:
    case S_REAL:
    case S_INTEGER:
    case S_XPATH:
    case S_CHAR_LITERAL:
    case 75:
      arg1 = MultExpr(name, true);
      label_2:
      while (true) {
        if (jj_2_4(2)) {
          ;
        } else {
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 88:
          jj_consume_token(88);
          break;
        case 89:
          jj_consume_token(89);
          break;
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                    op = token.image;
        arg2 = MultExpr("Arg", true);
              arg1 = renameADQLElement(arg1, "Arg", null);
              Element be = getBinaryExpr(name, true, arg1, arg2, op);
              arg1 = be;
      }
          {if (true) return arg1;}
      break;
    case 88:
    case 89:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 88:
        jj_consume_token(88);
        break;
      case 89:
        jj_consume_token(89);
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                    op = token.image;
      arg1 = MultExpr(name, true);
          // Handle unary +/- for numeric constants.
          if (matchesXSIType(arg1, ADQL_PREFIX + ":AtomType")) {
              Element lit = getChildByTag(arg1, "Literal");
              if (lit != null &&
                  (matchesXSIType(lit,ADQL_PREFIX + ":IntegerType") ||
                   matchesXSIType(lit,ADQL_PREFIX + ":RealType")) )
              {
                  if (op.equals("-")) {
                      String val = arg1.getAttribute("Value");
                      if (val != null) {
                          if (val.trim().startsWith("-")) {
                              val = val.trim().substring(1);
                          } else if (val.trim().startsWith("+")) {
                              val = "-" + val.trim().substring(1);
                          } else {
                              val = "-" + val.trim();
                          }
                          arg1.setAttribute("Value", val);
                      }
                  }
              }
          } else {

              Element un = createADQLElement(name);
              setXSITypeAttr(un, "unaryType");
              un.setAttribute("Oper", op);
              un.appendChild(arg1);
              arg1 =  un;
          }
      label_3:
      while (true) {
        if (jj_2_5(2)) {
          ;
        } else {
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 88:
          jj_consume_token(88);
          break;
        case 89:
          jj_consume_token(89);
          break;
        default:
          jj_la1[19] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                            op = token.image;
        arg2 = MultExpr("Arg", true);
                  arg1 = renameADQLElement(arg1, "Arg", null);
//                  doc.renameNode(arg1, ADQL_NS, ADQL_PREFIX + ":Arg");
                  Element be = getBinaryExpr(name, true, arg1, arg2, op);
                  arg1 = be;
      }
          {if (true) return arg1;}
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Element MultExpr(String name, boolean setXSIType) throws ParseException {
     Element arg1, arg2;
     String op;
    arg1 = UnitExpr(name, true);
    label_4:
    while (true) {
      if (jj_2_6(2)) {
        ;
      } else {
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 78:
        jj_consume_token(78);
        break;
      case 80:
        jj_consume_token(80);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                       op = token.image;
      arg2 = UnitExpr("Arg", true);
          arg1 = renameADQLElement(arg1, "Arg", null);
          Element be = getBinaryExpr(name, true, arg1, arg2, op);
          arg1 = be;
    }
          {if (true) return arg1;}
    throw new Error("Missing return statement in function");
  }

  final public Element UnitExpr(String name, boolean setXSIType) throws ParseException {
     Element s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_REAL:
    case S_INTEGER:
    case S_CHAR_LITERAL:
      s = Atom(name, true);
      break;
    case 75:
      s = ClosedExpr(name, true);
      break;
    case S_XPATH:
      s = ColumnReference(name, true);
      break;
    case K_AVG:
    case K_COUNT:
    case K_MAX:
    case K_MIN:
    case K_SUM:
    case K_asin:
    case K_acos:
    case K_atan:
    case K_atan2:
    case K_cos:
    case K_sin:
    case K_tan:
    case K_abs:
    case K_ceiling:
    case K_degrees:
    case K_exp:
    case K_floor:
    case K_log:
    case K_log10:
    case K_pi:
    case K_rand:
    case K_round:
    case K_square:
    case K_sqrt:
    case K_truncate:
      s = FunctionOfOneVar(name, true);
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Element Search(String name) throws ParseException {
    Element s;
    s = UnionSearch(name, true);
          {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Element XString(String name, boolean setXSIType) throws ParseException {
    jj_consume_token(S_CHAR_LITERAL);
          Element lit = createADQLElement(name);
          if (setXSIType) setXSITypeAttr(lit, "stringType");

          String val = token.image;
          val = val.substring(1,val.length()-1);
          Matcher m = Pattern.compile("''").matcher(val);
          val = m.replaceAll("'");

          lit.setAttribute("Value", val);
          {if (true) return lit;}
    throw new Error("Missing return statement in function");
  }

  final public Element UnionSearch(String name, boolean setXSIType) throws ParseException {
    Element arg1, arg2;
    arg1 = IntersectionSearch(name, true);
    label_5:
    while (true) {
      if (jj_2_7(2)) {
        ;
      } else {
        break label_5;
      }
      jj_consume_token(K_OR);
      arg2 = IntersectionSearch("Condition", true);
                  arg1 = renameADQLElement(arg1, "Condition", null);
//                  doc.renameNode(arg1, ADQL_NS, ADQL_PREFIX + ":Condition");
                  Element us = createADQLElement(name);
                  if (setXSIType) setXSITypeAttr(us, "unionSearchType");
                  us.appendChild(arg1);
                  us.appendChild(arg2);
                  arg1 = us;
    }
          {if (true) return arg1;}
    throw new Error("Missing return statement in function");
  }

  final public Element Where(String name) throws ParseException {
     Element cond;
    jj_consume_token(K_WHERE);
    cond = Search("Condition");
           Element w = (name == null) ? createRootElement("Where")
                                      : createADQLElement(name);
           w.appendChild(cond);
           {if (true) return w;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_3R_40() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    }
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(75)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(76)) return true;
    return false;
  }

  final private boolean jj_3R_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(K_NOT)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) return true;
    }
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_9() {
    if (jj_3R_10()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_6()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_7()) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_8() {
    if (jj_3R_18()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_19()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_3R_7()) return true;
    return false;
  }

  final private boolean jj_3R_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_12()) {
    jj_scanpos = xsp;
    if (jj_3R_13()) {
    jj_scanpos = xsp;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(S_PROTECTED)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) return true;
    }
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_6()) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_35()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_3R_6()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_1()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    if (jj_3R_9()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_5()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) jj_scanpos = xsp;
    if (jj_scan_token(K_LIKE)) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    }
    }
    if (jj_scan_token(75)) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(76)) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    return false;
  }

  final private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_3R_9()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    return false;
  }

  final private boolean jj_3R_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_3R_18()) return true;
    if (jj_3R_49()) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(S_XPATH)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_3R_11()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_7()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(K_REGION)) return true;
    if (jj_scan_token(75)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) return true;
    }
    if (jj_scan_token(76)) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(S_INTEGER)) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(S_REAL)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_7() {
    if (jj_scan_token(75)) return true;
    if (jj_3R_17()) return true;
    if (jj_scan_token(76)) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_46()) return true;
    return false;
  }

  public Where2DOMTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[23];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0xc0000000,0x0,0xc0000000,0x0,0x0,0x400000,0x0,0x0,0x0,0x400000,0x600000,0x0,0xc0400000,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0xc0000000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x1f3fc00,0x7,0x3f8,0x1f3ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1bf3ffff,0x18000000,0x18000000,0x0,0x0,0x0,0x0,0x19f3ffff,0x0,0x19f3ffff,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x50,0x50,0x0,0x4010,0x8000,0x10000,0x0,0xfe0000,0xfe0000,0x3000a08,0x200,0x0,0x600,0x3000000,0x3000000,0x3000000,0x3000a08,0x14000,0xa08,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Where2DOM(java.io.InputStream stream) {
    this();
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new Where2DOMTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Where2DOM(java.io.Reader stream) {
    this();
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new Where2DOMTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Where2DOM(Where2DOMTokenManager tm) {
    this();
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(Where2DOMTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 23; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[90];
    for (int i = 0; i < 90; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 23; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 90; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
