/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.registry.search;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Metadata {
    private Node del = null;
    private String parentPath = null;
    protected HashMap cache = new HashMap();
    protected static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";

    public Metadata(Node el) {
        this.del = el;
        this.parentPath = el.getNodeName();
    }

    public Metadata(Node el, String path) {
        this.del = el;
        this.parentPath = path;
    }

    public Node getDOMNode() {
        return this.del;
    }

    public String getPathName() {
        return this.parentPath;
    }

    protected List findBlocks(String path) throws IllegalArgumentException {
        MatchedBlocks matched = new MatchedBlocks(this);
        StringTokenizer tok = new StringTokenizer(path, "/");
        while (tok.hasMoreTokens()) {
            boolean attrOnly = false;
            String name = tok.nextToken();
            if (name.startsWith("@")) {
                if (tok.hasMoreTokens()) {
                    throw new IllegalArgumentException("Illegal path: " + path);
                }
                attrOnly = true;
                name = name.substring(1);
            }
            int len = matched.size();
            for (int i = 0; i < len; ++i) {
                Metadata candidate = matched.pop();
                boolean findElements = true;
                Node node = candidate.getDOMNode();
                if (!tok.hasMoreTokens() && node.getNodeType() == 1) {
                    Attr att;
                    Attr attr = att = name.equals("xsi:type") ? ((Element)node).getAttributeNodeNS(XSI_NS, "type") : ((Element)node).getAttributeNode(name);
                    if (att != null) {
                        matched.appendNode(att, candidate.getPathName());
                    }
                    if (attrOnly) {
                        findElements = false;
                    }
                }
                if (!findElements) continue;
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
                    matched.appendNode(node, candidate.getPathName());
                }
            }
        }
        return matched;
    }

    public Metadata[] getBlocks(String path) throws IllegalArgumentException {
        List matched = this.findBlocks(path);
        Metadata[] out = new Metadata[matched.size()];
        ListIterator iter = matched.listIterator();
        for (int i = 0; i < out.length && iter.hasNext(); ++i) {
            out[i] = (Metadata)iter.next();
        }
        return out;
    }

    public String[] getParameters(String path) {
        String[] out = (String[])this.cache.get(path);
        if (out != null) {
            return out;
        }
        List matched = this.findBlocks(path);
        LinkedList<String> values = new LinkedList<String>();
        ListIterator iter = matched.listIterator();
        while (iter.hasNext()) {
            Node node = ((Metadata)iter.next()).getDOMNode();
            if (node.getNodeType() == 2) {
                values.addLast(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            for (node = node.getFirstChild(); node != null && node.getNodeType() != 3; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                node = null;
                break;
            }
            if (node == null) continue;
            values.addLast(node.getNodeValue().trim());
        }
        out = new String[values.size()];
        iter = values.listIterator();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (String)iter.next();
        }
        this.cache.put(path, out);
        return out;
    }

    public String getParameter(String path) {
        String[] out = this.getParameters(path);
        return out != null && out.length > 0 ? out[0] : null;
    }

    public String getXSIType() {
        if (this.del.getNodeType() != 1) {
            return null;
        }
        String out = ((Element)this.del).getAttributeNS(XSI_NS, "type");
        if (out == null) {
            return null;
        }
        int c = out.indexOf(":");
        if (c >= 0) {
            out = out.substring(c + 1);
        }
        return out;
    }

    public void clearCache() {
        this.cache.clear();
    }

    class MatchedBlocks
    extends LinkedList {
        public MatchedBlocks(Metadata first) {
            this.addLast(first);
        }

        public void appendNode(Node node, String base) {
            this.addLast(new Metadata(node, base + "/" + node.getNodeName()));
        }

        public Metadata pop() {
            return (Metadata)this.removeFirst();
        }
    }
}

