echo off
REM 
REM regsearch:  query an IVOA searchable registry. 
REM
REM    This rudimentary command line interface provides access to a
REM    registry's search functions via six commands.  Various options--some
REM    command specific--allow you to select out the information.
REM
REM    If you do not provide any arguments regsearch will run some internal 
REM    tests.  
REM
REM Usage:  regsearch -e url [ options ] command [ args ] 
REM General Options:
REM   -e url         the registry search service endpoint URL.  If none is 
REM                     provided, regsearch will run in a self-test mode without
REM                     contacting a real registry; search inputs are generally
REM                     ignored.
REM   -v             verbose mode; print extra messages
REM   -x             print to standard out the request and response SOAP messages 
REM Arguments:
REM   command        the (case-insensitive) name of the registry function to 
REM                  access:
REM                     getidentity       return the description of the registry
REM                     getresource       return the description of the resource 
REM                                         specified by an identifier
REM                     searchbyadql      search for resources whose 
REM                                         descriptions match ADQL constraints
REM                     searchbykeywords  search for resources whose descriptions
REM                                         contain given keywords
REM                     idsbyadql         return just IDs of resources whose 
REM                                         descriptions match ADQL constraints
REM                     idsbykeywords     return just IDs of resources whose 
REM                                         descriptions contain given keywords
REM                  see below for command specific options
REM
REM GetIdentity:  return the description of the registry
REM Usage:  regsearch -e url [ -v ] [-s metadatum[,...]] getidentity
REM Options:
REM   -s metadatum,...  a list of metadata values to print.  Each item is a
REM                      simple XPath pointer to a VOResource element.  If not
REM                      provided, the following are returned:
REM                         identifier,title,capability/interface/accessURL
REM
REM GetResource: return the description of the resource specified by an identifier
REM Usage:  regsearch -e url [ -v ] [-s metadatum[,...]] getResource id
REM Options:
REM   -s metadatum,...  a list of metadata to print (same as for getIdentity)
REM Arguments:
REM   id                the IVOA identifier of the resource of interest
REM
REM SearchByADLQ: search for resources whose descriptions match ADQL constraints 
REM Usage:  regsearch -e url [-v -m max] [-s metadatum[,...]] SearchByADLQ adql
REM Options:
REM   -m max           the maximum number of records to print out
REM   -s metadatum,... a list of metadata to print (same as for getIdentity)
REM Arguments:
REM   adql             the ADQL constraints to apply (e.g. "title like '%quasars%'
REM                      and [capability/@xsi:type] like '%ConeSearch'")
REM
REM IDsByADLQ: return just the identifiers of resources whose descriptions 
REM            match ADQL constraints 
REM Usage:  regsearch -e url [-v -m max] [-s metadatum[,...]] SearchByADLQ adql
REM Options:
REM   -m max           the maximum number of identifiers to print out
REM Arguments:
REM   adql             the ADQL constraints to apply (e.g. "title like '%quasars%'
REM                      and [capability/@xsi:type] like '%ConeSearch'")
REM
REM SearchByKeywords: search for resources whose descriptions contain given 
REM                   keywords
REM Usage:  regsearch -e url [-vo -m max] searchbykeywords keyword ...
REM Options:
REM   -m max            the maximum number of records to print out
REM   -o                logical OR: return records if the descriptions contain
REM                        any of the keywords.  If not set, the matched records
REM                        must contain all of the keywords
REM Arguments:
REM   keyword           a word to search for
REM
REM IDsByKeywords: return just the identifiers of resources whose descriptions 
REM                contain given keywords
REM Usage:  regsearch -e url [-vo -m max] searchbykeywords keyword ...
REM Options:
REM   -m max            the maximum number of identifiers to print out
REM   -o                logical OR: return records if the descriptions contain
REM                        any of the keywords.  If not set, the matched records
REM                        must contain all of the keywords
REM Arguments:
REM   keyword           a word to search for
REM 
set ERR=

set BIN=
if not "%JAVA_HOME%"=="" set BIN="%JAVA_HOME%\bin\"

set IVOAREG_HOME=@IVOAREG_HOME@

set cp=%IVOAREG_HOME%/lib/ivoaregistry.jar;%IVOAREG_HOME%/lib/saaj.jar
set cp=%cp%;%IVOAREG_HOME%/lib/axis.jar;%IVOAREG_HOME%/lib/jaxrpc.jar
set cp=%cp%;%IVOAREG_HOME%/lib/commons-logging-1.0.4.jar
set cp=%cp%;%IVOAREG_HOME%/lib/commons-discovery-0.2.jar
set cp=%cp%;%IVOAREG_HOME%/lib/activation.jar;%IVOAREG_HOME%/lib/mail.jar
set cp=%cp%;%IVOAREG_HOME%/lib/wsdl4j-1.5.1.jar
set cp=%cp%;%IVOAREG_HOME%/lib/log4j-1.2.8.jar;%IVOAREG_HOME%/lib;%CLASSPATH%

if "%ERR%"=="" %BIN%java -cp %cp% net.ivoa.registry.search.test.TestRegistryClient %*%

