/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.adql.convert;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import net.ivoa.adql.convert.ADQLs2DOMParser;
import net.ivoa.adql.convert.S2XTransformer;
import net.ivoa.util.Configuration;
import org.w3c.dom.Element;

public class DOMParser2XML
implements S2XTransformer {
    protected Transformer identTransformer = null;
    protected short nsmode = 0;
    protected int indent = 1;
    protected Configuration config = null;
    private Constructor parserConstructor = null;
    protected String version = null;
    public static final String PRETTY_INDENT_PARAM = "prettyIndent";
    public static final String NS_MODE_PARAM = "nsMode";
    public static final String PARSER_CLASS_PARAM = "parser";
    public static final String VERSION_PARAM = "version";
    public static final String DEFAULT_VERSION = "v1.0";
    private static Hashtable modes = new Hashtable();
    private static Properties parsers;
    static /* synthetic */ Class class$net$ivoa$adql$convert$ADQLs2DOMParser;
    static /* synthetic */ Class class$java$io$Reader;

    public void init(Configuration conf) throws TransformerException {
        Short val;
        String mode;
        String parsercl;
        this.config = conf;
        this.version = this.config.getParameter(VERSION_PARAM);
        if (this.version == null) {
            this.version = DEFAULT_VERSION;
        }
        if ((parsercl = this.config.getParameter(PARSER_CLASS_PARAM)) == null) {
            parsercl = parsers.getProperty(this.version);
        }
        if (parsercl == null) {
            throw new TransformerException("Unable to determine proper parser class for version " + this.version);
        }
        try {
            Class<?> cl = Class.forName(parsercl);
            if (!(class$net$ivoa$adql$convert$ADQLs2DOMParser == null ? (class$net$ivoa$adql$convert$ADQLs2DOMParser = DOMParser2XML.class$("net.ivoa.adql.convert.ADQLs2DOMParser")) : class$net$ivoa$adql$convert$ADQLs2DOMParser).isAssignableFrom(cl)) {
                throw new TransformerException(parsercl + ": not an S2XTransformer class");
            }
            this.parserConstructor = this.findConstructor(cl);
        }
        catch (ClassNotFoundException e) {
            throw new TransformerException(parsercl + ": class not found");
        }
        String indentVal = this.config.getParameter(PRETTY_INDENT_PARAM);
        if (indentVal != null) {
            try {
                this.indent = Integer.parseInt(indentVal);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((mode = this.config.getParameter(NS_MODE_PARAM)) != null && (val = (Short)modes.get(mode.toLowerCase())) != null) {
            this.nsmode = val;
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        this.identTransformer = tFactory.newTransformer();
    }

    public String getADQLVersion() {
        return this.version;
    }

    private Constructor findConstructor(Class cl) throws TransformerException {
        try {
            Constructor out = cl.getConstructor(class$java$io$Reader == null ? (class$java$io$Reader = DOMParser2XML.class$("java.io.Reader")) : class$java$io$Reader);
            return out;
        }
        catch (NoSuchMethodException ex) {
            throw new TransformerException(ex);
        }
    }

    public void transform(String adqls, Result out) throws TransformerException, IllegalStateException {
        if (this.identTransformer == null) {
            throw new IllegalStateException("DOMParser2XML tranformer not initialized (call init())");
        }
        ADQLs2DOMParser parser = this.createParser(new StringReader(adqls));
        parser.setIndent(this.indent);
        parser.setNSMode(this.nsmode);
        Element domroot = parser.parseSelect();
        parser.indent();
        DOMSource source = new DOMSource(domroot.getOwnerDocument());
        this.identTransformer.transform(source, out);
    }

    protected ADQLs2DOMParser createParser(Reader input) throws TransformerException {
        if (this.parserConstructor == null) {
            throw new IllegalStateException("DOMParser2XML's parser not configured (call init())");
        }
        try {
            return (ADQLs2DOMParser)this.parserConstructor.newInstance(input);
        }
        catch (InstantiationException ex) {
            throw new TransformerException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransformerException(ex.getCause());
        }
        catch (IllegalArgumentException ex) {
            throw new InternalError("programmer error: bad argument to ADQLs2DOMParser constructor");
        }
        catch (IllegalAccessException ex) {
            throw new InternalError("programmer error: non-public ADQLs2DOMParser constructor");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        modes.put("default_ns", new Short(1));
        modes.put("always_qualified", new Short(0));
        parsers = new Properties();
        parsers.setProperty("v0.7.4", "net.ivoa.adql.convert.parser.v0_7_4.ADQLParser");
        parsers.setProperty(DEFAULT_VERSION, "net.ivoa.adql.convert.parser.v1_0.ADQLParser");
    }
}

