/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.adql.convert;

import java.io.File;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.ivoa.adql.convert.X2STransformer;
import net.ivoa.util.Configuration;

public class XSLx2s
implements X2STransformer {
    protected String vers = "v1.05";
    protected Transformer xslTransformer = null;
    protected Configuration config = null;
    protected String version = "v1.05";
    public static final String STYLESHEET_PARAM = "stylesheet";
    public static final String VERSION_PARAM = "version";
    public static final String DEFAULT_VERSION = "v1.05";

    public void init(Configuration conf) throws TransformerException {
        this.config = conf;
        this.version = this.config.getParameter(VERSION_PARAM);
        if (this.version == null) {
            this.version = DEFAULT_VERSION;
        }
        this.loadStylesheet();
    }

    public String getADQLVersion() {
        return this.version;
    }

    protected void loadStylesheet() throws TransformerException {
        String xslfname = this.config.getParameter(STYLESHEET_PARAM);
        String xslurl = null;
        File xslfile = new File(xslfname);
        try {
            URL url;
            URL uRL = url = xslfile.exists() ? xslfile.toURI().toURL() : this.getClass().getClassLoader().getResource(xslfname);
            if (url != null) {
                xslurl = url.toString();
            }
        }
        catch (MalformedURLException ex) {
            xslurl = "file:" + xslfile.toString();
        }
        if (xslurl == null) {
            throw new TransformerException("stylesheet not found: " + xslfile);
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        this.xslTransformer = tFactory.newTransformer(new StreamSource(xslurl));
    }

    public String transform(Source adqlx) throws TransformerException {
        if (this.xslTransformer == null) {
            throw new IllegalStateException("Unitialized X2STransformer");
        }
        StringWriter result = new StringWriter();
        this.xslTransformer.transform(adqlx, new StreamResult(result));
        result.flush();
        return result.toString();
    }
}

